/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.tls.provider;

import com.bea.sslplus.WeblogicHandler;
import com.certicom.locale.Resources;
import com.certicom.tls.ciphersuite.CryptoNames;
import com.certicom.tls.provider.cipher.ECCpresso_AESCBCNoPad;
import com.certicom.tls.provider.cipher.ECCpresso_RC4;
import com.certicom.tls.provider.cipher.ECCpresso_RSACipher;
import com.certicom.tls.provider.cipher.JSAFE_RSA;
import com.certicom.tls.provider.cipher.NullCipher;
import com.certicom.tls.provider.cipher.des.ECCpresso_DESCBCNoPad;
import java.io.ByteArrayOutputStream;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import weblogic.jce.WLCipher;

public class Cipher
implements CryptoNames {
    public static final int ENCRYPT_MODE = 1;
    public static final int DECRYPT_MODE = 2;
    private javax.crypto.Cipher jceCipher;
    private boolean dontUseIV = false;
    private int updateLimit = 0;

    private byte[] updateWithFragmentLimit(byte[] byArray, int n, int n2, boolean bl) throws IllegalStateException {
        if (this.updateLimit <= 0) {
            throw new IllegalStateException("updateLimit <= 0");
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            int n3 = n2;
            int n4 = this.updateLimit;
            while (n3 > 0) {
                boolean bl2 = n3 <= this.updateLimit;
                n4 = bl2 ? n3 : this.updateLimit;
                byte[] byArray2 = bl && bl2 ? this.jceCipher.doFinal(byArray, n, n4) : this.jceCipher.update(byArray, n, n4);
                byteArrayOutputStream.write(byArray2);
                n3 -= n4;
                n += n4;
            }
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_ERROR)) {
                WeblogicHandler.debug(WeblogicHandler.DEBUG_ERROR, "Failed to update with fragment limit", exception);
            }
            throw new IllegalStateException(exception.getMessage());
        }
    }

    public Provider getProvider() {
        if (this.jceCipher == null) {
            return null;
        }
        return WLCipher.getProvider((javax.crypto.Cipher)this.jceCipher);
    }

    private Cipher(javax.crypto.Cipher cipher) {
        this.jceCipher = cipher;
    }

    protected Cipher() {
    }

    public static final Cipher getInstance(String string) throws NoSuchAlgorithmException {
        Object object;
        if (string.equalsIgnoreCase("NullCipher")) {
            return new NullCipher();
        }
        try {
            if (WeblogicHandler.useJCEProvider()) {
                object = null;
                String string2 = string;
                if (string.equals("RSA/ECB/PKCS1Padding")) {
                    string2 = "RSA";
                } else if (string.equals("DES") || string.equals("DESede") || string.equals("AES")) {
                    string2 = string + "/CBC/NoPadding";
                }
                object = WLCipher.getInstance((String)string2);
                Provider provider = WLCipher.getProvider((javax.crypto.Cipher)object);
                String string3 = provider.getName();
                if (WeblogicHandler.isSupportedCipher(string3)) {
                    Cipher cipher = new Cipher((javax.crypto.Cipher)object);
                    if (string.startsWith("DES") && string3.startsWith("nCipherKM")) {
                        cipher.updateLimit = WeblogicHandler.getOverrideSSLFragmentSize();
                        if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_INFO)) {
                            WeblogicHandler.debug(WeblogicHandler.DEBUG_INFO, "Detected nCipherKM for DES support, limiting SSL fragment size to: " + cipher.updateLimit, null);
                        }
                    } else if (string.equals("RC4")) {
                        cipher.dontUseIV = true;
                    }
                    if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_INFO)) {
                        WeblogicHandler.debug(WeblogicHandler.DEBUG_INFO, "Using JCE Cipher: " + provider + " for algorithm " + string2, null);
                    }
                    return cipher;
                }
                if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_INFO)) {
                    WeblogicHandler.debug(WeblogicHandler.DEBUG_INFO, "Ignoring not supported JCE Cipher: " + provider + " for algorithm " + string2, null);
                }
            }
        }
        catch (Throwable throwable) {
            WeblogicHandler.debugEaten(throwable);
        }
        if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_INFO)) {
            WeblogicHandler.debug(WeblogicHandler.DEBUG_INFO, "Will use default Cipher for algorithm " + string, null);
        }
        try {
            if (string.equalsIgnoreCase("NullCipher")) {
                return new NullCipher();
            }
            if (string.equalsIgnoreCase("RC4")) {
                return new ECCpresso_RC4();
            }
            if (string.equalsIgnoreCase("DES")) {
                return new ECCpresso_DESCBCNoPad("DES");
            }
            if (string.equalsIgnoreCase("AES")) {
                return new ECCpresso_AESCBCNoPad();
            }
            if (string.equalsIgnoreCase("DESede")) {
                return new ECCpresso_DESCBCNoPad("TDES");
            }
            if (string.equals("RSA/ECB/PKCS1Padding") || string.equals("RSA/ECB/NoPadding")) {
                try {
                    return new JSAFE_RSA(string);
                }
                catch (Throwable throwable) {
                    WeblogicHandler.debugEaten(throwable);
                    try {
                        return new ECCpresso_RSACipher(string);
                    }
                    catch (Throwable throwable2) {
                        WeblogicHandler.debugEaten(throwable2);
                    }
                }
            }
        }
        catch (Throwable throwable) {
            WeblogicHandler.debugEaten(throwable);
        }
        object = string + Resources.getMessage("84");
        throw new NoSuchAlgorithmException((String)object);
    }

    public int getBlockSize() {
        return this.jceCipher.getBlockSize();
    }

    public int getOutputSize(int n) {
        return this.jceCipher.getOutputSize(n);
    }

    public void init(int n, Key key, byte[] byArray) {
        try {
            int n2 = 0;
            n2 = n == 1 ? 1 : 2;
            byte[] byArray2 = (byte[])key.getEncoded().clone();
            if (this.jceCipher.getAlgorithm().startsWith("DES")) {
                for (int i = 0; i < byArray2.length; ++i) {
                    int n3 = byArray2[i] & 0xFF;
                    n3 >>= 1;
                    int n4 = 0;
                    for (int j = 0; j < 7; ++j) {
                        if (n3 % 2 == 1) {
                            ++n4;
                        }
                        n3 >>= 1;
                    }
                    if (n4 % 2 == 0) {
                        int n5 = i;
                        byArray2[n5] = (byte)(byArray2[n5] | 1);
                        continue;
                    }
                    int n6 = i;
                    byArray2[n6] = (byte)(byArray2[n6] & 0xFE);
                }
            }
            SecretKeySpec secretKeySpec = new SecretKeySpec(byArray2, key.getAlgorithm());
            if (byArray != null && !this.dontUseIV) {
                IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray);
                this.jceCipher.init(n, (Key)secretKeySpec, ivParameterSpec);
            } else {
                this.jceCipher.init(n, secretKeySpec);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            WeblogicHandler.debugEaten(exception);
        }
    }

    public byte[] update(byte[] byArray) throws IllegalStateException {
        byte[] byArray2;
        byte[] byArray3 = byArray2 = this.updateLimit > 0 && byArray.length > this.updateLimit ? this.updateWithFragmentLimit(byArray, 0, byArray.length, false) : this.jceCipher.update(byArray);
        if (byArray2 == null) {
            return new byte[0];
        }
        return byArray2;
    }

    public byte[] update(byte[] byArray, int n, int n2) throws IllegalStateException {
        byte[] byArray2;
        byte[] byArray3 = byArray2 = this.updateLimit > 0 && n2 > this.updateLimit ? this.updateWithFragmentLimit(byArray, n, n2, false) : this.jceCipher.update(byArray, n, n2);
        if (byArray2 == null) {
            return new byte[0];
        }
        return byArray2;
    }

    public void init(int n, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        this.jceCipher.init(n, key, secureRandom);
    }

    public byte[] doFinal(byte[] byArray, int n, int n2) throws IllegalStateException {
        try {
            return this.updateLimit > 0 && n2 > this.updateLimit ? this.updateWithFragmentLimit(byArray, n, n2, true) : this.jceCipher.doFinal(byArray, n, n2);
        }
        catch (Exception exception) {
            WeblogicHandler.debugEaten(exception);
            throw new IllegalStateException(exception.getMessage());
        }
    }
}

