/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.tls.provider;

import com.bea.sslplus.WeblogicHandler;
import com.certicom.locale.Resources;
import com.certicom.tls.provider.ka.ECCpresso_DHKeyAgreement;
import com.certicom.tls.provider.ka.ECCpresso_ECDHKeyAgreement;
import com.certicom.tls.provider.spec.DHPrivateKey;
import com.certicom.tls.provider.spec.DHPublicKey;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.spec.DHPrivateKeySpec;
import javax.crypto.spec.DHPublicKeySpec;

public class KeyAgreement {
    private javax.crypto.KeyAgreement jceKA;

    public Provider getProvider() {
        if (this.jceKA == null) {
            return null;
        }
        return this.jceKA.getProvider();
    }

    protected KeyAgreement() {
    }

    private KeyAgreement(javax.crypto.KeyAgreement keyAgreement) {
        this.jceKA = keyAgreement;
    }

    public static final KeyAgreement getInstance(String string) throws NoSuchAlgorithmException {
        if (WeblogicHandler.useJCEProvider()) {
            try {
                javax.crypto.KeyAgreement keyAgreement = javax.crypto.KeyAgreement.getInstance(string);
                if (WeblogicHandler.isSupported(keyAgreement, string)) {
                    if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_INFO)) {
                        WeblogicHandler.debug(WeblogicHandler.DEBUG_INFO, "Using JCE KeyAgreement: " + keyAgreement.getProvider() + " for algorithm " + string, null);
                    }
                    return new KeyAgreement(keyAgreement);
                }
                if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_INFO)) {
                    WeblogicHandler.debug(WeblogicHandler.DEBUG_INFO, "Ignoring not supported JCE KeyAgreement: " + keyAgreement.getProvider() + " for algorithm " + string, null);
                }
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                WeblogicHandler.debugEaten(noClassDefFoundError);
            }
            catch (Exception exception) {
                WeblogicHandler.debugEaten(exception);
            }
        }
        if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_INFO)) {
            WeblogicHandler.debug(WeblogicHandler.DEBUG_INFO, "Will use default KeyAgreement for algorithm " + string, null);
        }
        try {
            if (string.equalsIgnoreCase("DiffieHellman") || string.equalsIgnoreCase("DH")) {
                return new ECCpresso_DHKeyAgreement();
            }
            if (string.equalsIgnoreCase("ECDH")) {
                return new ECCpresso_ECDHKeyAgreement();
            }
        }
        catch (Error error) {
            WeblogicHandler.debugEaten(error);
        }
        catch (Exception exception) {
            WeblogicHandler.debugEaten(exception);
        }
        throw new NoSuchAlgorithmException(string + Resources.getMessage("66"));
    }

    public void init(Key key, SecureRandom secureRandom) throws InvalidKeyException {
        if (key instanceof DHPrivateKey) {
            DHPrivateKey dHPrivateKey = (DHPrivateKey)key;
            DHPrivateKeySpec dHPrivateKeySpec = new DHPrivateKeySpec(dHPrivateKey.getX(), dHPrivateKey.getP(), dHPrivateKey.getG());
            try {
                KeyFactory keyFactory = KeyFactory.getInstance("DH");
                PrivateKey privateKey = keyFactory.generatePrivate(dHPrivateKeySpec);
                this.jceKA.init((Key)privateKey, secureRandom);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                WeblogicHandler.debugEaten(noSuchAlgorithmException);
                throw new InvalidKeyException(Resources.getMessage("92"));
            }
            catch (InvalidKeySpecException invalidKeySpecException) {
                WeblogicHandler.debugEaten(invalidKeySpecException);
                throw new InvalidKeyException(Resources.getMessage("92"));
            }
        } else {
            this.jceKA.init(key, secureRandom);
        }
    }

    public Key doPhase(Key key, boolean bl) throws InvalidKeyException, IllegalStateException {
        if (key instanceof DHPublicKey) {
            DHPublicKey dHPublicKey = (DHPublicKey)key;
            DHPublicKeySpec dHPublicKeySpec = new DHPublicKeySpec(dHPublicKey.getY(), dHPublicKey.getP(), dHPublicKey.getG());
            try {
                KeyFactory keyFactory = KeyFactory.getInstance("DH");
                PublicKey publicKey = keyFactory.generatePublic(dHPublicKeySpec);
                return this.jceKA.doPhase(publicKey, bl);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                WeblogicHandler.debugEaten(noSuchAlgorithmException);
                throw new InvalidKeyException(Resources.getMessage("92"));
            }
            catch (InvalidKeySpecException invalidKeySpecException) {
                WeblogicHandler.debugEaten(invalidKeySpecException);
                throw new InvalidKeyException(Resources.getMessage("92"));
            }
        }
        return this.jceKA.doPhase(key, bl);
    }

    public byte[] generateSecret() throws IllegalStateException {
        return this.jceKA.generateSecret();
    }

    public String getAlgorithm() {
        return this.jceKA.getAlgorithm();
    }
}

