/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.tls.provider;

import com.bea.sslplus.WeblogicHandler;
import com.certicom.locale.Resources;
import com.certicom.security.asn1.ASN1OID;
import com.certicom.security.asn1.ASN1ParsingException;
import com.certicom.security.openssl.PEMDSAPrivateKey;
import com.certicom.security.pkcs.pkcs1.RSAPrivateKey;
import com.certicom.security.pkcs.pkcs8.PrivateKeyInfo;
import com.certicom.security.pkix.AlgorithmIdentifier;
import com.certicom.security.pkix.SubjectPublicKeyInfo;
import com.certicom.tls.provider.kf.DSAKeyFactory;
import com.certicom.tls.provider.kf.ECCpresso_ECKeyFactory;
import com.certicom.tls.provider.kf.ECCpresso_RSAKeyFactory;
import com.certicom.tls.provider.kf.JSAFE_RSAKeyFactory;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateParsingException;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;

public class KeyFactory {
    public static final String ENC_PKCS8 = "pkcs8";
    public static final String ENC_DSA_PKCS8 = "dsa_pkcs8";
    public static final String ENC_RSA_PKCS1 = "rsa_pkcs1";
    public static final String ENC_DSA_OPENSSL_DER = "dsa_openssl_asn1";
    public static final String ENC_ECC_RAW = "ecc_raw";
    public static final String ENC_ECC_SEC1 = "ecc_sec1";
    private String alg;
    private java.security.KeyFactory jcaKF;

    private KeyFactory(java.security.KeyFactory keyFactory, String string) {
        this.jcaKF = keyFactory;
        this.alg = string;
    }

    protected KeyFactory() {
    }

    public static final KeyFactory getInstance(String string) throws NoSuchAlgorithmException {
        try {
            if (WeblogicHandler.useJCEProvider()) {
                java.security.KeyFactory keyFactory;
                String string2 = string;
                if (string.equalsIgnoreCase("EC")) {
                    string2 = "ECDH";
                }
                if (WeblogicHandler.isSupported(keyFactory = java.security.KeyFactory.getInstance(string2), string2)) {
                    return new KeyFactory(keyFactory, string2);
                }
            }
        }
        catch (Throwable throwable) {
            WeblogicHandler.debugEaten(throwable);
        }
        try {
            if (string.equalsIgnoreCase("EC") || string.equalsIgnoreCase("ECDSA") || string.equalsIgnoreCase("ECDH")) {
                return new ECCpresso_ECKeyFactory();
            }
            if (string.equalsIgnoreCase("RSA")) {
                try {
                    return new JSAFE_RSAKeyFactory();
                }
                catch (Throwable throwable) {
                    WeblogicHandler.debugEaten(throwable);
                    try {
                        return new ECCpresso_RSAKeyFactory();
                    }
                    catch (Throwable throwable2) {
                        WeblogicHandler.debugEaten(throwable2);
                    }
                }
            } else if (string.equalsIgnoreCase("DSA")) {
                return new DSAKeyFactory();
            }
        }
        catch (Throwable throwable) {
            WeblogicHandler.debugEaten(throwable);
        }
        throw new NoSuchAlgorithmException(string + " " + Resources.getMessage("84"));
    }

    public PrivateKey createPrivateKey(byte[] byArray, String string) {
        try {
            if (string == null || string.equals(ENC_PKCS8)) {
                PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(byArray);
                return this.jcaKF.generatePrivate(pKCS8EncodedKeySpec);
            }
            if (string.equals(ENC_RSA_PKCS1)) {
                byte[] byArray2 = new byte[byArray.length + 26];
                byte[] byArray3 = new byte[]{48, -126, 2, 119, 2, 1, 0, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 4, -126, 2, 97};
                byArray3[2] = (byte)((byArray.length + 22) / 256);
                byArray3[3] = (byte)((byArray.length + 22) % 256);
                byArray3[24] = (byte)(byArray.length / 256);
                byArray3[25] = (byte)(byArray.length % 256);
                System.arraycopy(byArray3, 0, byArray2, 0, 26);
                System.arraycopy(byArray, 0, byArray2, 26, byArray.length);
                PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(byArray2);
                return this.jcaKF.generatePrivate(pKCS8EncodedKeySpec);
            }
            if (string.equals(ENC_DSA_PKCS8)) {
                return this.jcaKF.generatePrivate(this.decodePKCS8DSAPrivateKey(byArray));
            }
            if (string.equals(ENC_DSA_OPENSSL_DER)) {
                return this.jcaKF.generatePrivate(this.decodePEMDSAPrivateKey(byArray));
            }
            return null;
        }
        catch (CertificateParsingException certificateParsingException) {
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            // empty catch block
        }
        return null;
    }

    protected RSAPrivateCrtKeySpec decodePKCS8RSAPrivateKey(byte[] byArray) throws CertificateParsingException {
        try {
            PrivateKeyInfo privateKeyInfo = new PrivateKeyInfo();
            privateKeyInfo.decode(byArray);
            return this.decodePKCS1RSAPrivateKey(privateKeyInfo.getRawKey());
        }
        catch (ASN1ParsingException aSN1ParsingException) {
            throw new CertificateParsingException(aSN1ParsingException.getMessage());
        }
    }

    protected RSAPrivateCrtKeySpec decodePKCS1RSAPrivateKey(byte[] byArray) throws CertificateParsingException {
        try {
            RSAPrivateKey rSAPrivateKey = new RSAPrivateKey();
            rSAPrivateKey.decode(byArray);
            RSAPrivateCrtKeySpec rSAPrivateCrtKeySpec = rSAPrivateKey.getKeySpec();
            return rSAPrivateCrtKeySpec;
        }
        catch (ASN1ParsingException aSN1ParsingException) {
            throw new CertificateParsingException(aSN1ParsingException.getMessage());
        }
    }

    protected DSAPrivateKeySpec decodePKCS8DSAPrivateKey(byte[] byArray) throws CertificateParsingException {
        try {
            PrivateKeyInfo privateKeyInfo = new PrivateKeyInfo();
            privateKeyInfo.decode(byArray);
            DSAPrivateKeySpec dSAPrivateKeySpec = privateKeyInfo.getDSAKeySpec();
            return dSAPrivateKeySpec;
        }
        catch (Exception exception) {
            throw new CertificateParsingException(exception.getMessage());
        }
    }

    protected DSAPrivateKeySpec decodePEMDSAPrivateKey(byte[] byArray) throws CertificateParsingException {
        try {
            PEMDSAPrivateKey pEMDSAPrivateKey = new PEMDSAPrivateKey();
            pEMDSAPrivateKey.decode(byArray);
            DSAPrivateKeySpec dSAPrivateKeySpec = pEMDSAPrivateKey.getKeySpec();
            return dSAPrivateKeySpec;
        }
        catch (Exception exception) {
            throw new CertificateParsingException(exception.getMessage());
        }
    }

    public PublicKey createPublicKey(byte[] byArray, String string) {
        try {
            if (this.alg.startsWith("EC")) {
                Object object;
                byte[] byArray2 = byArray;
                if (!string.equals("X509")) {
                    try {
                        object = new AlgorithmIdentifier("1.2.840.10045.2.1", new ASN1OID("1.3.132.0.1"));
                        SubjectPublicKeyInfo subjectPublicKeyInfo = new SubjectPublicKeyInfo((AlgorithmIdentifier)object, byArray);
                        byArray2 = subjectPublicKeyInfo.encode();
                    }
                    catch (ASN1ParsingException aSN1ParsingException) {
                        WeblogicHandler.debugEaten(aSN1ParsingException);
                    }
                }
                object = new X509EncodedKeySpec(byArray2);
                return this.jcaKF.generatePublic((KeySpec)object);
            }
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(byArray);
            return this.jcaKF.generatePublic(x509EncodedKeySpec);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            WeblogicHandler.debugEaten(invalidKeySpecException);
            return null;
        }
    }

    public PublicKey createPublicKey(BigInteger bigInteger, BigInteger bigInteger2) {
        try {
            return this.jcaKF.generatePublic(new RSAPublicKeySpec(bigInteger, bigInteger2));
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            return null;
        }
    }
}

