/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.tls.provider;

import com.bea.sslplus.WeblogicHandler;
import com.certicom.locale.Resources;
import com.certicom.tls.provider.kpg.ECCpresso_DHKeyPairGenerator;
import com.certicom.tls.provider.kpg.ECCpresso_ECDSAKeyPairGenerator;
import com.certicom.tls.provider.kpg.ECCpresso_RSA_KPG;
import com.certicom.tls.provider.kpg.JSAFE_RSAKeyPairGenerator;
import com.certicom.tls.provider.spec.DHParameters;
import com.certicom.tls.provider.spec.RSAParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.spec.DHParameterSpec;

public class KeyPairGenerator {
    java.security.KeyPairGenerator jcaKPG;

    protected KeyPairGenerator() {
    }

    private KeyPairGenerator(java.security.KeyPairGenerator keyPairGenerator) {
        this.jcaKPG = keyPairGenerator;
    }

    public String getAlgorithm() {
        return this.jcaKPG.getAlgorithm();
    }

    public static KeyPairGenerator getInstance(String string) throws NoSuchAlgorithmException {
        if (WeblogicHandler.useJCEProvider()) {
            try {
                java.security.KeyPairGenerator keyPairGenerator = java.security.KeyPairGenerator.getInstance(string);
                if (string.equals("ECDSA") && keyPairGenerator.getProvider().toString().startsWith("IAIK")) {
                    throw new Exception();
                }
                if (string.equalsIgnoreCase("DH") || string.equalsIgnoreCase("DiffieHellman")) {
                    throw new Exception();
                }
                if (WeblogicHandler.isSupported(keyPairGenerator)) {
                    return new KeyPairGenerator(keyPairGenerator);
                }
            }
            catch (Throwable throwable) {
                WeblogicHandler.debugEaten(throwable);
            }
        }
        try {
            if (string.equalsIgnoreCase("DH") || string.equalsIgnoreCase("DiffieHellman")) {
                return new ECCpresso_DHKeyPairGenerator();
            }
            if (string.equalsIgnoreCase("RSA") || string.equalsIgnoreCase("RSA_EXPORT")) {
                try {
                    return new JSAFE_RSAKeyPairGenerator();
                }
                catch (Throwable throwable) {
                    WeblogicHandler.debugEaten(throwable);
                    try {
                        return new ECCpresso_RSA_KPG();
                    }
                    catch (Throwable throwable2) {
                        WeblogicHandler.debugEaten(throwable2);
                    }
                }
            } else if (string.equalsIgnoreCase("ECDSA")) {
                return new ECCpresso_ECDSAKeyPairGenerator();
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            WeblogicHandler.debugEaten(noClassDefFoundError);
        }
        catch (ClassNotFoundException classNotFoundException) {
            WeblogicHandler.debugEaten(classNotFoundException);
        }
        throw new NoSuchAlgorithmException(Resources.getMessage("147"));
    }

    public void initialize(DHParameters dHParameters, SecureRandom secureRandom) throws InvalidParameterException {
        try {
            DHParameterSpec dHParameterSpec = new DHParameterSpec(dHParameters.getP(), dHParameters.getG());
            this.jcaKPG.initialize(dHParameterSpec, secureRandom);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            WeblogicHandler.debugEaten(invalidAlgorithmParameterException);
            throw new InvalidParameterException(invalidAlgorithmParameterException.getMessage());
        }
    }

    public void initialize(RSAParameters rSAParameters, SecureRandom secureRandom) throws InvalidParameterException {
        this.jcaKPG.initialize(rSAParameters.getModulusBits(), secureRandom);
    }

    public void initialize(int n, SecureRandom secureRandom) {
        this.jcaKPG.initialize(n, secureRandom);
    }

    public KeyPair genKeyPair() {
        return this.jcaKPG.genKeyPair();
    }
}

