/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.tls.provider;

import com.bea.sslplus.WeblogicHandler;
import com.certicom.tls.provider.MessageDigest;
import com.certicom.tls.provider.mac.HMAC;
import com.certicom.tls.provider.mac.NullMac;
import com.certicom.tls.provider.mac.SSL2RecordMac;
import com.certicom.tls.provider.mac.SSL3RecordMac;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import javax.crypto.spec.SecretKeySpec;

public class Mac
implements Cloneable {
    private javax.crypto.Mac jceMac;

    public Provider getProvider() {
        if (this.jceMac == null) {
            return null;
        }
        return this.jceMac.getProvider();
    }

    private Mac(javax.crypto.Mac mac) {
        this.jceMac = mac;
    }

    protected Mac() {
    }

    public String getAlgorithm() {
        return this.jceMac.getAlgorithm();
    }

    public static final Mac getInstance(String string) throws NoSuchAlgorithmException {
        Object object;
        if (string.equalsIgnoreCase("NullMac")) {
            return new NullMac();
        }
        if (WeblogicHandler.useJCEProvider()) {
            try {
                object = javax.crypto.Mac.getInstance(string);
                if (WeblogicHandler.isSupported((javax.crypto.Mac)object)) {
                    if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_INFO)) {
                        WeblogicHandler.debug(WeblogicHandler.DEBUG_INFO, "Using JCE Mac: " + ((javax.crypto.Mac)object).getProvider() + " for algorithm " + string, null);
                    }
                    return new Mac((javax.crypto.Mac)object);
                }
                if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_INFO)) {
                    WeblogicHandler.debug(WeblogicHandler.DEBUG_INFO, "Ignoring not supported JCE Mac: " + ((javax.crypto.Mac)object).getProvider() + " for algorithm " + string, null);
                }
            }
            catch (Error error) {
                WeblogicHandler.debugEaten(error);
            }
            catch (Exception exception) {
                WeblogicHandler.debugEaten(exception);
            }
        }
        if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_INFO)) {
            WeblogicHandler.debug(WeblogicHandler.DEBUG_INFO, "Will use default Mac for algorithm " + string, null);
        }
        try {
            if (string.equalsIgnoreCase("NullMac")) {
                return new NullMac();
            }
            if (string.equalsIgnoreCase("HmacMD5") || string.equalsIgnoreCase("MD5")) {
                object = MessageDigest.getInstance("MD5");
                return new HMAC((MessageDigest)object, 64);
            }
            if (string.equalsIgnoreCase("HmacSHA1") || string.equalsIgnoreCase("SHA")) {
                object = MessageDigest.getInstance("SHA");
                return new HMAC((MessageDigest)object, 64);
            }
            if (string.equalsIgnoreCase("SSL3MAC_SHA")) {
                object = MessageDigest.getInstance("SHA");
                return new SSL3RecordMac((MessageDigest)object);
            }
            if (string.equalsIgnoreCase("SSL3MAC_MD5")) {
                object = MessageDigest.getInstance("MD5");
                return new SSL3RecordMac((MessageDigest)object);
            }
            if (string.equalsIgnoreCase("SSL2MAC_SHA")) {
                object = MessageDigest.getInstance("SHA");
                return new SSL2RecordMac((MessageDigest)object);
            }
            if (string.equalsIgnoreCase("SSL2MAC_MD5")) {
                object = MessageDigest.getInstance("MD5");
                return new SSL2RecordMac((MessageDigest)object);
            }
        }
        catch (Throwable throwable) {
            WeblogicHandler.debugEaten(throwable);
        }
        throw new NoSuchAlgorithmException();
    }

    public int getMacLength() {
        return this.jceMac.getMacLength();
    }

    public void init(Key key) throws InvalidKeyException {
        String string = this.getAlgorithm();
        byte[] byArray = (byte[])key.getEncoded().clone();
        if (byArray.length == 0) {
            this.jceMac.init(new ZeroKeySpec(string));
        } else {
            SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, string);
            this.jceMac.init(secretKeySpec);
        }
    }

    public void update(byte by) throws IllegalStateException {
        this.jceMac.update(by);
    }

    public void update(byte[] byArray) throws IllegalStateException {
        this.jceMac.update(byArray);
    }

    public void update(byte[] byArray, int n, int n2) throws IllegalStateException {
        this.jceMac.update(byArray, n, n2);
    }

    public byte[] doFinal() throws IllegalStateException {
        return this.jceMac.doFinal();
    }

    public byte[] doFinal(byte[] byArray) throws IllegalStateException {
        this.update(byArray);
        return this.doFinal();
    }

    public void reset() {
        this.jceMac.reset();
    }

    public Object clone() throws CloneNotSupportedException {
        return new Mac((javax.crypto.Mac)this.jceMac.clone());
    }

    class ZeroKeySpec
    implements Key {
        String alg;
        byte[] bytes = new byte[0];

        public ZeroKeySpec(String string) {
            this.alg = string;
        }

        public byte[] getEncoded() {
            return this.bytes;
        }

        public String getAlgorithm() {
            return this.alg;
        }

        public String getFormat() {
            return new String("RAW");
        }
    }
}

