/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.tls.provider;

import com.bea.sslplus.WeblogicHandler;
import com.certicom.locale.Resources;
import com.certicom.tls.provider.md.ECCpresso_MD2;
import com.certicom.tls.provider.md.ECCpresso_MD5;
import com.certicom.tls.provider.md.ECCpresso_SHA1;
import java.security.NoSuchAlgorithmException;

public class MessageDigest {
    private java.security.MessageDigest jsecMD = null;

    private MessageDigest(java.security.MessageDigest messageDigest) {
        this.jsecMD = messageDigest;
    }

    protected MessageDigest() {
    }

    public static MessageDigest getInstance(String string) throws NoSuchAlgorithmException {
        if (WeblogicHandler.useJCEProvider()) {
            try {
                java.security.MessageDigest messageDigest = java.security.MessageDigest.getInstance(string);
                if (WeblogicHandler.isSupported(messageDigest)) {
                    return new MessageDigest(messageDigest);
                }
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                WeblogicHandler.debugEaten(noSuchAlgorithmException);
            }
        }
        try {
            if (string.equalsIgnoreCase("MD5")) {
                return new ECCpresso_MD5();
            }
            if (string.equalsIgnoreCase("SHA") || string.equalsIgnoreCase("SHA1") || string.equalsIgnoreCase("SHA-1")) {
                return new ECCpresso_SHA1();
            }
            if (string.equalsIgnoreCase("MD2")) {
                return new ECCpresso_MD2();
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            WeblogicHandler.debugEaten(noClassDefFoundError);
        }
        throw new NoSuchAlgorithmException(string + " " + Resources.getMessage("84"));
    }

    public void update(byte by) {
        this.jsecMD.update(by);
    }

    public void update(byte[] byArray) {
        this.jsecMD.update(byArray);
    }

    public void update(byte[] byArray, int n, int n2) {
        this.jsecMD.update(byArray, n, n2);
    }

    public byte[] digest() {
        return this.jsecMD.digest();
    }

    public byte[] digest(byte[] byArray) {
        this.update(byArray);
        return this.digest();
    }

    public String toString() {
        return this.jsecMD.toString();
    }

    public static final boolean isEqual(byte[] byArray, byte[] byArray2) {
        return java.security.MessageDigest.isEqual(byArray, byArray2);
    }

    public void reset() {
        this.jsecMD.reset();
    }

    public String getAlgorithm() {
        return this.jsecMD.getAlgorithm();
    }

    public int getDigestLength() {
        if (this.jsecMD.getAlgorithm().equals("MD5")) {
            return 16;
        }
        if (this.jsecMD.getAlgorithm().equals("SHA")) {
            return 20;
        }
        return 0;
    }

    public Object clone() throws CloneNotSupportedException {
        if (this.jsecMD == null) {
            return super.clone();
        }
        return new MessageDigest((java.security.MessageDigest)this.jsecMD.clone());
    }
}

