/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.tls.provider;

import com.bea.sslplus.WeblogicHandler;
import com.certicom.locale.Resources;
import com.certicom.tls.provider.sig.ECCpresso_DSA;
import com.certicom.tls.provider.sig.ECCpresso_ECDSASignature;
import com.certicom.tls.provider.sig.ECCpresso_RSASignature;
import com.certicom.tls.provider.sig.JSAFE_RSASignature;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;

public class Signature {
    private java.security.Signature jcaSig;

    private Signature(java.security.Signature signature) {
        this.jcaSig = signature;
    }

    protected Signature() {
    }

    public static final Signature getInstance(String string) throws NoSuchAlgorithmException {
        Object object;
        if (WeblogicHandler.useJCEProvider()) {
            try {
                object = java.security.Signature.getInstance(string);
                if (string.equals("ECDSA") && ((java.security.Signature)object).getProvider().toString().startsWith("IAIK")) {
                    throw new IllegalArgumentException();
                }
                if (WeblogicHandler.isSupported((java.security.Signature)object)) {
                    return new Signature((java.security.Signature)object);
                }
            }
            catch (Throwable throwable) {
                WeblogicHandler.debugEaten(throwable);
            }
        }
        try {
            if (string.equalsIgnoreCase("RawDSA")) {
                object = new ECCpresso_DSA(ECCpresso_DSA.RAW);
                return object;
            }
            if (string.equalsIgnoreCase("SHA1withDSA") || string.equalsIgnoreCase("SHA/DSA") || string.equalsIgnoreCase("DSA")) {
                return new ECCpresso_DSA(ECCpresso_DSA.SHA1);
            }
            if (string.indexOf("RSA") >= 0) {
                try {
                    return new JSAFE_RSASignature(string);
                }
                catch (Throwable throwable) {
                    WeblogicHandler.debugEaten(throwable);
                    try {
                        return new ECCpresso_RSASignature(string);
                    }
                    catch (Throwable throwable2) {
                        WeblogicHandler.debugEaten(throwable2);
                    }
                }
            } else {
                if (string.equalsIgnoreCase("RawECDSA")) {
                    return new ECCpresso_ECDSASignature(1);
                }
                if (string.equalsIgnoreCase("ECDSA")) {
                    return new ECCpresso_ECDSASignature(2);
                }
            }
        }
        catch (Throwable throwable) {
            WeblogicHandler.debugEaten(throwable);
        }
        throw new NoSuchAlgorithmException(string + " " + Resources.getMessage("89"));
    }

    public void initVerify(PublicKey publicKey) throws InvalidKeyException {
        this.jcaSig.initVerify(publicKey);
    }

    public void initSign(PrivateKey privateKey, SecureRandom secureRandom) throws InvalidKeyException {
        this.jcaSig.initSign(privateKey, secureRandom);
    }

    public byte[] sign() throws SignatureException {
        return this.jcaSig.sign();
    }

    public boolean verify(byte[] byArray) throws SignatureException {
        return this.jcaSig.verify(byArray);
    }

    public void update(byte by) throws SignatureException {
        this.jcaSig.update(by);
    }

    public void update(byte[] byArray) throws SignatureException {
        this.jcaSig.update(byArray);
    }

    public void update(byte[] byArray, int n, int n2) throws SignatureException {
        this.jcaSig.update(byArray, n, n2);
    }

    public String getAlgorithm() {
        return this.jcaSig.getAlgorithm();
    }

    public void setParameter(String string, Object object) throws InvalidParameterException {
        this.jcaSig.setParameter(string, object);
    }

    public Object getParameter(String string) throws InvalidParameterException {
        return this.jcaSig.getParameter(string);
    }

    public Object clone() throws CloneNotSupportedException {
        if (this.jcaSig == null) {
            return super.clone();
        }
        return this.jcaSig.clone();
    }
}

