/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.tls.provider.cipher;

import com.certicom.ecc.scheme.CryptoTransform;
import com.certicom.ecc.system.CryptoManager;
import com.certicom.locale.Resources;
import com.certicom.tls.ciphersuite.CryptoNames;
import com.certicom.tls.provider.Cipher;
import com.certicom.tls.provider.kf.ECCpresso_RSAKeyFactory;
import com.certicom.tls.provider.spec.ECCpresso_RSAPrivateKey;
import com.certicom.tls.provider.spec.ECCpresso_RSAPublicKey;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Random;

public final class ECCpresso_RSACipher
extends Cipher
implements CryptoNames {
    private String transformation;
    CryptoTransform rsa = null;
    Object params = new Object[]{"SHA-1", "MGF1"};
    int opmode;

    public ECCpresso_RSACipher(String string) throws NoSuchAlgorithmException, ClassNotFoundException {
        this.rsa = (CryptoTransform)CryptoManager.getInstance((Class)CryptoTransform.TYPE, (String)"RSA");
        if (string != "RSA/ECB/PKCS1Padding" && string != "RSA/ECB/NoPadding") {
            throw new NoSuchAlgorithmException();
        }
        this.transformation = string;
    }

    public int getBlockSize() {
        return 0;
    }

    public void init(int n, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        int n2;
        String string = this.getEncoding(n);
        int n3 = n == 1 ? 3 : (n2 = 4);
        if (key instanceof ECCpresso_RSAPublicKey) {
            this.rsa.init(n2, new Object[]{((ECCpresso_RSAPublicKey)key).getKey(), string, this.params}, (Random)secureRandom);
        } else if (key instanceof RSAPublicKey) {
            ECCpresso_RSAPublicKey eCCpresso_RSAPublicKey = new ECCpresso_RSAPublicKey(((RSAPublicKey)key).getModulus(), ((RSAPublicKey)key).getPublicExponent());
            this.rsa.init(n2, new Object[]{eCCpresso_RSAPublicKey.getKey(), string, this.params}, (Random)secureRandom);
        } else if (key instanceof ECCpresso_RSAPrivateKey) {
            this.rsa.init(n2, new Object[]{((ECCpresso_RSAPrivateKey)key).getKey(), string, this.params}, (Random)secureRandom);
        } else if (key instanceof RSAPrivateKey) {
            ECCpresso_RSAKeyFactory eCCpresso_RSAKeyFactory = new ECCpresso_RSAKeyFactory();
            ECCpresso_RSAPrivateKey eCCpresso_RSAPrivateKey = (ECCpresso_RSAPrivateKey)eCCpresso_RSAKeyFactory.createPrivateKey(key.getEncoded(), null);
            this.rsa.init(n2, new Object[]{eCCpresso_RSAPrivateKey.getKey(), string, this.params}, (Random)secureRandom);
        } else {
            throw new InvalidKeyException(Resources.getMessage("44"));
        }
        this.opmode = n;
    }

    private String getEncoding(int n) {
        if (this.transformation == "RSA/ECB/NoPadding") {
            return "RawExpRsa";
        }
        switch (n) {
            case 1: {
                return "EME-PKCS1-v1_5-Encode";
            }
            case 2: {
                return "EME-PKCS1-v1_5-Decode";
            }
        }
        return null;
    }

    public byte[] update(byte[] byArray, int n, int n2) {
        return this.rsa.transform(byArray, n, n2, false);
    }

    public byte[] update(byte[] byArray) {
        return this.update(byArray, 0, byArray.length);
    }

    public byte[] doFinal(byte[] byArray, int n, int n2) {
        return this.rsa.transform(byArray, n, n2, true);
    }
}

