/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.tls.provider.cipher;

import com.bea.sslplus.WeblogicHandler;
import com.certicom.tls.ciphersuite.CryptoNames;
import com.certicom.tls.provider.Cipher;
import com.certicom.tls.provider.spec.JSAFE_RSAPrivateKey;
import com.certicom.tls.provider.spec.JSAFE_RSAPublicKey;
import com.rsa.jsafe.JSAFE_AsymmetricCipher;
import com.rsa.jsafe.JSAFE_InputException;
import com.rsa.jsafe.JSAFE_InvalidKeyException;
import com.rsa.jsafe.JSAFE_InvalidParameterException;
import com.rsa.jsafe.JSAFE_InvalidUseException;
import com.rsa.jsafe.JSAFE_PaddingException;
import com.rsa.jsafe.JSAFE_PrivateKey;
import com.rsa.jsafe.JSAFE_PublicKey;
import com.rsa.jsafe.JSAFE_UnimplementedException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;

public final class JSAFE_RSA
extends Cipher
implements CryptoNames {
    JSAFE_AsymmetricCipher rsa;
    int opmode;

    public JSAFE_RSA(String string) throws NoSuchAlgorithmException, ClassNotFoundException {
        block5: {
            this.rsa = null;
            try {
                if (string == "RSA/ECB/PKCS1Padding") {
                    this.rsa = JSAFE_AsymmetricCipher.getInstance((String)"RSA/PKCS1Block02Pad", (String)"Java");
                    break block5;
                }
                if (string == "RSA/ECB/NoPadding") {
                    this.rsa = JSAFE_AsymmetricCipher.getInstance((String)"RSA/NoPad", (String)"Java");
                    break block5;
                }
                throw new NoSuchAlgorithmException();
            }
            catch (JSAFE_UnimplementedException jSAFE_UnimplementedException) {
                WeblogicHandler.debugEaten(jSAFE_UnimplementedException);
                throw new NoSuchAlgorithmException(jSAFE_UnimplementedException.getMessage());
            }
            catch (JSAFE_InvalidParameterException jSAFE_InvalidParameterException) {
                WeblogicHandler.debugEaten(jSAFE_InvalidParameterException);
                throw new NoSuchAlgorithmException(jSAFE_InvalidParameterException.getMessage());
            }
        }
    }

    public int getBlockSize() {
        return 0;
    }

    public void init(int n, Key key, byte[] byArray) {
    }

    public void init(int n, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        try {
            switch (n) {
                case 1: {
                    if (key instanceof JSAFE_RSAPublicKey) {
                        this.rsa.encryptInit(((JSAFE_RSAPublicKey)key).getKey(), secureRandom);
                        break;
                    }
                    if (key instanceof JSAFE_RSAPrivateKey) {
                        JSAFE_PublicKey jSAFE_PublicKey = this.generateFakePublicKey(((JSAFE_RSAPrivateKey)key).getKey());
                        this.rsa.encryptInit(jSAFE_PublicKey, secureRandom);
                        break;
                    }
                    if (key instanceof RSAPublicKey) {
                        JSAFE_RSAPublicKey jSAFE_RSAPublicKey = new JSAFE_RSAPublicKey(((RSAPublicKey)key).getModulus(), ((RSAPublicKey)key).getPublicExponent());
                        this.rsa.encryptInit(jSAFE_RSAPublicKey.getKey(), secureRandom);
                        break;
                    }
                    if (key instanceof RSAPrivateKey) {
                        JSAFE_RSAPrivateKey jSAFE_RSAPrivateKey = new JSAFE_RSAPrivateKey(((RSAPrivateKey)key).getEncoded());
                        JSAFE_PublicKey jSAFE_PublicKey = this.generateFakePublicKey(jSAFE_RSAPrivateKey.getKey());
                        this.rsa.encryptInit(jSAFE_PublicKey, secureRandom);
                        break;
                    }
                    throw new InvalidKeyException();
                }
                case 2: {
                    if (key instanceof JSAFE_RSAPrivateKey) {
                        this.rsa.decryptInit(((JSAFE_RSAPrivateKey)key).getKey());
                        break;
                    }
                    if (key instanceof RSAPrivateKey) {
                        JSAFE_RSAPrivateKey jSAFE_RSAPrivateKey = new JSAFE_RSAPrivateKey(((RSAPrivateKey)key).getEncoded());
                        this.rsa.decryptInit(jSAFE_RSAPrivateKey.getKey());
                        break;
                    }
                    if (key instanceof JSAFE_RSAPublicKey) {
                        JSAFE_PrivateKey jSAFE_PrivateKey = this.generateFakePrivateKey(((JSAFE_RSAPublicKey)key).getKey());
                        this.rsa.decryptInit(jSAFE_PrivateKey);
                        break;
                    }
                    if (key instanceof RSAPublicKey) {
                        JSAFE_RSAPublicKey jSAFE_RSAPublicKey = new JSAFE_RSAPublicKey(((RSAPublicKey)key).getModulus(), ((RSAPublicKey)key).getPublicExponent());
                        JSAFE_PrivateKey jSAFE_PrivateKey = this.generateFakePrivateKey(jSAFE_RSAPublicKey.getKey());
                        this.rsa.decryptInit(jSAFE_PrivateKey);
                        break;
                    }
                    throw new InvalidKeyException();
                }
            }
        }
        catch (JSAFE_InvalidUseException jSAFE_InvalidUseException) {
            WeblogicHandler.debugEaten(jSAFE_InvalidUseException);
            throw new InvalidKeyException();
        }
        catch (JSAFE_InvalidKeyException jSAFE_InvalidKeyException) {
            WeblogicHandler.debugEaten(jSAFE_InvalidKeyException);
            throw new InvalidKeyException();
        }
        this.opmode = n;
    }

    private JSAFE_PrivateKey generateFakePrivateKey(JSAFE_PublicKey jSAFE_PublicKey) throws JSAFE_InvalidKeyException, JSAFE_InvalidUseException {
        JSAFE_PrivateKey jSAFE_PrivateKey;
        try {
            jSAFE_PrivateKey = JSAFE_PrivateKey.getInstance((String)"RSA", (String)"Java");
            jSAFE_PrivateKey.setKeyData("RSAPrivateKey", jSAFE_PublicKey.getKeyData());
        }
        catch (JSAFE_UnimplementedException jSAFE_UnimplementedException) {
            WeblogicHandler.debugEaten(jSAFE_UnimplementedException);
            throw new JSAFE_InvalidUseException(jSAFE_UnimplementedException.getMessage());
        }
        return jSAFE_PrivateKey;
    }

    JSAFE_PublicKey generateFakePublicKey(JSAFE_PrivateKey jSAFE_PrivateKey) throws JSAFE_InvalidKeyException, JSAFE_InvalidUseException {
        JSAFE_PublicKey jSAFE_PublicKey;
        try {
            jSAFE_PublicKey = JSAFE_PublicKey.getInstance((String)"RSA", (String)"Java");
            jSAFE_PublicKey.setKeyData(jSAFE_PrivateKey.getKeyData("RSAPrivateKey"));
        }
        catch (JSAFE_UnimplementedException jSAFE_UnimplementedException) {
            WeblogicHandler.debugEaten(jSAFE_UnimplementedException);
            throw new JSAFE_InvalidUseException(jSAFE_UnimplementedException.getMessage());
        }
        return jSAFE_PublicKey;
    }

    public byte[] update(byte[] byArray, int n, int n2) {
        try {
            if (this.opmode == 1) {
                return this.rsa.encryptUpdate(byArray, n, n2);
            }
            return this.rsa.decryptUpdate(byArray, n, n2);
        }
        catch (JSAFE_InputException jSAFE_InputException) {
            WeblogicHandler.debugEaten(jSAFE_InputException);
            throw new IllegalStateException(jSAFE_InputException.getMessage());
        }
        catch (JSAFE_InvalidUseException jSAFE_InvalidUseException) {
            WeblogicHandler.debugEaten(jSAFE_InvalidUseException);
            throw new IllegalStateException(jSAFE_InvalidUseException.getMessage());
        }
    }

    public byte[] update(byte[] byArray) {
        return this.update(byArray, 0, byArray.length);
    }

    public byte[] doFinal(byte[] byArray, int n, int n2) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
        try {
            if (this.opmode == 1) {
                byteArrayOutputStream.write(this.rsa.encryptUpdate(byArray, n, n2));
                byteArrayOutputStream.write(this.rsa.encryptFinal());
            } else {
                byteArrayOutputStream.write(this.rsa.decryptUpdate(byArray, n, n2));
                byteArrayOutputStream.write(this.rsa.decryptFinal());
            }
        }
        catch (IOException iOException) {
            WeblogicHandler.debugEaten(iOException);
        }
        catch (JSAFE_InputException jSAFE_InputException) {
            WeblogicHandler.debugEaten(jSAFE_InputException);
            throw new IllegalStateException(jSAFE_InputException.getMessage());
        }
        catch (JSAFE_InvalidUseException jSAFE_InvalidUseException) {
            WeblogicHandler.debugEaten(jSAFE_InvalidUseException);
            throw new IllegalStateException();
        }
        catch (JSAFE_PaddingException jSAFE_PaddingException) {
            WeblogicHandler.debugEaten(jSAFE_PaddingException);
            throw new IllegalStateException();
        }
        return byteArrayOutputStream.toByteArray();
    }
}

