/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.tls.provider.ka;

import com.certicom.ecc.scheme.CryptoTransform;
import com.certicom.ecc.system.CryptoManager;
import com.certicom.locale.Resources;
import com.certicom.tls.provider.KeyAgreement;
import com.certicom.tls.provider.spec.DHPrivateKey;
import com.certicom.tls.provider.spec.DHPublicKey;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.SecureRandom;
import java.util.Random;

public final class ECCpresso_DHKeyAgreement
extends KeyAgreement {
    private CryptoTransform dh = (CryptoTransform)CryptoManager.getInstance((Class)CryptoTransform.TYPE, (String)"DH");
    private byte[] x;
    private byte[] p;
    private SecureRandom random;

    public void init(Key key, SecureRandom secureRandom) throws InvalidKeyException {
        if (!(key instanceof DHPrivateKey)) {
            throw new InvalidKeyException(Resources.getMessage("93"));
        }
        this.x = ((DHPrivateKey)key).getX().toByteArray();
        this.p = ((DHPrivateKey)key).getP().toByteArray();
        this.random = secureRandom;
    }

    public byte[] generateSecret() throws IllegalStateException {
        byte[] byArray = this.dh.transform(null, 0, 0, true);
        if (byArray[0] == 0) {
            byte[] byArray2 = new byte[byArray.length - 1];
            System.arraycopy(byArray, 1, byArray2, 0, byArray2.length);
            byArray = byArray2;
        }
        return byArray;
    }

    public Key doPhase(Key key, boolean bl) throws IllegalStateException, InvalidKeyException {
        if (!bl) {
            throw new IllegalStateException(Resources.getMessage("68"));
        }
        if (!(key instanceof DHPublicKey)) {
            throw new InvalidKeyException(Resources.getMessage("93"));
        }
        byte[] byArray = ((DHPublicKey)key).getY().toByteArray();
        this.dh.init(6, new Object[]{this.p, byArray, this.x}, (Random)this.random);
        return null;
    }

    public String getAlgorithm() {
        return "DH";
    }
}

