/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.tls.provider.ka;

import com.certicom.ecc.interfaces.ECPrivateKey;
import com.certicom.ecc.scheme.CryptoTransform;
import com.certicom.ecc.spec.ECPublicKeySpec;
import com.certicom.ecc.system.CryptoManager;
import com.certicom.locale.Resources;
import com.certicom.tls.provider.KeyAgreement;
import com.certicom.tls.provider.spec.ECCpresso_ECPrivateKey;
import com.certicom.tls.provider.spec.ECCpresso_ECPublicKey;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.SecureRandom;
import java.util.Random;

public final class ECCpresso_ECDHKeyAgreement
extends KeyAgreement {
    CryptoTransform ecdh = (CryptoTransform)CryptoManager.getInstance((Class)CryptoTransform.TYPE, (String)"ECDH");
    ECPrivateKey priv;
    SecureRandom rnd;

    public void init(Key key, SecureRandom secureRandom) throws InvalidKeyException {
        if (!(key instanceof ECCpresso_ECPrivateKey)) {
            throw new InvalidKeyException(Resources.getMessage("96"));
        }
        this.priv = ((ECCpresso_ECPrivateKey)key).getKey();
        this.rnd = secureRandom;
    }

    public byte[] generateSecret() throws IllegalStateException {
        byte[] byArray = this.ecdh.transform(null, 0, 20, true);
        return byArray;
    }

    public Key doPhase(Key key, boolean bl) throws IllegalStateException, InvalidKeyException {
        if (!bl) {
            throw new IllegalStateException(Resources.getMessage("70"));
        }
        if (!(key instanceof ECCpresso_ECPublicKey)) {
            throw new InvalidKeyException(Resources.getMessage("95"));
        }
        ECPublicKeySpec eCPublicKeySpec = ((ECCpresso_ECPublicKey)key).getKey();
        this.ecdh.init(7, new Object[]{this.priv, eCPublicKeySpec}, (Random)this.rnd);
        return null;
    }

    public String getAlgorithm() {
        return "ECDH";
    }
}

