/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.tls.provider.kf;

import com.bea.sslplus.WeblogicHandler;
import com.certicom.security.asn1.ASN1ParsingException;
import com.certicom.security.pkix.SubjectPublicKeyInfo;
import com.certicom.tls.provider.KeyFactory;
import com.certicom.tls.provider.spec.DSAPrivateKeyImpl;
import com.certicom.tls.provider.spec.DSAPublicKeyImpl;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateParsingException;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.DSAPublicKeySpec;

public final class DSAKeyFactory
extends KeyFactory {
    public PrivateKey createPrivateKey(byte[] byArray, String string) {
        DSAPrivateKeySpec dSAPrivateKeySpec = null;
        try {
            if (string.equals("dsa_pkcs8") || string == null) {
                dSAPrivateKeySpec = this.decodePKCS8DSAPrivateKey(byArray);
            }
            if (string.equals("dsa_openssl_asn1") || string == null && dSAPrivateKeySpec == null) {
                dSAPrivateKeySpec = this.decodePEMDSAPrivateKey(byArray);
            }
            if (dSAPrivateKeySpec == null) {
                return null;
            }
            DSAPrivateKeyImpl dSAPrivateKeyImpl = new DSAPrivateKeyImpl(dSAPrivateKeySpec.getP(), dSAPrivateKeySpec.getQ(), dSAPrivateKeySpec.getG(), dSAPrivateKeySpec.getX());
            return dSAPrivateKeyImpl;
        }
        catch (CertificateParsingException certificateParsingException) {
            WeblogicHandler.debugEaten(certificateParsingException);
            return null;
        }
    }

    public PublicKey createPublicKey(byte[] byArray, String string) {
        try {
            SubjectPublicKeyInfo subjectPublicKeyInfo = new SubjectPublicKeyInfo();
            subjectPublicKeyInfo.decode(byArray);
            DSAPublicKeySpec dSAPublicKeySpec = subjectPublicKeyInfo.getDSAKeySpec();
            return new DSAPublicKeyImpl(dSAPublicKeySpec.getP(), dSAPublicKeySpec.getQ(), dSAPublicKeySpec.getG(), dSAPublicKeySpec.getY());
        }
        catch (ASN1ParsingException aSN1ParsingException) {
            WeblogicHandler.debugEaten(aSN1ParsingException);
            return null;
        }
    }

    public PublicKey createPublicKey(BigInteger bigInteger, BigInteger bigInteger2) {
        Object var3_3 = null;
        return null;
    }
}

