/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.tls.provider.kf;

import com.bea.sslplus.WeblogicHandler;
import com.certicom.ecc.interfaces.ECKey;
import com.certicom.ecc.interfaces.ECParams;
import com.certicom.ecc.interfaces.ECPrivateKey;
import com.certicom.ecc.interfaces.ECPublicKey;
import com.certicom.ecc.scheme.CryptoTransform;
import com.certicom.ecc.scheme.CurveList;
import com.certicom.ecc.spec.ECPrivateKeySpec;
import com.certicom.ecc.spec.ECPublicKeySpec;
import com.certicom.ecc.system.CryptoManager;
import com.certicom.security.asn1.ASN1OID;
import com.certicom.security.asn1.ASN1ParsingException;
import com.certicom.security.asn1.ASN1Sequence;
import com.certicom.security.pkcs.pkcs8.PrivateKeyInfo;
import com.certicom.security.pkix.AlgorithmIdentifier;
import com.certicom.security.pkix.SubjectPublicKeyInfo;
import com.certicom.security.sslplus.SEC1PrivateKey;
import com.certicom.tls.provider.KeyFactory;
import com.certicom.tls.provider.spec.ECCpresso_ECPrivateKey;
import com.certicom.tls.provider.spec.ECCpresso_ECPublicKey;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.PublicKey;

public final class ECCpresso_ECKeyFactory
extends KeyFactory {
    private static final ECParams params = CurveList.byName((String)"sect163k1");
    private CryptoTransform keyFactory = (CryptoTransform)CryptoManager.getInstance((Class)CryptoTransform.TYPE, (String)"KEYFAC");

    public PrivateKey createPrivateKey(byte[] byArray, String string) {
        ASN1Sequence aSN1Sequence;
        byte[] byArray2 = byArray;
        byte[] byArray3 = byArray;
        try {
            if (string != "ecc_raw" && string != "ecc_sec1" && string != "pkcs8") {
                throw new IllegalArgumentException("Unsupported Encoding");
            }
            if (string == "ecc_raw") {
                aSN1Sequence = new SEC1PrivateKey(byArray);
                byArray3 = aSN1Sequence.encode();
            }
            if (string == "ecc_raw" || string == "ecc_sec1") {
                aSN1Sequence = new AlgorithmIdentifier("1.3.132.2.0", new ASN1OID(params.getOID()));
                PrivateKeyInfo privateKeyInfo = new PrivateKeyInfo((AlgorithmIdentifier)aSN1Sequence, byArray3);
                byArray2 = privateKeyInfo.encode();
            }
        }
        catch (ASN1ParsingException aSN1ParsingException) {
            // empty catch block
        }
        this.keyFactory.init(5, new Object[]{ECPrivateKey.class, params}, null);
        aSN1Sequence = (ECKey)this.keyFactory.transformToObject(byArray2, 0, byArray2.length, true);
        return new ECCpresso_ECPrivateKey((ECPrivateKeySpec)aSN1Sequence);
    }

    public PublicKey createPublicKey(byte[] byArray, String string) {
        byte[] byArray2;
        AlgorithmIdentifier algorithmIdentifier;
        if (string != null && !string.equals("X509") && byArray[0] != 48) {
            try {
                algorithmIdentifier = new AlgorithmIdentifier("1.2.840.10045.2.1", new ASN1OID("1.3.132.0.1"));
                SubjectPublicKeyInfo subjectPublicKeyInfo = new SubjectPublicKeyInfo(algorithmIdentifier, byArray);
                byArray2 = subjectPublicKeyInfo.encode();
            }
            catch (ASN1ParsingException aSN1ParsingException) {
                WeblogicHandler.debugEaten(aSN1ParsingException);
                byArray2 = byArray;
            }
        } else {
            byArray2 = byArray;
        }
        this.keyFactory.init(5, new Object[]{ECPublicKey.class, params}, null);
        algorithmIdentifier = (ECKey)this.keyFactory.transformToObject(byArray2, 0, byArray2.length, true);
        return new ECCpresso_ECPublicKey((ECPublicKeySpec)algorithmIdentifier);
    }

    public PublicKey createPublicKey(BigInteger bigInteger, BigInteger bigInteger2) {
        Object var3_3 = null;
        return null;
    }
}

