/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.tls.provider.kf;

import com.bea.sslplus.WeblogicHandler;
import com.certicom.ecc.rsa.RSAPublicKey;
import com.certicom.ecc.scheme.CryptoTransform;
import com.certicom.ecc.system.CryptoManager;
import com.certicom.tls.provider.KeyFactory;
import com.certicom.tls.provider.spec.ECCpresso_RSAPrivateKey;
import com.certicom.tls.provider.spec.ECCpresso_RSAPublicKey;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateParsingException;
import java.security.spec.RSAPrivateCrtKeySpec;

public final class ECCpresso_RSAKeyFactory
extends KeyFactory {
    private CryptoTransform keyFactory = (CryptoTransform)CryptoManager.getInstance((Class)CryptoTransform.TYPE, (String)"RSAKEYFAC");

    public PrivateKey createPrivateKey(byte[] byArray, String string) {
        try {
            RSAPrivateCrtKeySpec rSAPrivateCrtKeySpec;
            if (string == null || string.equals("pkcs8")) {
                rSAPrivateCrtKeySpec = this.decodePKCS8RSAPrivateKey(byArray);
            } else if (string.equals("rsa_pkcs1")) {
                rSAPrivateCrtKeySpec = this.decodePKCS1RSAPrivateKey(byArray);
            } else {
                return null;
            }
            return new ECCpresso_RSAPrivateKey(rSAPrivateCrtKeySpec.getModulus(), rSAPrivateCrtKeySpec.getPublicExponent(), rSAPrivateCrtKeySpec.getPrivateExponent(), rSAPrivateCrtKeySpec.getPrimeP(), rSAPrivateCrtKeySpec.getPrimeQ(), rSAPrivateCrtKeySpec.getPrimeExponentP(), rSAPrivateCrtKeySpec.getPrimeExponentQ(), rSAPrivateCrtKeySpec.getCrtCoefficient());
        }
        catch (CertificateParsingException certificateParsingException) {
            WeblogicHandler.debugEaten(certificateParsingException);
            return null;
        }
    }

    public PublicKey createPublicKey(byte[] byArray, String string) {
        this.keyFactory.init(5, new Object[]{RSAPublicKey.class}, null);
        RSAPublicKey rSAPublicKey = (RSAPublicKey)this.keyFactory.transformToObject(byArray, 0, byArray.length, true);
        return new ECCpresso_RSAPublicKey(rSAPublicKey);
    }

    public PublicKey createPublicKey(BigInteger bigInteger, BigInteger bigInteger2) {
        return new ECCpresso_RSAPublicKey(bigInteger, bigInteger2);
    }
}

