/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.tls.provider.kf;

import com.bea.sslplus.WeblogicHandler;
import com.certicom.tls.provider.KeyFactory;
import com.certicom.tls.provider.spec.JSAFE_RSAPrivateKey;
import com.certicom.tls.provider.spec.JSAFE_RSAPublicKey;
import com.rsa.jsafe.JSAFE_AsymmetricCipher;
import com.rsa.jsafe.JSAFE_InvalidParameterException;
import com.rsa.jsafe.JSAFE_UnimplementedException;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateParsingException;
import java.security.spec.RSAPrivateCrtKeySpec;

public final class JSAFE_RSAKeyFactory
extends KeyFactory {
    public JSAFE_RSAKeyFactory() {
        try {
            JSAFE_AsymmetricCipher.getInstance((String)"RSA/PKCS1Block02Pad", (String)"Java");
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            throw noClassDefFoundError;
        }
        catch (JSAFE_UnimplementedException jSAFE_UnimplementedException) {
            WeblogicHandler.debugEaten(jSAFE_UnimplementedException);
        }
        catch (JSAFE_InvalidParameterException jSAFE_InvalidParameterException) {
            WeblogicHandler.debugEaten(jSAFE_InvalidParameterException);
        }
    }

    public PrivateKey createPrivateKey(byte[] byArray, String string) {
        if (string == null || string.equals("pkcs8")) {
            return new JSAFE_RSAPrivateKey(byArray);
        }
        if (string.equals("rsa_pkcs1")) {
            try {
                RSAPrivateCrtKeySpec rSAPrivateCrtKeySpec = this.decodePKCS1RSAPrivateKey(byArray);
                return new JSAFE_RSAPrivateKey(rSAPrivateCrtKeySpec.getModulus(), rSAPrivateCrtKeySpec.getPublicExponent(), rSAPrivateCrtKeySpec.getPrivateExponent(), rSAPrivateCrtKeySpec.getPrimeP(), rSAPrivateCrtKeySpec.getPrimeQ(), rSAPrivateCrtKeySpec.getPrimeExponentP(), rSAPrivateCrtKeySpec.getPrimeExponentQ(), rSAPrivateCrtKeySpec.getCrtCoefficient());
            }
            catch (CertificateParsingException certificateParsingException) {
                WeblogicHandler.debugEaten(certificateParsingException);
                return null;
            }
        }
        return null;
    }

    public PublicKey createPublicKey(byte[] byArray, String string) {
        return new JSAFE_RSAPublicKey(byArray);
    }

    public PublicKey createPublicKey(BigInteger bigInteger, BigInteger bigInteger2) {
        return new JSAFE_RSAPublicKey(bigInteger, bigInteger2);
    }
}

