/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.tls.provider.kpg;

import com.bea.sslplus.WeblogicHandler;
import com.certicom.tls.provider.KeyPairGenerator;
import com.certicom.tls.provider.spec.JSAFE_RSAPrivateKey;
import com.certicom.tls.provider.spec.JSAFE_RSAPublicKey;
import com.certicom.tls.provider.spec.RSAParameters;
import com.rsa.jsafe.JSAFE_InvalidParameterException;
import com.rsa.jsafe.JSAFE_InvalidUseException;
import com.rsa.jsafe.JSAFE_KeyPair;
import com.rsa.jsafe.JSAFE_UnimplementedException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.SecureRandom;

public final class JSAFE_RSAKeyPairGenerator
extends KeyPairGenerator {
    private SecureRandom random;
    private int modulusBits = 512;
    private int publicExponent = 65537;
    private JSAFE_KeyPair kp;

    public void JSAFE_RSAKeyPairGenerator() {
        try {
            this.kp = JSAFE_KeyPair.getInstance((String)"RSA", (String)"Java");
        }
        catch (JSAFE_UnimplementedException jSAFE_UnimplementedException) {
            WeblogicHandler.debugEaten(jSAFE_UnimplementedException);
        }
        catch (JSAFE_InvalidParameterException jSAFE_InvalidParameterException) {
            WeblogicHandler.debugEaten(jSAFE_InvalidParameterException);
        }
    }

    public void initialize(RSAParameters rSAParameters, SecureRandom secureRandom) throws InvalidParameterException {
        try {
            this.kp = JSAFE_KeyPair.getInstance((String)"RSA", (String)"Java");
            this.kp.generateInit(null, new int[]{rSAParameters.getModulusBits(), rSAParameters.getPublicExponent()}, secureRandom);
            this.random = secureRandom;
        }
        catch (Exception exception) {
            WeblogicHandler.debugEaten(exception);
            throw new InvalidParameterException(exception.getMessage());
        }
    }

    public KeyPair genKeyPair() {
        try {
            this.kp.generate();
            JSAFE_RSAPublicKey jSAFE_RSAPublicKey = new JSAFE_RSAPublicKey(this.kp.getPublicKey());
            JSAFE_RSAPrivateKey jSAFE_RSAPrivateKey = new JSAFE_RSAPrivateKey(this.kp.getPrivateKey());
            return new KeyPair(jSAFE_RSAPublicKey, jSAFE_RSAPrivateKey);
        }
        catch (JSAFE_InvalidUseException jSAFE_InvalidUseException) {
            WeblogicHandler.debugEaten(jSAFE_InvalidUseException);
            return null;
        }
    }
}

