/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.tls.provider.mac;

import com.certicom.tls.provider.Mac;
import com.certicom.tls.provider.MessageDigest;
import java.security.Key;

public final class HMAC
extends Mac {
    private static final byte ipadByte = 54;
    private static final byte opadByte = 92;
    private byte[] ipad;
    private byte[] opad;
    private boolean firstPad = true;
    private int blockLength;
    private MessageDigest digest;

    public HMAC(MessageDigest messageDigest, int n) {
        this.digest = messageDigest;
        this.blockLength = n;
    }

    public final int getMacLength() {
        return this.digest.getDigestLength();
    }

    public final void init(Key key) {
        byte[] byArray = key.getEncoded();
        this.digest.reset();
        this.ipad = new byte[this.blockLength];
        this.opad = new byte[this.blockLength];
        if (byArray.length > this.blockLength) {
            byArray = this.digest.digest(byArray);
        }
        System.arraycopy(byArray, 0, this.ipad, 0, byArray.length);
        System.arraycopy(byArray, 0, this.opad, 0, byArray.length);
        int n = 0;
        while (n < this.blockLength) {
            int n2 = n;
            this.ipad[n2] = (byte)(this.ipad[n2] ^ 0x36);
            int n3 = n++;
            this.opad[n3] = (byte)(this.opad[n3] ^ 0x5C);
        }
    }

    public final void update(byte by) {
        if (this.firstPad) {
            this.digest.update(this.ipad);
            this.firstPad = false;
        }
        this.digest.update(by);
    }

    public final void update(byte[] byArray, int n, int n2) {
        if (this.firstPad) {
            this.digest.update(this.ipad);
            this.firstPad = false;
        }
        this.digest.update(byArray, n, n2);
    }

    public final void update(byte[] byArray) {
        if (this.firstPad) {
            this.digest.update(this.ipad);
            this.firstPad = false;
        }
        this.digest.update(byArray);
    }

    public final byte[] doFinal(byte[] byArray) {
        this.update(byArray);
        return this.doFinal();
    }

    public final byte[] doFinal() {
        this.firstPad = true;
        byte[] byArray = this.digest.digest();
        this.digest.update(this.opad);
        return this.digest.digest(byArray);
    }

    public final void reset() {
        this.firstPad = true;
        this.digest.reset();
    }
}

