/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.tls.provider.mac;

import com.certicom.locale.Resources;
import com.certicom.tls.provider.CryptoLabels;
import com.certicom.tls.provider.Mac;
import com.certicom.tls.provider.MessageDigest;
import java.security.Key;

public final class SSL2RecordMac
extends Mac
implements CryptoLabels {
    private byte[] keyBytes;
    private MessageDigest digest;
    private boolean firstPad = true;

    public SSL2RecordMac(MessageDigest messageDigest) {
        this.digest = messageDigest;
    }

    public final int getMacLength() {
        return this.digest.getDigestLength();
    }

    public final void init(Key key) {
        this.keyBytes = key.getEncoded();
        this.digest.reset();
        String string = this.digest.getAlgorithm();
        if (!(string.equalsIgnoreCase("MD5") || string.equalsIgnoreCase("SHA") || string.equalsIgnoreCase("SHA-1"))) {
            throw new IllegalStateException(Resources.getMessage("111"));
        }
    }

    public final void update(byte by) {
        this.update(new byte[]{by});
    }

    public final void update(byte[] byArray, int n, int n2) {
        if (this.firstPad) {
            this.digest.update(this.keyBytes);
            this.firstPad = false;
        }
        this.digest.update(byArray, n, n2);
    }

    public final void update(byte[] byArray) {
        this.update(byArray, 0, byArray.length);
    }

    public final byte[] doFinal(byte[] byArray) {
        this.update(byArray);
        return this.doFinal();
    }

    public final byte[] doFinal() {
        this.firstPad = true;
        byte[] byArray = this.digest.digest();
        return byArray;
    }

    public final void reset() {
        this.firstPad = true;
        this.digest.reset();
    }
}

