/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.tls.provider.mac;

import com.certicom.locale.Resources;
import com.certicom.tls.provider.CryptoLabels;
import com.certicom.tls.provider.Mac;
import com.certicom.tls.provider.MessageDigest;
import java.security.Key;

public final class SSL3RecordMac
extends Mac
implements CryptoLabels {
    private byte[] ipad;
    private byte[] opad;
    private boolean firstPad = true;
    private byte[] keyBytes;
    private MessageDigest digest;

    public SSL3RecordMac(MessageDigest messageDigest) {
        this.digest = messageDigest;
    }

    public final int getMacLength() {
        return this.digest.getDigestLength();
    }

    public final void init(Key key) {
        this.keyBytes = key.getEncoded();
        this.digest.reset();
        String string = this.digest.getAlgorithm();
        if (string.equalsIgnoreCase("MD5")) {
            this.ipad = SSL3_IPAD_MD5;
            this.opad = SSL3_OPAD_MD5;
        } else if (string.equalsIgnoreCase("SHA") || string.equalsIgnoreCase("SHA-1")) {
            this.ipad = SSL3_IPAD_SHA;
            this.opad = SSL3_OPAD_SHA;
        } else {
            throw new IllegalStateException(Resources.getMessage("111"));
        }
    }

    public final void update(byte by) {
        this.update(new byte[]{by});
    }

    public final void update(byte[] byArray, int n, int n2) {
        if (this.firstPad) {
            this.digest.update(this.keyBytes);
            this.digest.update(this.ipad);
            this.firstPad = false;
        }
        this.digest.update(byArray, n, n2);
    }

    public final void update(byte[] byArray) {
        this.update(byArray, 0, byArray.length);
    }

    public final byte[] doFinal(byte[] byArray) {
        this.update(byArray);
        return this.doFinal();
    }

    public final byte[] doFinal() {
        this.firstPad = true;
        byte[] byArray = this.digest.digest();
        this.digest.update(this.keyBytes);
        this.digest.update(this.opad);
        return this.digest.digest(byArray);
    }

    public final void reset() {
        this.firstPad = true;
        this.digest.reset();
    }
}

