/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.tls.provider.md;

import com.certicom.ecc.scheme.CryptoTransform;
import com.certicom.ecc.system.CryptoManager;
import com.certicom.locale.Resources;
import com.certicom.tls.provider.MessageDigest;

public final class ECCpresso_MD5
extends MessageDigest
implements Cloneable {
    private CryptoTransform[] md5copies;
    private boolean[] cloned;
    private int copyNumber = 0;
    private int noOfCopiesMade = 0;
    private static final int MAX_NO_OF_COPIES = 4;
    private static final int DIGEST_LENGTH = 16;

    public ECCpresso_MD5() {
        this.md5copies = new CryptoTransform[4];
        this.cloned = new boolean[4];
        this.noOfCopiesMade = 0;
        this.copyNumber = 0;
        for (int i = 0; i < 4; ++i) {
            this.md5copies[i] = (CryptoTransform)CryptoManager.getInstance((Class)CryptoTransform.TYPE, (String)"MD5");
            this.cloned[i] = false;
        }
        this.reset();
    }

    public final int getDigestLength() {
        return 16;
    }

    public final String getAlgorithm() {
        return "MD5";
    }

    public final void reset() {
        if (this.copyNumber == 0) {
            for (int i = 0; i < 4; ++i) {
                if (this.cloned[i]) continue;
                this.md5copies[i].reset();
                this.md5copies[i].init(5, null, null);
            }
        } else {
            this.md5copies[this.copyNumber].reset();
            this.md5copies[this.copyNumber].init(5, null, null);
        }
    }

    public final void update(byte by) {
        if (this.copyNumber == 0) {
            for (int i = 0; i < 4; ++i) {
                if (this.cloned[i]) continue;
                this.md5copies[i].transform(new byte[]{by}, 0, 1, false);
            }
        } else {
            this.md5copies[this.copyNumber].transform(new byte[]{by}, 0, 1, false);
        }
    }

    public final void update(byte[] byArray) {
        this.update(byArray, 0, byArray.length);
    }

    public final void update(byte[] byArray, int n, int n2) {
        if (this.copyNumber == 0) {
            for (int i = 0; i < 4; ++i) {
                if (this.cloned[i]) continue;
                this.md5copies[i].transform(byArray, n, n2, false);
            }
        } else {
            this.md5copies[this.copyNumber].transform(byArray, n, n2, false);
        }
    }

    public final byte[] digest() {
        byte[] byArray = null;
        if (this.copyNumber == 0) {
            for (int i = 0; i < 4; ++i) {
                if (this.cloned[i]) continue;
                byArray = this.md5copies[i].transform(null, 0, 0, true);
            }
        } else {
            byArray = this.md5copies[this.copyNumber].transform(null, 0, 0, true);
        }
        this.reset();
        return byArray;
    }

    public Object clone() throws CloneNotSupportedException {
        ++this.noOfCopiesMade;
        if (this.cloned[this.copyNumber]) {
            throw new CloneNotSupportedException(Resources.getMessage("175"));
        }
        if (this.noOfCopiesMade >= 4) {
            throw new CloneNotSupportedException(Resources.getMessage("175"));
        }
        return new ECCpresso_MD5(this.md5copies, this.cloned, this.noOfCopiesMade);
    }

    private ECCpresso_MD5(CryptoTransform[] cryptoTransformArray, boolean[] blArray, int n) {
        this.copyNumber = n;
        this.md5copies = cryptoTransformArray;
        this.cloned = blArray;
        blArray[n] = true;
    }
}

