/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.tls.provider.md;

import com.bea.sslplus.WeblogicHandler;
import com.certicom.ecc.scheme.CryptoTransform;
import com.certicom.ecc.system.CryptoManager;
import com.certicom.locale.Resources;
import com.certicom.tls.provider.MessageDigest;

public final class ECCpresso_SHA1
extends MessageDigest
implements Cloneable {
    private static final int MAX_NO_OF_COPIES = 4;
    private int noOfCopiesMade = 0;
    private int copyNumber;
    private CryptoTransform[] sha1copies;
    private boolean[] cloned;

    public ECCpresso_SHA1() throws IllegalArgumentException {
        try {
            this.sha1copies = new CryptoTransform[4];
            this.cloned = new boolean[4];
            this.noOfCopiesMade = 0;
            this.copyNumber = 0;
            for (int i = 0; i < 4; ++i) {
                this.sha1copies[i] = (CryptoTransform)CryptoManager.getInstance((Class)CryptoTransform.TYPE, (String)"SHA-1");
                this.cloned[i] = false;
            }
            this.reset();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            WeblogicHandler.debugEaten(illegalArgumentException);
            throw new IllegalArgumentException(Resources.getMessage("174") + " " + illegalArgumentException.getMessage());
        }
    }

    public void update(byte by) {
        if (this.copyNumber == 0) {
            for (int i = 0; i < 4; ++i) {
                if (this.cloned[i]) continue;
                this.sha1copies[i].transform(new byte[]{by}, 0, 1, false);
            }
        } else {
            this.sha1copies[this.copyNumber].transform(new byte[]{by}, 0, 1, false);
        }
    }

    public void update(byte[] byArray) {
        if (this.copyNumber == 0) {
            for (int i = 0; i < 4; ++i) {
                if (this.cloned[i]) continue;
                this.sha1copies[i].transform(byArray, 0, byArray.length, false);
            }
        } else {
            this.sha1copies[this.copyNumber].transform(byArray, 0, byArray.length, false);
        }
    }

    public void update(byte[] byArray, int n, int n2) {
        if (this.copyNumber == 0) {
            for (int i = 0; i < 4; ++i) {
                if (this.cloned[i]) continue;
                this.sha1copies[i].transform(byArray, n, n2, false);
            }
        } else {
            this.sha1copies[this.copyNumber].transform(byArray, n, n2, false);
        }
    }

    public byte[] digest() {
        byte[] byArray = null;
        if (this.copyNumber == 0) {
            for (int i = 0; i < 4; ++i) {
                if (this.cloned[i]) continue;
                byArray = this.sha1copies[i].transform(null, 0, 0, true);
            }
        } else {
            byArray = this.sha1copies[this.copyNumber].transform(null, 0, 0, true);
        }
        this.reset();
        return byArray;
    }

    public void reset() {
        if (this.copyNumber == 0) {
            for (int i = 0; i < 4; ++i) {
                if (this.cloned[i]) continue;
                this.sha1copies[i].reset();
                this.sha1copies[i].init(5, null, null);
            }
        } else {
            this.sha1copies[this.copyNumber].reset();
            this.sha1copies[this.copyNumber].init(5, null, null);
        }
    }

    public int getDigestLength() {
        return this.sha1copies[0].outputSize(0, true);
    }

    public String getAlgorithm() {
        return "SHA-1";
    }

    public Object clone() throws CloneNotSupportedException {
        ++this.noOfCopiesMade;
        if (this.cloned[this.copyNumber]) {
            throw new CloneNotSupportedException(Resources.getMessage("175"));
        }
        if (this.noOfCopiesMade >= 4) {
            throw new CloneNotSupportedException(Resources.getMessage("175"));
        }
        return new ECCpresso_SHA1(this.sha1copies, this.cloned, this.noOfCopiesMade);
    }

    private ECCpresso_SHA1(CryptoTransform[] cryptoTransformArray, boolean[] blArray, int n) {
        this.copyNumber = n;
        this.sha1copies = cryptoTransformArray;
        this.cloned = blArray;
        blArray[n] = true;
    }
}

