/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.tls.provider.sig;

import com.certicom.ecc.scheme.CryptoTransform;
import com.certicom.ecc.system.CryptoManager;
import com.certicom.ecc.system.SystemConfig;
import com.certicom.locale.Resources;
import com.certicom.tls.provider.Signature;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.util.Random;

public final class ECCpresso_DSA
extends Signature {
    public static int RAW = 1;
    public static int SHA1 = 2;
    CryptoTransform dsa = null;
    private int mode = 0;
    private int storedECCHashMode = 0;
    private SecureRandom secureRandom = null;
    private BigInteger p;
    private BigInteger q;
    private BigInteger g;

    public ECCpresso_DSA(int n) throws SignatureException, ClassNotFoundException {
        if (n != RAW && n != SHA1) {
            throw new SignatureException(Resources.getMessage("193"));
        }
        this.mode = n;
        this.storedECCHashMode = SystemConfig.getConfig().getHashType();
        this.dsa = (CryptoTransform)CryptoManager.getInstance((Class)CryptoTransform.TYPE, (String)"DSA");
        if (n == RAW) {
            this.dsa.setHashMode(1);
        } else {
            this.dsa.setHashMode(2);
        }
    }

    public void initSign(PrivateKey privateKey, SecureRandom secureRandom) throws InvalidKeyException {
        if (!(privateKey instanceof DSAPrivateKey)) {
            throw new InvalidKeyException(Resources.getMessage("194"));
        }
        DSAPrivateKey dSAPrivateKey = (DSAPrivateKey)privateKey;
        DSAParams dSAParams = dSAPrivateKey.getParams();
        this.p = dSAParams.getP();
        this.q = dSAParams.getQ();
        this.g = dSAParams.getG();
        this.secureRandom = secureRandom;
        this.dsa.init(1, new Object[]{this.p.toByteArray(), this.q.toByteArray(), this.g.toByteArray(), dSAPrivateKey.getX().toByteArray()}, (Random)secureRandom);
    }

    public void initVerify(PublicKey publicKey) throws InvalidKeyException {
        if (!(publicKey instanceof DSAPublicKey)) {
            throw new InvalidKeyException(Resources.getMessage("94"));
        }
        DSAPublicKey dSAPublicKey = (DSAPublicKey)publicKey;
        DSAParams dSAParams = dSAPublicKey.getParams();
        this.p = dSAParams.getP();
        this.q = dSAParams.getQ();
        this.g = dSAParams.getG();
        this.dsa.init(2, new Object[]{this.p.toByteArray(), this.q.toByteArray(), this.g.toByteArray(), dSAPublicKey.getY().toByteArray()}, (Random)this.secureRandom);
    }

    public byte[] sign() throws SignatureException {
        byte[] byArray = this.dsa.transform(null, 0, 0, true);
        SystemConfig.getConfig().setHashType(this.storedECCHashMode);
        return byArray;
    }

    public boolean verify(byte[] byArray) throws SignatureException {
        boolean bl = false;
        this.dsa.transform(null, 0, 0, true);
        bl = this.dsa.verify(byArray, 0, byArray.length);
        SystemConfig.getConfig().setHashType(this.storedECCHashMode);
        return bl;
    }

    public void update(byte by) throws SignatureException {
        this.update(new byte[]{by});
    }

    public void update(byte[] byArray) throws SignatureException {
        this.update(byArray, 0, byArray.length);
    }

    public void update(byte[] byArray, int n, int n2) throws SignatureException {
        this.dsa.transform(byArray, n, n2, false);
    }

    public String toString() {
        return "";
    }
}

