/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.tls.provider.sig;

import com.certicom.ecc.interfaces.ECPrivateKey;
import com.certicom.ecc.interfaces.ECPublicKey;
import com.certicom.ecc.scheme.CryptoTransform;
import com.certicom.ecc.spec.ECPrivateKeySpec;
import com.certicom.ecc.spec.ECPublicKeySpec;
import com.certicom.ecc.system.CryptoManager;
import com.certicom.locale.Resources;
import com.certicom.tls.provider.Signature;
import com.certicom.tls.provider.spec.ECCpresso_ECPrivateKey;
import com.certicom.tls.provider.spec.ECCpresso_ECPublicKey;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.util.Random;

public final class ECCpresso_ECDSASignature
extends Signature {
    public static final int RAW = 1;
    public static final int SHA1 = 2;
    CryptoTransform ecdsa = (CryptoTransform)CryptoManager.getInstance((Class)CryptoTransform.TYPE, (String)"ECDSA");

    public ECCpresso_ECDSASignature(int n) throws ClassNotFoundException {
        switch (n) {
            case 1: {
                this.ecdsa.setHashMode(1);
                break;
            }
            case 2: {
                this.ecdsa.setHashMode(2);
            }
        }
    }

    public void initSign(PrivateKey privateKey, SecureRandom secureRandom) throws InvalidKeyException {
        ECPrivateKeySpec eCPrivateKeySpec;
        if (privateKey instanceof ECCpresso_ECPrivateKey) {
            eCPrivateKeySpec = ((ECCpresso_ECPrivateKey)privateKey).getKey();
        } else if (privateKey instanceof ECPrivateKey) {
            eCPrivateKeySpec = (ECPrivateKey)privateKey;
        } else {
            throw new InvalidKeyException(Resources.getMessage("96"));
        }
        this.ecdsa.init(1, new Object[]{eCPrivateKeySpec}, (Random)secureRandom);
    }

    public void initVerify(PublicKey publicKey) throws InvalidKeyException {
        ECPublicKeySpec eCPublicKeySpec;
        if (publicKey instanceof ECCpresso_ECPublicKey) {
            eCPublicKeySpec = ((ECCpresso_ECPublicKey)publicKey).getKey();
        } else if (publicKey instanceof ECPublicKey) {
            eCPublicKeySpec = (ECPublicKey)publicKey;
        } else {
            throw new InvalidKeyException(Resources.getMessage("80"));
        }
        this.ecdsa.init(2, new Object[]{eCPublicKeySpec}, null);
    }

    public byte[] sign() throws SignatureException {
        return this.ecdsa.transform(null, 0, 0, true);
    }

    public boolean verify(byte[] byArray) throws SignatureException {
        return this.ecdsa.verify(byArray, 0, byArray.length);
    }

    public void update(byte by) throws SignatureException {
        this.update(new byte[]{by});
    }

    public void update(byte[] byArray) throws SignatureException {
        this.update(byArray, 0, byArray.length);
    }

    public void update(byte[] byArray, int n, int n2) {
        this.ecdsa.transform(byArray, n, n2, false);
    }

    public String toString() {
        return "";
    }
}

