/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.tls.provider.sig;

import com.certicom.ecc.rsa.RSAPublicKey;
import com.certicom.ecc.scheme.CryptoTransform;
import com.certicom.ecc.system.CryptoManager;
import com.certicom.locale.Resources;
import com.certicom.tls.provider.Signature;
import com.certicom.tls.provider.kf.ECCpresso_RSAKeyFactory;
import com.certicom.tls.provider.spec.ECCpresso_RSAPrivateKey;
import com.certicom.tls.provider.spec.ECCpresso_RSAPublicKey;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.interfaces.RSAPrivateKey;

public final class ECCpresso_RSASignature
extends Signature {
    byte[] digest = null;
    boolean isRaw = false;
    CryptoTransform rsa = (CryptoTransform)CryptoManager.getInstance((Class)CryptoTransform.TYPE, (String)"RSA");
    int keyLen;
    String signatureType;

    public ECCpresso_RSASignature(String string) throws ClassNotFoundException {
        this.signatureType = string;
    }

    public void initSign(PrivateKey privateKey, SecureRandom secureRandom) throws InvalidKeyException {
        Object[] objectArray;
        ECCpresso_RSAPrivateKey eCCpresso_RSAPrivateKey;
        if (privateKey instanceof ECCpresso_RSAPrivateKey) {
            eCCpresso_RSAPrivateKey = (ECCpresso_RSAPrivateKey)privateKey;
        } else if (privateKey instanceof RSAPrivateKey) {
            objectArray = new ECCpresso_RSAKeyFactory();
            eCCpresso_RSAPrivateKey = (ECCpresso_RSAPrivateKey)objectArray.createPrivateKey(privateKey.getEncoded(), null);
        } else {
            throw new InvalidKeyException(Resources.getMessage("97"));
        }
        objectArray = null;
        String string = "EMSA-PKCS1-v1_5-Encode";
        if (this.signatureType.indexOf("SHA") >= 0) {
            objectArray = new Object[]{"SHA-1", "MGF1"};
        } else if (this.signatureType.indexOf("MD5") >= 0 || this.signatureType.indexOf("MD-5") >= 0) {
            objectArray = new Object[]{"MD5", "MGF1"};
        } else if (this.signatureType.indexOf("MD2") >= 0 || this.signatureType.indexOf("MD-2") >= 0) {
            objectArray = new Object[]{"MD2", "MGF1"};
        } else if (this.signatureType.equals("RSA")) {
            this.keyLen = (eCCpresso_RSAPrivateKey.getKey().p().bitLength() * 2 + 7) / 8;
            objectArray = new Object[]{"NoHash", new Object[]{"NoHash", new Integer(this.keyLen - 1)}};
            string = "RawRSA";
            this.isRaw = true;
        }
        com.certicom.ecc.rsa.RSAPrivateKey rSAPrivateKey = eCCpresso_RSAPrivateKey.getKey();
        this.rsa.init(1, new Object[]{rSAPrivateKey, string, objectArray}, null);
    }

    public void initVerify(PublicKey publicKey) throws InvalidKeyException {
        ECCpresso_RSAPublicKey eCCpresso_RSAPublicKey;
        if (publicKey instanceof ECCpresso_RSAPublicKey) {
            eCCpresso_RSAPublicKey = (ECCpresso_RSAPublicKey)publicKey;
        } else if (publicKey instanceof java.security.interfaces.RSAPublicKey) {
            eCCpresso_RSAPublicKey = new ECCpresso_RSAPublicKey(((java.security.interfaces.RSAPublicKey)publicKey).getModulus(), ((java.security.interfaces.RSAPublicKey)publicKey).getPublicExponent());
        } else {
            throw new InvalidKeyException(Resources.getMessage("97"));
        }
        Object[] objectArray = null;
        String string = "EMSA-PKCS1-v1_5-Encode";
        if (this.signatureType.indexOf("SHA") >= 0) {
            objectArray = new Object[]{"SHA-1", "MGF1"};
        } else if (this.signatureType.indexOf("MD5") >= 0 || this.signatureType.indexOf("MD-5") >= 0) {
            objectArray = new Object[]{"MD5", "MGF1"};
        } else if (this.signatureType.indexOf("MD2") >= 0 || this.signatureType.indexOf("MD-2") >= 0) {
            objectArray = new Object[]{"MD2", "MGF1"};
        } else if (this.signatureType.equals("RSA")) {
            this.keyLen = (eCCpresso_RSAPublicKey.getKey().n().bitLength() + 7) / 8;
            objectArray = new Object[]{"NoHash", new Object[]{"NoHash", new Integer(this.keyLen - 1)}};
            string = "RawRSA";
            this.isRaw = true;
        }
        RSAPublicKey rSAPublicKey = eCCpresso_RSAPublicKey.getKey();
        this.rsa.init(2, new Object[]{rSAPublicKey, string, objectArray}, null);
    }

    public byte[] sign() throws SignatureException {
        if (this.isRaw) {
            byte[] byArray = new byte[this.keyLen - 1];
            byArray[0] = 1;
            for (int i = 1; i < this.keyLen - 1; ++i) {
                byArray[i] = -1;
            }
            byArray[this.keyLen - this.digest.length - 2] = 0;
            System.arraycopy(this.digest, 0, byArray, this.keyLen - this.digest.length - 1, this.digest.length);
            return this.rsa.transform(byArray, 0, byArray.length, true);
        }
        return this.rsa.transform(null, 0, 0, true);
    }

    public boolean verify(byte[] byArray) throws SignatureException {
        if (this.isRaw) {
            byte[] byArray2 = new byte[this.keyLen - 1];
            byArray2[0] = 1;
            for (int i = 1; i < this.keyLen - 1; ++i) {
                byArray2[i] = -1;
            }
            byArray2[this.keyLen - this.digest.length - 2] = 0;
            System.arraycopy(this.digest, 0, byArray2, this.keyLen - this.digest.length - 1, this.digest.length);
            this.rsa.transform(byArray2, 0, byArray2.length, null, 0, true);
            return this.rsa.verify(byArray, 0, byArray.length);
        }
        this.rsa.transform(null, 0, 0, true);
        return this.rsa.verify(byArray, 0, byArray.length);
    }

    public void update(byte by) throws SignatureException {
        this.update(new byte[]{by});
    }

    public void update(byte[] byArray) throws SignatureException {
        this.update(byArray, 0, byArray.length);
    }

    public void update(byte[] byArray, int n, int n2) throws SignatureException {
        if (this.isRaw) {
            if (this.digest == null) {
                this.digest = new byte[n2];
                System.arraycopy(byArray, n, this.digest, 0, n2);
            } else {
                byte[] byArray2 = new byte[this.digest.length + n2];
                System.arraycopy(this.digest, 0, byArray2, 0, this.digest.length);
                System.arraycopy(byArray, 0, byArray2, this.digest.length, n2);
                this.digest = byArray2;
            }
        } else {
            this.rsa.transform(byArray, n, n2, null, 0, false);
        }
    }

    public String toString() {
        return "";
    }

    static {
        CryptoManager.addScheme((String)"MD5", (String)"com.certicom.ecc.scheme.CryptoTransform", (String)"com.certicom.tls.provider.sig.ECCpresso_RSASignature_MD5Transform", null);
        CryptoManager.addScheme((String)"MD2", (String)"com.certicom.ecc.scheme.CryptoTransform", (String)"com.certicom.tls.provider.sig.ECCpresso_RSASignature_MD2Transform", null);
        CryptoManager.addScheme((String)"NoHash", (String)"com.certicom.ecc.scheme.CryptoTransform", (String)"com.certicom.ecc.rsa.NoHash", null);
    }
}

