/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.tls.provider.sig;

import com.bea.sslplus.WeblogicHandler;
import com.certicom.locale.Resources;
import com.certicom.tls.provider.Signature;
import com.certicom.tls.provider.kf.JSAFE_RSAKeyFactory;
import com.certicom.tls.provider.spec.JSAFE_RSAPrivateKey;
import com.certicom.tls.provider.spec.JSAFE_RSAPublicKey;
import com.rsa.jsafe.JSAFE_InvalidParameterException;
import com.rsa.jsafe.JSAFE_Signature;
import com.rsa.jsafe.JSAFE_UnimplementedException;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;

public final class JSAFE_RSASignature
extends Signature
implements Cloneable {
    private JSAFE_Signature signature;
    private boolean signing;
    private int hashType = 0;

    private JSAFE_RSASignature(JSAFE_Signature jSAFE_Signature, boolean bl) {
        this.signature = jSAFE_Signature;
        this.signing = bl;
    }

    public JSAFE_RSASignature() {
        try {
            JSAFE_Signature.getInstance((String)"NoDigest/RSA/PKCS1Block01Pad", (String)"Java");
        }
        catch (JSAFE_UnimplementedException jSAFE_UnimplementedException) {
            WeblogicHandler.debugEaten(jSAFE_UnimplementedException);
        }
        catch (JSAFE_InvalidParameterException jSAFE_InvalidParameterException) {
            WeblogicHandler.debugEaten(jSAFE_InvalidParameterException);
        }
    }

    public JSAFE_RSASignature(String string) {
        try {
            JSAFE_Signature.getInstance((String)"NoDigest/RSA/PKCS1Block01Pad", (String)"Java");
        }
        catch (JSAFE_UnimplementedException jSAFE_UnimplementedException) {
            WeblogicHandler.debugEaten(jSAFE_UnimplementedException);
        }
        catch (JSAFE_InvalidParameterException jSAFE_InvalidParameterException) {
            WeblogicHandler.debugEaten(jSAFE_InvalidParameterException);
        }
        if (string.indexOf("MD5") >= 0) {
            this.hashType = 1;
        } else if (string.indexOf("SHA") >= 0) {
            this.hashType = 2;
        } else if (string.indexOf("MD2") >= 0) {
            this.hashType = 3;
        }
        this.signing = true;
    }

    public void initSign(PrivateKey privateKey, SecureRandom secureRandom) throws InvalidKeyException {
        try {
            JSAFE_RSAPrivateKey jSAFE_RSAPrivateKey;
            if (privateKey instanceof JSAFE_RSAPrivateKey) {
                jSAFE_RSAPrivateKey = (JSAFE_RSAPrivateKey)privateKey;
            } else if (privateKey instanceof RSAPrivateKey) {
                JSAFE_RSAKeyFactory jSAFE_RSAKeyFactory = new JSAFE_RSAKeyFactory();
                jSAFE_RSAPrivateKey = (JSAFE_RSAPrivateKey)jSAFE_RSAKeyFactory.createPrivateKey(((RSAPrivateKey)privateKey).getEncoded(), null);
            } else {
                throw new InvalidKeyException(Resources.getMessage("97"));
            }
            this.signature = JSAFE_Signature.getInstance((String)"MD5/RSA/PKCS1Block01Pad", (String)"Java");
            this.signature.signInit(jSAFE_RSAPrivateKey.getKey(), secureRandom);
            this.signing = true;
        }
        catch (Exception exception) {
            WeblogicHandler.debugEaten(exception);
            throw new InvalidKeyException(exception.getMessage());
        }
    }

    public void initVerify(PublicKey publicKey) throws InvalidKeyException {
        try {
            JSAFE_RSAPublicKey jSAFE_RSAPublicKey;
            if (publicKey instanceof JSAFE_RSAPublicKey) {
                jSAFE_RSAPublicKey = (JSAFE_RSAPublicKey)publicKey;
            } else if (publicKey instanceof RSAPublicKey) {
                jSAFE_RSAPublicKey = new JSAFE_RSAPublicKey(((RSAPublicKey)publicKey).getModulus(), ((RSAPublicKey)publicKey).getPublicExponent());
            } else {
                throw new InvalidKeyException(Resources.getMessage("97"));
            }
            switch (this.hashType) {
                case 1: {
                    this.signature = JSAFE_Signature.getInstance((String)"MD5/RSA/PKCS1Block01Pad", (String)"Java");
                    break;
                }
                case 2: {
                    this.signature = JSAFE_Signature.getInstance((String)"SHA1/RSA/PKCS1Block01Pad", (String)"Java");
                    break;
                }
                case 3: {
                    this.signature = JSAFE_Signature.getInstance((String)"MD2/RSA/PKCS1Block01Pad", (String)"Java");
                    break;
                }
                default: {
                    this.signature = JSAFE_Signature.getInstance((String)"NoDigest/RSA/PKCS1Block01Pad", (String)"Java");
                }
            }
            this.signature.verifyInit(jSAFE_RSAPublicKey.getKey(), null);
            this.signing = false;
        }
        catch (Exception exception) {
            WeblogicHandler.debugEaten(exception);
            throw new InvalidKeyException(exception.getMessage());
        }
    }

    public byte[] sign() throws SignatureException {
        try {
            return this.signature.signFinal();
        }
        catch (Exception exception) {
            WeblogicHandler.debugEaten(exception);
            throw new SignatureException(exception.getMessage());
        }
    }

    public boolean verify(byte[] byArray) throws SignatureException {
        try {
            return this.signature.verifyFinal(byArray, 0, byArray.length);
        }
        catch (Exception exception) {
            WeblogicHandler.debugEaten(exception);
            throw new SignatureException(exception.getMessage());
        }
    }

    public void update(byte by) throws SignatureException {
        this.update(new byte[]{by});
    }

    public void update(byte[] byArray) throws SignatureException {
        this.update(byArray, 0, byArray.length);
    }

    public void update(byte[] byArray, int n, int n2) throws SignatureException {
        try {
            if (this.signing) {
                this.signature.signUpdate(byArray, n, n2);
            } else {
                this.signature.verifyUpdate(byArray, n, n2);
            }
        }
        catch (Exception exception) {
            WeblogicHandler.debugEaten(exception);
            throw new SignatureException(exception.getMessage());
        }
    }

    public String toString() {
        return "";
    }

    public Object clone() throws CloneNotSupportedException {
        return new JSAFE_RSASignature((JSAFE_Signature)this.signature.clone(), this.signing);
    }
}

