/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.tls.provider.spec;

import java.math.BigInteger;

public final class DHParameters {
    private static final BigInteger G = BigInteger.valueOf(2L);
    private static final BigInteger P = new BigInteger("179769313486231590770839156793787453197860296048756011706444423684197180216158519368947833795864925541502180565485980503646440548199239100050792877003355816639229553136239076508735759914822574862575007425302077447712589550957937778424442426617334727629299387668709205606050270810842907692932019128194467627007", 10);
    private static final byte[] P512Bytes = new byte[]{-11, 42, -1, 60, -31, -79, 41, 64, 24, 17, -115, 124, -124, -89, 10, 114, -42, -122, -60, 3, 25, -56, 7, 41, 122, -54, -107, 12, -39, -106, -97, -85, -48, 10, 80, -101, 2, 70, -45, 8, 61, 102, -92, 93, 65, -97, -100, 124, -67, -119, 75, 34, 25, 38, -70, -85, -94, 94, -61, 85, -23, 42, 5, 95};
    private static final BigInteger P512 = new BigInteger(1, P512Bytes);
    private BigInteger p;
    private BigInteger g;
    private int l;

    public DHParameters() {
        this.g = G;
        this.p = P;
        this.l = 1024;
    }

    public DHParameters(int n) {
        switch (n) {
            case 512: {
                this.l = n;
                this.g = G;
                this.p = P512;
                break;
            }
            case 1024: {
                this.g = G;
                this.p = P;
                this.l = 1024;
                break;
            }
            default: {
                throw new IllegalArgumentException("illegal DH parameter length");
            }
        }
    }

    public DHParameters(BigInteger bigInteger, BigInteger bigInteger2) {
        this.p = bigInteger;
        this.g = bigInteger2;
        this.l = 0;
    }

    public DHParameters(BigInteger bigInteger, BigInteger bigInteger2, int n) {
        this.p = bigInteger;
        this.g = bigInteger2;
        this.l = n;
    }

    public int getL() {
        return this.l;
    }

    public BigInteger getP() {
        return this.p;
    }

    public BigInteger getG() {
        return this.g;
    }
}

