/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.tls.provider.spec;

import com.bea.sslplus.WeblogicHandler;
import com.certicom.tls.record.Util;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.PublicKey;

public final class DHPublicKey
implements PublicKey {
    private BigInteger y;
    private BigInteger p;
    private BigInteger g;

    public DHPublicKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        this.y = bigInteger;
        this.p = bigInteger2;
        this.g = bigInteger3;
    }

    public BigInteger getY() {
        return this.y;
    }

    public BigInteger getP() {
        return this.p;
    }

    public BigInteger getG() {
        return this.g;
    }

    public String getAlgorithm() {
        return "DH";
    }

    public String getFormat() {
        return "TLS";
    }

    public byte[] getEncoded() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            Util.writeBytesLength16(Util.toUnsignedInteger(this.p), byteArrayOutputStream);
            Util.writeBytesLength16(Util.toUnsignedInteger(this.g), byteArrayOutputStream);
            Util.writeBytesLength16(Util.toUnsignedInteger(this.y), byteArrayOutputStream);
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            WeblogicHandler.debugEaten(iOException);
            return null;
        }
    }
}

