/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.tls.provider.spec;

import com.bea.sslplus.WeblogicHandler;
import com.rsa.jsafe.JSAFE_PublicKey;
import com.rsa.jsafe.JSAFE_UnimplementedException;
import java.math.BigInteger;
import java.security.interfaces.RSAPublicKey;

public final class JSAFE_RSAPublicKey
implements RSAPublicKey {
    private JSAFE_PublicKey key;
    private BigInteger n;
    private BigInteger e;

    public JSAFE_RSAPublicKey(byte[] byArray) {
        this.setKey(byArray);
        try {
            byte[][] byArray2 = this.key.getKeyData("RSAPublicKey");
            this.e = new BigInteger(1, byArray2[1]);
            this.n = new BigInteger(1, byArray2[0]);
        }
        catch (JSAFE_UnimplementedException jSAFE_UnimplementedException) {
            WeblogicHandler.debugEaten(jSAFE_UnimplementedException);
        }
    }

    public JSAFE_RSAPublicKey(BigInteger bigInteger, BigInteger bigInteger2) {
        byte[] byArray = JSAFE_RSAPublicKey.encodeRSAPublicKey(bigInteger, bigInteger2);
        this.setKey(byArray);
        this.n = bigInteger;
        this.e = bigInteger2;
    }

    public JSAFE_RSAPublicKey(JSAFE_PublicKey jSAFE_PublicKey) {
        this.key = jSAFE_PublicKey;
        byte[][] byArray = jSAFE_PublicKey.getKeyData();
        this.e = new BigInteger(1, byArray[1]);
        this.n = new BigInteger(1, byArray[0]);
    }

    public JSAFE_PublicKey getKey() {
        return this.key;
    }

    public BigInteger getModulus() {
        return this.n;
    }

    public BigInteger getPublicExponent() {
        return this.e;
    }

    public String getAlgorithm() {
        return "RSA";
    }

    public String getFormat() {
        return "X.509";
    }

    public byte[] getEncoded() {
        try {
            return this.key.getKeyData("RSAPublicKeyBER")[0];
        }
        catch (JSAFE_UnimplementedException jSAFE_UnimplementedException) {
            WeblogicHandler.debugEaten(jSAFE_UnimplementedException);
            throw new IllegalStateException();
        }
    }

    private void setKey(byte[] byArray) {
        try {
            this.key = JSAFE_PublicKey.getInstance((byte[])byArray, (int)0, (String)"Java");
        }
        catch (JSAFE_UnimplementedException jSAFE_UnimplementedException) {
            WeblogicHandler.debugEaten(jSAFE_UnimplementedException);
            throw new IllegalStateException();
        }
    }

    public static byte[] encodeRSAPublicKey(BigInteger bigInteger, BigInteger bigInteger2) {
        byte[] byArray;
        byte[] byArray2;
        byte[] byArray3 = JSAFE_RSAPublicKey.encodeInteger(bigInteger);
        byte[] byArray4 = JSAFE_RSAPublicKey.encodeInteger(bigInteger2);
        byte[] byArray5 = new byte[]{48, -126, 0, 0, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 3, -126, 0, 0, 0};
        byte[] byArray6 = new byte[]{48, -127, 0, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 3, -127, 0, 0};
        byte[] byArray7 = new byte[]{48, 0, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 3, 0, 0};
        int n = byArray3.length + byArray4.length;
        if (n >= 128) {
            if (n >= 256) {
                byArray2 = new byte[n + 4];
                byArray2[0] = 48;
                byArray2[1] = -126;
                byArray2[2] = (byte)(n >> 8);
                byArray2[3] = (byte)n;
                System.arraycopy(byArray3, 0, byArray2, 4, byArray3.length);
                System.arraycopy(byArray4, 0, byArray2, 4 + byArray3.length, byArray4.length);
            } else {
                byArray2 = new byte[n + 3];
                byArray2[0] = 48;
                byArray2[1] = -127;
                byArray2[2] = (byte)n;
                System.arraycopy(byArray3, 0, byArray2, 3, byArray3.length);
                System.arraycopy(byArray4, 0, byArray2, 3 + byArray3.length, byArray4.length);
            }
        } else {
            byArray2 = new byte[n + 2];
            byArray2[0] = 48;
            byArray2[1] = (byte)n;
            System.arraycopy(byArray3, 0, byArray2, 2, byArray3.length);
            System.arraycopy(byArray4, 0, byArray2, 2 + byArray3.length, byArray4.length);
        }
        if (byArray2.length >= 128) {
            if (byArray2.length >= 256) {
                byArray = new byte[byArray2.length + byArray5.length];
                System.arraycopy(byArray5, 0, byArray, 0, byArray5.length);
                byArray[2] = (byte)(byArray2.length + 20 >> 8);
                byArray[3] = (byte)(byArray2.length + 20);
                byArray[21] = (byte)(byArray2.length + 1 >> 8);
                byArray[22] = (byte)(byArray2.length + 1);
                System.arraycopy(byArray2, 0, byArray, byArray5.length, byArray2.length);
            } else {
                byArray = new byte[byArray2.length + byArray6.length];
                System.arraycopy(byArray6, 0, byArray, 0, byArray6.length);
                byArray[2] = (byte)(byArray2.length + 19);
                byArray[20] = (byte)(byArray2.length + 1);
                System.arraycopy(byArray2, 0, byArray, byArray6.length, byArray2.length);
            }
        } else {
            byArray = new byte[byArray2.length + byArray7.length];
            System.arraycopy(byArray7, 0, byArray, 0, byArray7.length);
            byArray[1] = (byte)(byArray2.length + 18);
            byArray[18] = (byte)(byArray2.length + 1);
            System.arraycopy(byArray2, 0, byArray, byArray7.length, byArray2.length);
        }
        return byArray;
    }

    protected static byte[] encodeInteger(BigInteger bigInteger) {
        byte[] byArray;
        boolean bl;
        byte[] byArray2 = bigInteger.toByteArray();
        boolean bl2 = bl = (byArray2[0] & 0x80) != 0;
        if (byArray2.length >= 128) {
            if (byArray2.length >= 256) {
                byArray = new byte[byArray2.length + (bl ? 5 : 4)];
                byArray[0] = 2;
                byArray[1] = -126;
                byArray[2] = (byte)(byArray2.length + (bl ? 1 : 0) >> 8);
                byArray[3] = (byte)(byArray2.length + (bl ? 1 : 0));
                if (bl) {
                    byArray[4] = 0;
                    System.arraycopy(byArray2, 0, byArray, 5, byArray2.length);
                } else {
                    System.arraycopy(byArray2, 0, byArray, 4, byArray2.length);
                }
            } else {
                byArray = new byte[byArray2.length + (bl ? 4 : 3)];
                byArray[0] = 2;
                byArray[1] = -127;
                byArray[2] = (byte)(byArray2.length + (bl ? 1 : 0));
                if (bl) {
                    byArray[3] = 0;
                    System.arraycopy(byArray2, 0, byArray, 4, byArray2.length);
                } else {
                    System.arraycopy(byArray2, 0, byArray, 3, byArray2.length);
                }
            }
        } else {
            byArray = new byte[byArray2.length + (bl ? 3 : 2)];
            byArray[0] = 2;
            byArray[1] = (byte)(byArray2.length + (bl ? 1 : 0));
            if (bl) {
                System.arraycopy(byArray2, 0, byArray, 3, byArray2.length);
            } else {
                System.arraycopy(byArray2, 0, byArray, 2, byArray2.length);
            }
        }
        return byArray;
    }
}

