/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.tls.record;

import com.bea.sslplus.WeblogicHandler;
import com.certicom.tls.ciphersuite.CryptoNames;
import com.certicom.tls.provider.Cipher;
import com.certicom.tls.provider.Mac;
import com.certicom.tls.record.Util;

public final class CryptoRecordState
implements CryptoNames {
    private long sequenceNumber = 0L;
    private boolean topBitSet = false;
    private Cipher cipher;
    private Mac mac;

    public CryptoRecordState(Cipher cipher, Mac mac) {
        this.cipher = cipher;
        this.mac = mac;
    }

    public CryptoRecordState() {
        try {
            this.cipher = Cipher.getInstance("NullCipher");
            this.mac = Mac.getInstance("NullMac");
        }
        catch (Exception exception) {
            WeblogicHandler.debugEaten(exception);
        }
    }

    public void setCipher(Cipher cipher) {
        this.cipher = cipher;
    }

    public void setMac(Mac mac) {
        this.mac = mac;
    }

    byte[] getSequenceNumber() {
        if (this.topBitSet) {
            this.sequenceNumber |= Long.MIN_VALUE;
        }
        return Util.toUInt64(this.sequenceNumber);
    }

    byte[] getSSL2SequenceNumber() {
        if (this.topBitSet) {
            this.sequenceNumber |= Long.MIN_VALUE;
        }
        return Util.toUInt32((int)this.sequenceNumber);
    }

    Cipher getCipher() {
        return this.cipher;
    }

    Mac getMac() {
        return this.mac;
    }

    public void incrementSequenceNumber() {
        if (this.sequenceNumber == Long.MAX_VALUE) {
            this.topBitSet = !this.topBitSet;
            this.sequenceNumber = 0L;
        } else {
            ++this.sequenceNumber;
        }
    }
}

