/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.tls.record;

import com.bea.sslplus.WeblogicHandler;
import com.certicom.locale.Resources;
import com.certicom.tls.interfaceimpl.ProtocolVersion;
import com.certicom.tls.interfaceimpl.ProtocolVersions;
import com.certicom.tls.interfaceimpl.TLSConnectionImpl;
import com.certicom.tls.provider.Cipher;
import com.certicom.tls.provider.Mac;
import com.certicom.tls.record.CryptoRecordState;
import com.certicom.tls.record.Util;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class MessageEncryptor
implements ProtocolVersions {
    private ByteArrayOutputStream buffer;
    private CryptoRecordState cryptoRecordState;
    private TLSConnectionImpl connection;
    private int WRITE_BLOCK_SIZE = 16384;

    public MessageEncryptor(TLSConnectionImpl tLSConnectionImpl) {
        this.connection = tLSConnectionImpl;
        this.cryptoRecordState = new CryptoRecordState();
        this.buffer = new ByteArrayOutputStream(1460);
    }

    public void resetCryptoBuffer() {
        this.buffer.reset();
    }

    public void setCryptoBuffer(ByteArrayOutputStream byteArrayOutputStream) {
        this.buffer = byteArrayOutputStream;
    }

    public ByteArrayOutputStream getCryptoBuffer() {
        return this.buffer;
    }

    public void setCryptoRecordState(CryptoRecordState cryptoRecordState) {
        this.cryptoRecordState = cryptoRecordState;
    }

    public CryptoRecordState getCryptoRecordState() {
        return this.cryptoRecordState;
    }

    void compressEncryptSend(int n, byte[] byArray) throws IOException {
        this.compressEncryptSend(n, byArray, 0, byArray.length);
    }

    void compressEncryptSend(int n, byte[] byArray, int n2, int n3) throws IOException {
        try {
            ProtocolVersion protocolVersion;
            if (this.connection.returnDebugFlag()) {
                System.out.print("Write ");
                Util.PrintDebugMessage(byArray, 2, n, n3);
                System.out.println("End Write\n");
            }
            if (n == 0) {
                if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_INFO)) {
                    WeblogicHandler.debug(WeblogicHandler.DEBUG_INFO, "write SSL_20_RECORD", null);
                }
                this.compressEncryptSendVersion2(byArray, n2, n3);
                return;
            }
            if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_INFO)) {
                WeblogicHandler.debug(WeblogicHandler.DEBUG_INFO, "write " + (n == 23 ? "APPLICATION_DATA" : (n == 22 ? "HANDSHAKE" : (n == 21 ? "ALERT" : (n == 20 ? "CHANGE_CIPHER_SPEC" : "UNKNOWN")))) + ", offset = " + n2 + ", length = " + n3, null);
            }
            if ((protocolVersion = this.connection.getProtocolVersion()).equals(ProtocolVersion.SSL20) && n == 23 && this.connection.isHandshakeComplete()) {
                this.compressEncryptSendVersion2(byArray, n2, n3);
                return;
            }
            Mac mac = this.cryptoRecordState.getMac();
            Cipher cipher = this.cryptoRecordState.getCipher();
            mac.reset();
            mac.update(this.cryptoRecordState.getSequenceNumber());
            mac.update(Util.toUInt8(n));
            if (protocolVersion.equals(TLS10)) {
                mac.update(Util.toUInt8(protocolVersion.getMajor()));
                mac.update(Util.toUInt8(protocolVersion.getMinor()));
            }
            mac.update(Util.toUInt16(n3));
            if (n3 > 0) {
                mac.update(byArray, n2, n3);
            }
            byte[] byArray2 = mac.doFinal();
            int n4 = cipher.getBlockSize();
            int n5 = mac.getMacLength();
            int n6 = n3 + n5 + n4;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n6);
            if (n3 > 0) {
                byteArrayOutputStream.write(cipher.update(byArray, n2, n3));
            }
            byteArrayOutputStream.write(cipher.update(byArray2));
            if (n4 > 1) {
                int n7 = n4 - (n3 + n5) % n4 - 1;
                byte[] byArray3 = new byte[n7 + 1];
                for (int i = 0; i <= n7; ++i) {
                    byArray3[i] = (byte)n7;
                }
                byteArrayOutputStream.write(cipher.update(byArray3));
            }
            Util.writeUInt8(n, this.buffer);
            Util.writeUInt8(protocolVersion.getRecordMajor(), this.buffer);
            Util.writeUInt8(protocolVersion.getRecordMinor(), this.buffer);
            Util.writeUInt16(byteArrayOutputStream.size(), this.buffer);
            byteArrayOutputStream.writeTo(this.buffer);
            this.cryptoRecordState.incrementSequenceNumber();
        }
        catch (IOException iOException) {
            ProtocolVersion protocolVersion = this.connection.getProtocolVersion();
            if (!this.connection.getProtocolVersion().equals(ProtocolVersion.SSL20)) {
                if (!this.connection.isCloseNotifyReceived()) {
                    this.connection.getSessionImpl().invalidate();
                }
            } else if (!this.connection.isHandshakeComplete()) {
                this.connection.getSessionImpl().invalidate();
            }
            throw iOException;
        }
    }

    void compressEncryptSendVersion2(byte[] byArray, int n, int n2) throws IOException {
        Mac mac = this.cryptoRecordState.getMac();
        Cipher cipher = this.cryptoRecordState.getCipher();
        int n3 = 0;
        mac.reset();
        if (n2 > 0) {
            mac.update(byArray, n, n2);
        }
        mac.update(this.cryptoRecordState.getSSL2SequenceNumber());
        byte[] byArray2 = mac.doFinal();
        n3 = byArray2.length + n2;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(byArray2.length + n2);
        byteArrayOutputStream.write(cipher.update(byArray2, 0, byArray2.length));
        if (n2 > 0) {
            byteArrayOutputStream.write(cipher.update(byArray, n, n2));
        }
        if (byteArrayOutputStream.size() > 16383) {
            this.connection.getHandshakeHandler().fireSSL2ErrorException(Resources.getMessage("244") + Resources.getMessage("246"));
        }
        int n4 = n3 | 0x8000;
        this.buffer.write(Util.toUInt16(n4));
        byteArrayOutputStream.writeTo(this.buffer);
        this.cryptoRecordState.incrementSequenceNumber();
    }

    public void setWriteFragmentLength(int n) {
        this.WRITE_BLOCK_SIZE = n;
    }

    public int getWriteFragmentLength() {
        return this.WRITE_BLOCK_SIZE;
    }
}

