/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.tls.record;

import com.bea.sslplus.WeblogicHandler;
import com.certicom.tls.event.HandshakeWouldBlockException;
import com.certicom.tls.interfaceimpl.AlertEvent;
import com.certicom.tls.interfaceimpl.ProtocolVersion;
import com.certicom.tls.interfaceimpl.ProtocolVersions;
import com.certicom.tls.interfaceimpl.TLSConnectionImpl;
import com.certicom.tls.provider.Cipher;
import com.certicom.tls.provider.Mac;
import com.certicom.tls.record.CryptoRecordState;
import com.certicom.tls.record.Util;
import com.certicom.tls.record.alert.Alert;
import com.certicom.tls.record.handshake.HandshakeHandler;
import java.io.ByteArrayInputStream;
import java.io.IOException;

public class MessageInterpreter
implements ProtocolVersions {
    private boolean closed = false;
    private CryptoRecordState cryptoRecordState;
    private byte[] dataBuffer;
    private int dataBufferLen;
    private TLSConnectionImpl connection;

    public MessageInterpreter(TLSConnectionImpl tLSConnectionImpl) {
        this.connection = tLSConnectionImpl;
        this.cryptoRecordState = new CryptoRecordState();
        this.dataBuffer = new byte[0];
        this.dataBufferLen = 0;
    }

    public void setCryptoRecordState(CryptoRecordState cryptoRecordState) {
        this.cryptoRecordState = cryptoRecordState;
    }

    public CryptoRecordState getCryptoRecordState() {
        return this.cryptoRecordState;
    }

    public byte[] getDataBuffer() {
        return this.dataBuffer;
    }

    public int getDataBufferLen() {
        return this.dataBufferLen;
    }

    public void setDataBuffer(byte[] byArray) {
        this.dataBuffer = byArray;
    }

    public void setDataBufferLen(int n) {
        this.dataBufferLen = n;
    }

    public void decryptMessage(int n, int n2, byte[] byArray, int n3, int n4, ProtocolVersion protocolVersion) throws IOException, HandshakeWouldBlockException {
        int n5;
        int n6 = 0;
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        byte[] byArray4 = null;
        byte[] byArray5 = null;
        Cipher cipher = this.cryptoRecordState.getCipher();
        Mac mac = this.cryptoRecordState.getMac();
        HandshakeHandler handshakeHandler = this.connection.getHandshakeHandler();
        ProtocolVersion protocolVersion2 = this.connection.getProtocolVersion();
        byArray2 = cipher.update(byArray);
        n6 = mac.getMacLength();
        n2 = byArray2.length - n6;
        if (cipher.getBlockSize() > 1) {
            n5 = 0;
            byte by = byArray2[byArray2.length - 1];
            if (byArray2.length < by + 1 || n2 < 0 || by < 0) {
                n5 = 1;
            } else {
                for (int i = byArray2.length - (by + 1); i < byArray2.length; ++i) {
                    if (n5 != 0 || byArray2[i] == by) continue;
                    n5 = 1;
                }
            }
            n2 = n5 == 0 ? (n2 -= byArray2[byArray2.length - 1] + 1) : 0;
        }
        if (protocolVersion2.getMajor() == 3) {
            if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_INFO)) {
                WeblogicHandler.debug(WeblogicHandler.DEBUG_INFO, this.hashCode() + " SSL3/TLS MAC", null);
            }
            mac.update(this.cryptoRecordState.getSequenceNumber());
            mac.update(Util.toUInt8(n));
            if (protocolVersion2.equals(TLS10)) {
                mac.update(Util.toUInt8(n3));
                mac.update(Util.toUInt8(n4));
            }
            mac.update(Util.toUInt16(n2));
            mac.update(byArray2, 0, n2);
            byArray3 = mac.doFinal();
            for (n5 = 0; n5 < n6; ++n5) {
                if (byArray2[n5 + n2] == byArray3[n5]) continue;
                Alert alert = new Alert(2, 20);
                this.fireAlert(alert);
            }
        } else {
            if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_INFO)) {
                WeblogicHandler.debug(WeblogicHandler.DEBUG_INFO, this.hashCode() + " SSL Version 2 MAC", null);
            }
            byArray5 = new byte[n2];
            byArray4 = new byte[n6];
            System.arraycopy(byArray2, 0, byArray4, 0, n6);
            System.arraycopy(byArray2, n6, byArray5, 0, n2);
            mac.update(byArray5);
            mac.update(this.cryptoRecordState.getSSL2SequenceNumber());
            byArray2 = byArray5;
            byArray3 = mac.doFinal();
            for (n5 = 0; n5 < n6; ++n5) {
                if (byArray4[n5] == byArray3[n5]) continue;
                handshakeHandler.fireSSL2ErrorException("Mac verify failed");
            }
        }
        this.cryptoRecordState.incrementSequenceNumber();
        this.interpretContent(byArray2, n2, n, protocolVersion);
    }

    private void interpretContent(byte[] byArray, int n, int n2, ProtocolVersion protocolVersion) throws IOException, HandshakeWouldBlockException {
        HandshakeHandler handshakeHandler = this.connection.getHandshakeHandler();
        if (this.connection.returnDebugFlag()) {
            System.out.print("\nAttempting to read ");
            Util.PrintDebugMessage(byArray, 2, n2, byArray.length);
            if (n2 == 22 || n2 == 0) {
                System.out.print("Message was: ");
            } else {
                System.out.println("End read");
            }
        }
        switch (n2) {
            case 0: {
                if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_INFO)) {
                    WeblogicHandler.debug(WeblogicHandler.DEBUG_INFO, this.hashCode() + " received SSL_20_RECORD", null);
                }
                if (!this.connection.isHandshakeComplete()) {
                    handshakeHandler.handleVersion2HandshakeMessages(byArray);
                    break;
                }
                byte[] byArray2 = new byte[n + this.dataBufferLen];
                System.arraycopy(this.dataBuffer, 0, byArray2, 0, this.dataBufferLen);
                System.arraycopy(byArray, 0, byArray2, this.dataBufferLen, n);
                this.dataBuffer = byArray2;
                this.dataBufferLen = n + this.dataBufferLen;
                break;
            }
            case 20: {
                if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_INFO)) {
                    WeblogicHandler.debug(WeblogicHandler.DEBUG_INFO, this.hashCode() + " received CHANGE_CIPHER_SPEC", null);
                }
                handshakeHandler.handleChangeCipherSpec();
                break;
            }
            case 21: {
                if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_INFO)) {
                    WeblogicHandler.debug(WeblogicHandler.DEBUG_INFO, this.hashCode() + " received ALERT", null);
                }
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, 0, n);
                this.connection.getAlertHandler().handleAlertMessages(byteArrayInputStream);
                break;
            }
            case 23: {
                Object object;
                if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_INFO)) {
                    WeblogicHandler.debug(WeblogicHandler.DEBUG_INFO, this.hashCode() + " received APPLICATION_DATA: databufferLen " + this.dataBufferLen + ", contentLength " + n, null);
                }
                if (!this.connection.isHandshakeComplete()) {
                    object = new Alert(2, 47);
                    this.fireAlert((Alert)object);
                }
                object = new byte[n + this.dataBufferLen];
                System.arraycopy(this.dataBuffer, 0, object, 0, this.dataBufferLen);
                System.arraycopy(byArray, 0, object, this.dataBufferLen, n);
                this.dataBuffer = (byte[])object;
                this.dataBufferLen = n + this.dataBufferLen;
                break;
            }
            case 22: {
                if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_INFO)) {
                    WeblogicHandler.debug(WeblogicHandler.DEBUG_INFO, this.hashCode() + " received HANDSHAKE", null);
                }
                handshakeHandler.handleHandshakeMessages(byArray, n, protocolVersion);
                break;
            }
            default: {
                if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_INFO)) {
                    WeblogicHandler.debug(WeblogicHandler.DEBUG_INFO, this.hashCode() + " received DECODE_ERROR", null);
                }
                Alert alert = new Alert(2, 50);
                this.fireAlert(alert);
            }
        }
    }

    private void fireAlert(Alert alert) throws IOException, HandshakeWouldBlockException {
        AlertEvent alertEvent = this.connection.fireAlertSent(alert);
        if (!alertEvent.isIgnored()) {
            this.connection.close();
        }
    }
}

