/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.tls.record;

import com.bea.sslplus.WeblogicHandler;
import com.certicom.io.InputSSLIO;
import com.certicom.locale.Resources;
import com.certicom.tls.event.HandshakeWouldBlockException;
import com.certicom.tls.interfaceimpl.AlertEvent;
import com.certicom.tls.interfaceimpl.ProtocolVersion;
import com.certicom.tls.interfaceimpl.TLSConnectionImpl;
import com.certicom.tls.record.MessageInterpreter;
import com.certicom.tls.record.Util;
import com.certicom.tls.record.alert.Alert;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import weblogic.security.utils.SSLSetup;

public final class ReadHandler
implements InputSSLIO {
    private TLSConnectionImpl connection;
    private InputSSLIO inSSLIO;
    private MessageInterpreter messageInterpreter;
    private boolean closed = false;
    private byte[] dataBuffer = new byte[0];
    private int dataBufferLen = 0;
    private byte[] fragmentBuffer = new byte[0];
    private boolean isRecordComplete = false;

    public ReadHandler(TLSConnectionImpl tLSConnectionImpl, InputSSLIO inputSSLIO) {
        this.connection = tLSConnectionImpl;
        this.inSSLIO = inputSSLIO;
        this.messageInterpreter = new MessageInterpreter(tLSConnectionImpl);
    }

    public MessageInterpreter getMessageInterpreter() {
        return this.messageInterpreter;
    }

    public int available() throws IOException {
        if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_INFO)) {
            WeblogicHandler.debug(WeblogicHandler.DEBUG_INFO, "avalable(): " + this.hashCode() + " : " + this.dataBufferLen + " + " + this.inSSLIO.available() + " = " + (this.dataBufferLen + this.inSSLIO.available()), null);
        }
        return this.dataBufferLen + this.inSSLIO.available();
    }

    public void close() {
        if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_INFO)) {
            WeblogicHandler.debug(WeblogicHandler.DEBUG_INFO, "close(): " + this.hashCode(), null);
        }
        this.closed = true;
    }

    public boolean isOpen() {
        return !this.closed;
    }

    public int read() throws IOException {
        byte[] byArray = new byte[1];
        if (this.read(byArray) != -1) {
            return byArray[0] & 0xFF;
        }
        return -1;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
        if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_INFO)) {
            WeblogicHandler.debug(WeblogicHandler.DEBUG_INFO, this.hashCode() + " read(offset=" + n + ", length=" + n2 + ")", null);
        }
        int n3 = 0;
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return 0;
        }
        if (!this.closed) {
            try {
                while (this.dataBufferLen == 0) {
                    if (!this.connection.isHandshakeComplete()) {
                        this.connection.completeHandshake();
                    }
                    if (this.connection.isHandshakeComplete()) {
                        n3 = this.readRecord();
                        if (n3 != -1 && !this.closed) continue;
                        if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_INFO)) {
                            WeblogicHandler.debug(WeblogicHandler.DEBUG_INFO, this.hashCode() + (this.closed ? " closed by last read," : "") + " readRecord returned " + n3, null);
                        }
                        return -1;
                    }
                    return 0;
                }
            }
            catch (InterruptedIOException interruptedIOException) {
                if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_INFO)) {
                    WeblogicHandler.debug(WeblogicHandler.DEBUG_INFO, this.hashCode() + " Rethrowing InterruptedIOException", null);
                }
                throw interruptedIOException;
            }
            catch (IOException iOException) {
                ProtocolVersion protocolVersion = this.connection.getProtocolVersion();
                if (!this.connection.getProtocolVersion().equals(ProtocolVersion.SSL20)) {
                    if (!this.connection.isCloseNotifyReceived()) {
                        this.connection.getSessionImpl().invalidate();
                    }
                } else if (!this.connection.isHandshakeComplete()) {
                    this.connection.getSessionImpl().invalidate();
                }
                if (this.connection.notCompleteSSLRecord()) {
                    if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_INFO)) {
                        WeblogicHandler.debug(WeblogicHandler.DEBUG_INFO, this.hashCode() + " Muxer is activated, no SSL record available, so close now", null);
                    }
                    this.connection.setWaitForCloseNotify(false);
                    this.connection.close();
                }
                throw iOException;
            }
            catch (HandshakeWouldBlockException handshakeWouldBlockException) {
                return 0;
            }
            if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_INFO)) {
                WeblogicHandler.debug(WeblogicHandler.DEBUG_INFO, this.hashCode() + " read databufferLen " + this.dataBufferLen, null);
            }
            if (n2 > this.dataBufferLen) {
                n2 = this.dataBufferLen;
                System.arraycopy(this.dataBuffer, 0, byArray, n, n2);
                this.dataBufferLen = 0;
                if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_INFO)) {
                    WeblogicHandler.debug(WeblogicHandler.DEBUG_INFO, this.hashCode() + " read A returns " + n2, null);
                }
                return n2;
            }
            System.arraycopy(this.dataBuffer, 0, byArray, n, n2);
            System.arraycopy(this.dataBuffer, n2, this.dataBuffer, 0, this.dataBufferLen - n2);
            this.dataBufferLen -= n2;
            if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_INFO)) {
                WeblogicHandler.debug(WeblogicHandler.DEBUG_INFO, this.hashCode() + " read B returns " + n2, null);
            }
            return n2;
        }
        if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_INFO)) {
            WeblogicHandler.debug(WeblogicHandler.DEBUG_INFO, this.hashCode() + " read returns -1", null);
        }
        return -1;
    }

    public void readUntilHandshakeComplete() throws IOException, HandshakeWouldBlockException {
        while (!this.connection.isHandshakeComplete()) {
            String string;
            if (this.readRecord() != -1) continue;
            this.close();
            ProtocolVersion protocolVersion = this.connection.getProtocolVersion();
            if (!this.connection.getProtocolVersion().equals(ProtocolVersion.SSL20)) {
                if (!this.connection.isCloseNotifyReceived()) {
                    this.connection.getSessionImpl().invalidate();
                }
            } else if (!this.connection.isHandshakeComplete()) {
                this.connection.getSessionImpl().invalidate();
            }
            if ((string = this.connection.getFailureDetails()) != null) {
                throw new IOException(string);
            }
            throw new IOException(Resources.getMessage("236"));
        }
    }

    private int readRecord() throws IOException, HandshakeWouldBlockException {
        if (this.connection.notCompleteSSLRecord()) {
            throw new InterruptedIOException();
        }
        while (!this.isRecordComplete) {
            int n = this.readFragment(this.getBytesPending());
            if (n == -1 && this.available() > 0) {
                if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_INFO)) {
                    WeblogicHandler.debug(WeblogicHandler.DEBUG_INFO, this.hashCode() + "No bytes were read, but bytes are still available", null);
                }
                throw new IOException("Read did not get bytes, but bytes are available");
            }
            if (n == -1) {
                this.connection.close();
                if (this.connection.isHandshakeComplete()) {
                    return -1;
                }
                throw new IOException("Read channel closed");
            }
            if (this.connection.getVersionCheck() || n < 3) continue;
            this.checkVersion();
            this.connection.setVersionCheck(true);
        }
        if (!this.isRecordComplete) {
            throw new IOException("Internal Error");
        }
        return this.processRecord();
    }

    private int readFragment(int n) throws IOException, HandshakeWouldBlockException {
        if (n > 0) {
            int n2;
            byte[] byArray = new byte[n];
            InputStream inputStream = this.connection.getMuxerInputStream();
            int n3 = n2 = inputStream != null ? inputStream.read(byArray) : this.inSSLIO.read(byArray);
            if (n2 == -1) {
                return -1;
            }
            if (n2 == 0) {
                throw new HandshakeWouldBlockException(Resources.getMessage("283"));
            }
            byte[] byArray2 = this.fragmentBuffer;
            this.fragmentBuffer = new byte[this.fragmentBuffer.length + n2];
            System.arraycopy(byArray2, 0, this.fragmentBuffer, 0, byArray2.length);
            System.arraycopy(byArray, 0, this.fragmentBuffer, byArray2.length, n2);
            return this.fragmentBuffer.length;
        }
        return n;
    }

    private int getBytesPending() throws IOException {
        int n = this.fragmentBuffer.length;
        int n2 = 0;
        if (n == 0) {
            return 1;
        }
        if ((this.fragmentBuffer[0] & 0x80) == 128) {
            if (n < 2) {
                return 2 - n;
            }
            int n3 = Util.readUInt8(this.fragmentBuffer, 0);
            int n4 = Util.readUInt8(this.fragmentBuffer, 1);
            n2 = (n3 & 0x7F) << 8 | n4 + 2;
        } else {
            if (n < 5) {
                return 5 - n;
            }
            n2 = Util.readUInt16(this.fragmentBuffer, 3) + 5;
        }
        if (n2 < n) {
            throw new IOException("Internal Error");
        }
        if (n2 == n) {
            this.isRecordComplete = true;
        }
        return n2 - n;
    }

    private int processRecord() throws IOException, HandshakeWouldBlockException {
        int n = 0;
        byte[] byArray = null;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        ProtocolVersion protocolVersion = null;
        ProtocolVersion protocolVersion2 = this.connection.getProtocolVersion();
        int n7 = Util.readUInt8(this.fragmentBuffer, n);
        ++n;
        if ((n7 & 0x80) == 128) {
            if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_INFO)) {
                WeblogicHandler.debug(WeblogicHandler.DEBUG_INFO, this.hashCode() + " SSL Version 2 with no padding", null);
            }
            int n8 = Util.readUInt8(this.fragmentBuffer, n);
            n2 = (n7 & 0x7F) << 8 | n8;
            byArray = new byte[n2];
            n6 = Util.readFully(byArray, this.fragmentBuffer, ++n, n2);
            n += n6;
        } else {
            n5 = n7;
            n3 = Util.readUInt8(this.fragmentBuffer, n);
            n4 = Util.readUInt8(this.fragmentBuffer, ++n);
            n2 = Util.readUInt16(this.fragmentBuffer, ++n);
            byArray = new byte[n2];
            n6 = Util.readFully(byArray, this.fragmentBuffer, n += 2, n2);
            n += n6;
            protocolVersion = this.getProtocolVersion(n7, n3, n4);
            if (n5 == 23 && !protocolVersion.equals(protocolVersion2)) {
                Alert alert = new Alert(2, 70);
                this.fireAlert(alert);
            }
        }
        this.messageInterpreter.setDataBuffer(this.dataBuffer);
        this.messageInterpreter.setDataBufferLen(this.dataBufferLen);
        this.messageInterpreter.decryptMessage(n5, n2, byArray, n3, n4, protocolVersion);
        this.dataBuffer = this.messageInterpreter.getDataBuffer();
        this.dataBufferLen = this.messageInterpreter.getDataBufferLen();
        this.fragmentBuffer = new byte[0];
        this.isRecordComplete = false;
        return this.dataBufferLen;
    }

    private void checkVersion() throws IOException, HandshakeWouldBlockException {
        int n = Util.readUInt8(this.fragmentBuffer, 0);
        if ((n & 0x80) != 128) {
            int n2 = Util.readUInt8(this.fragmentBuffer, 1);
            int n3 = Util.readUInt8(this.fragmentBuffer, 2);
            this.getProtocolVersion(n, n2, n3);
        }
    }

    private ProtocolVersion getProtocolVersion(int n, int n2, int n3) throws IOException, HandshakeWouldBlockException {
        try {
            return new ProtocolVersion(n2, n3);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            String string;
            if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_ERROR)) {
                WeblogicHandler.debug(WeblogicHandler.DEBUG_ERROR, this.hashCode() + " SSL Version data invalid", null);
            }
            if ((string = WeblogicHandler.matchPlainText(n, n2, n3)) != null) {
                SSLSetup.logPlaintextProtocolClientError(this.connection.getSSLSocket(), string);
                this.connection.drop();
                if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_ERROR)) {
                    WeblogicHandler.debug(WeblogicHandler.DEBUG_ERROR, this.hashCode() + " Throwing InterruptedIOException to handle drop", null);
                }
                throw new InterruptedIOException();
            }
            SSLSetup.logProtocolVersionError(this.connection.getSSLSocket());
            Alert alert = new Alert(2, 70);
            this.fireAlert(alert);
            return null;
        }
    }

    private void fireAlert(Alert alert) throws IOException, HandshakeWouldBlockException {
        AlertEvent alertEvent = this.connection.fireAlertSent(alert);
        if (!alertEvent.isIgnored()) {
            this.connection.close();
        }
    }

    public InputSSLIO getRawInput() {
        return this.inSSLIO;
    }
}

