/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.tls.record;

import com.certicom.tls.TLSUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;

public final class Util {
    public static byte[] toUnsignedInteger(BigInteger bigInteger) {
        byte[] byArray = bigInteger.toByteArray();
        if (byArray[0] == 0) {
            byte[] byArray2 = new byte[byArray.length - 1];
            System.arraycopy(byArray, 1, byArray2, 0, byArray2.length);
            byArray = byArray2;
        }
        return byArray;
    }

    public static byte[] toUInt8(int n) {
        return new byte[]{(byte)n};
    }

    public static byte[] toUInt16(int n) {
        return new byte[]{(byte)(n >> 8), (byte)n};
    }

    public static byte[] toUInt24(int n) {
        return new byte[]{(byte)(n >> 16), (byte)(n >> 8), (byte)n};
    }

    public static byte[] toUInt32(int n) {
        return new byte[]{(byte)(n >> 24), (byte)(n >> 16), (byte)(n >> 8), (byte)n};
    }

    public static byte[] toUInt64(long l) {
        return new byte[]{(byte)(l >> 56), (byte)(l >> 48), (byte)(l >> 40), (byte)(l >> 32), (byte)(l >> 24), (byte)(l >> 16), (byte)(l >> 8), (byte)l};
    }

    public static int toUInt32(byte[] byArray) {
        int n = 0;
        n |= byArray[0] << 24;
        n |= byArray[1] << 16;
        n |= byArray[2] << 8;
        return n |= byArray[3] << 0;
    }

    public static void writeUInt8(int n, OutputStream outputStream) throws IOException {
        outputStream.write(Util.toUInt8(n));
    }

    public static void writeUInt16(int n, OutputStream outputStream) throws IOException {
        outputStream.write(Util.toUInt16(n));
    }

    public static void writeUInt24(int n, OutputStream outputStream) throws IOException {
        outputStream.write(Util.toUInt24(n));
    }

    public static void writeUInt32(int n, OutputStream outputStream) throws IOException {
        outputStream.write(Util.toUInt32(n));
    }

    public static void writeUInt64(int n, OutputStream outputStream) throws IOException {
        outputStream.write(Util.toUInt64(n));
    }

    public static void writeBytesLength8(byte[] byArray, OutputStream outputStream) throws IOException {
        if (byArray == null) {
            Util.writeUInt8(0, outputStream);
            return;
        }
        Util.writeUInt8(byArray.length, outputStream);
        outputStream.write(byArray, 0, byArray.length);
    }

    public static void writeBytesLength16(byte[] byArray, OutputStream outputStream) throws IOException {
        if (byArray == null) {
            Util.writeUInt16(0, outputStream);
            return;
        }
        Util.writeUInt16(byArray.length, outputStream);
        outputStream.write(byArray, 0, byArray.length);
    }

    public static void writeBytesLength24(byte[] byArray, OutputStream outputStream) throws IOException {
        if (byArray == null) {
            Util.writeUInt24(0, outputStream);
            return;
        }
        Util.writeUInt24(byArray.length, outputStream);
        outputStream.write(byArray, 0, byArray.length);
    }

    public static int readUInt8(InputStream inputStream) throws IOException {
        int n = 0;
        n = inputStream.read();
        return n;
    }

    public static int readUInt16(InputStream inputStream) throws IOException {
        int n = Util.readUInt8(inputStream);
        int n2 = Util.readUInt8(inputStream);
        return (n << 8) + n2;
    }

    public static int readUInt24(InputStream inputStream) throws IOException {
        int n = Util.readUInt16(inputStream);
        int n2 = Util.readUInt8(inputStream);
        return (n << 8) + n2;
    }

    public static int readUInt32(InputStream inputStream) throws IOException {
        int n = Util.readUInt16(inputStream);
        int n2 = Util.readUInt16(inputStream);
        return (n << 16) + n2;
    }

    public static long readUInt64(InputStream inputStream) throws IOException {
        long l = Util.readUInt32(inputStream);
        long l2 = Util.readUInt32(inputStream);
        return (l << 32) + l2;
    }

    public static byte[] readBytes(InputStream inputStream, int n) throws IOException {
        byte[] byArray = new byte[n];
        Util.readFully(byArray, inputStream);
        return byArray;
    }

    public static byte[] readBytesLength8(InputStream inputStream) throws IOException {
        int n = Util.readUInt8(inputStream);
        byte[] byArray = new byte[n];
        Util.readFully(byArray, inputStream);
        return byArray;
    }

    public static byte[] readBytesLength16(InputStream inputStream, int n) throws IOException {
        int n2 = Util.readUInt16(inputStream);
        if (n2 > n && n != 0) {
            return null;
        }
        byte[] byArray = new byte[n2];
        Util.readFully(byArray, inputStream);
        return byArray;
    }

    public static final byte[] readBytesLength24(InputStream inputStream, int n) throws IOException {
        int n2 = Util.readUInt24(inputStream);
        if (n2 > n && n != 0) {
            return null;
        }
        byte[] byArray = new byte[n2];
        Util.readFully(byArray, inputStream);
        return byArray;
    }

    public static void readFully(byte[] byArray, int n, InputStream inputStream) throws IOException {
        int n2 = 0;
        for (int i = 0; i < n; i += n2) {
            n2 = inputStream.read(byArray, i, byArray.length - i);
            if (n2 != -1) continue;
            throw new IOException("Not enough data");
        }
    }

    public static void readFully(byte[] byArray, InputStream inputStream) throws IOException {
        Util.readFully(byArray, byArray.length, inputStream);
    }

    public static int readUInt8(byte[] byArray, int n) {
        byte by = 0;
        by = byArray[n];
        return by & 0xFF;
    }

    public static int readUInt16(byte[] byArray, int n) {
        int n2 = Util.readUInt8(byArray, n);
        int n3 = Util.readUInt8(byArray, n + 1);
        return (n2 << 8) + n3;
    }

    public static int readUInt24(byte[] byArray, int n) {
        int n2 = Util.readUInt16(byArray, n);
        int n3 = Util.readUInt8(byArray, n + 2);
        return (n2 << 8) + n3;
    }

    public static int readUInt32(byte[] byArray, int n) {
        int n2 = Util.readUInt16(byArray, n);
        int n3 = Util.readUInt16(byArray, n + 2);
        return (n2 << 16) + n3;
    }

    public static long readUInt64(byte[] byArray, int n) {
        long l = Util.readUInt32(byArray, n);
        long l2 = Util.readUInt32(byArray, n + 4);
        return (l << 32) + l2;
    }

    public static int readFully(byte[] byArray, byte[] byArray2, int n, int n2) {
        int n3 = 0;
        n3 = n3 > n2 && n2 > 0 ? n2 : byArray2.length - n;
        System.arraycopy(byArray2, n, byArray, 0, n3);
        return n3;
    }

    public static void PrintDebugMessage(byte[] byArray, int n, int n2, int n3) {
        String string = TLSUtils.dumpHex(byArray, n, n3);
        if (n2 == 0) {
            System.out.println("SSL_20_RECORD");
        } else if (n2 == 20) {
            System.out.println("CHANGE CIPHER SPECIFICATION");
        } else if (n2 == 23) {
            System.out.println("APPLICATION_DATA");
        } else if (n2 == 22) {
            System.out.println("HANDSHAKE MESSAGE");
        } else if (n2 == 21) {
            System.out.println("ALERT");
        } else {
            System.out.print("Unknown Message - will fire alert!");
        }
        Util.PrintFormat(string, 16);
    }

    public static void PrintFormat(String string, int n) {
        String string2 = new String();
        char[] cArray = string.toCharArray();
        int n2 = 0;
        int n3 = 0;
        System.out.println("-----------------------------------");
        while (n2 < cArray.length) {
            if (cArray[n2] != ' ') {
                System.out.print(cArray[n2++]);
                System.out.print(cArray[n2++]);
                ++n3;
                continue;
            }
            if (n3 % n == 0) {
                ++n2;
                System.out.println();
                continue;
            }
            System.out.print(cArray[n2]);
            ++n2;
        }
        System.out.println("\n-----------------------------------");
    }
}

