/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.tls.record;

import com.bea.sslplus.WeblogicHandler;
import com.certicom.io.OutputSSLIO;
import com.certicom.locale.Resources;
import com.certicom.tls.event.HandshakeWouldBlockException;
import com.certicom.tls.interfaceimpl.ProtocolVersion;
import com.certicom.tls.interfaceimpl.TLSConnectionImpl;
import com.certicom.tls.record.Message;
import com.certicom.tls.record.MessageEncryptor;
import com.certicom.tls.record.MessageFragmentor;
import com.certicom.tls.record.alert.Alert;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public final class WriteHandler
implements OutputSSLIO {
    private OutputSSLIO outSSLIO;
    private TLSConnectionImpl connection;
    private MessageEncryptor messageEncryptor;
    private MessageFragmentor messageFragmentor;
    private ByteArrayOutputStream buffer = null;
    private boolean closed = false;
    private Thread writer = null;

    private synchronized boolean waitForWriteLock() {
        Thread thread2 = Thread.currentThread();
        if (this.writer == thread2) {
            return false;
        }
        while (this.writer != null) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.writer = thread2;
        return true;
    }

    private synchronized void releaseWriteLock() {
        this.writer = null;
        this.notifyAll();
    }

    public WriteHandler(TLSConnectionImpl tLSConnectionImpl, OutputSSLIO outputSSLIO) {
        this.connection = tLSConnectionImpl;
        this.outSSLIO = outputSSLIO;
        this.buffer = new ByteArrayOutputStream(1460);
        this.messageEncryptor = new MessageEncryptor(tLSConnectionImpl);
        this.messageFragmentor = new MessageFragmentor(this, this.messageEncryptor);
    }

    public MessageEncryptor getMessageEncryptor() {
        return this.messageEncryptor;
    }

    public boolean isOpen() {
        return !this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        block11: {
            try {
                if (this.closed) break block11;
                WriteHandler writeHandler = this;
                synchronized (writeHandler) {
                    if (!this.closed) {
                        if (this.writer != null) {
                            try {
                                this.wait(50L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                        if (this.writer == null) {
                            this.flushOutput();
                        }
                        this.buffer.close();
                        this.closed = true;
                    }
                }
            }
            catch (IOException iOException) {
                WeblogicHandler.debugEaten(iOException);
            }
            catch (HandshakeWouldBlockException handshakeWouldBlockException) {
                WeblogicHandler.debugEaten(handshakeWouldBlockException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int flushOutput() throws IOException, HandshakeWouldBlockException {
        block13: {
            int n = 0;
            try {
                if (this.closed) break block13;
                if (this.buffer.size() > 0) {
                    boolean bl = this.waitForWriteLock();
                    try {
                        byte[] byArray = this.buffer.toByteArray();
                        n = this.outSSLIO.write(byArray, 0, byArray.length);
                        this.buffer.reset();
                        this.messageEncryptor.resetCryptoBuffer();
                    }
                    finally {
                        if (bl) {
                            this.releaseWriteLock();
                        }
                    }
                    if (n == 0 && !this.connection.isHandshakeComplete()) {
                        throw new HandshakeWouldBlockException(Resources.getMessage("283"));
                    }
                }
                return n;
            }
            catch (IOException iOException) {
                ProtocolVersion protocolVersion = this.connection.getProtocolVersion();
                if (!this.connection.getProtocolVersion().equals(ProtocolVersion.SSL20)) {
                    if (!this.connection.isCloseNotifyReceived()) {
                        this.connection.getSessionImpl().invalidate();
                    }
                } else if (!this.connection.isHandshakeComplete()) {
                    this.connection.getSessionImpl().invalidate();
                }
                throw iOException;
            }
            catch (HandshakeWouldBlockException handshakeWouldBlockException) {
                throw handshakeWouldBlockException;
            }
        }
        return -1;
    }

    public void flush() throws IOException {
        this.outSSLIO.flush();
    }

    public void write(int n) throws IOException {
        this.write(new byte[]{(byte)n});
    }

    public int write(byte[] byArray) throws IOException {
        return this.write(byArray, 0, byArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int write(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        block12: {
            n3 = 0;
            if (this.closed) {
                String string = this.connection.getFailureDetails();
                if (string != null) {
                    throw new IOException(string);
                }
                throw new IOException(Resources.getMessage("148"));
            }
            try {
                if (!this.connection.isHandshakeComplete()) {
                    this.connection.completeHandshake();
                }
                if (this.connection.isHandshakeComplete()) {
                    boolean bl = this.waitForWriteLock();
                    try {
                        this.messageFragmentor.write(byArray, n, n2);
                        this.buffer = this.messageEncryptor.getCryptoBuffer();
                        n3 = this.flushOutput();
                    }
                    finally {
                        if (bl) {
                            this.releaseWriteLock();
                        }
                    }
                    if (n3 == -1) {
                        throw new IOException(Resources.getMessage("148"));
                    }
                    break block12;
                }
                return 0;
            }
            catch (HandshakeWouldBlockException handshakeWouldBlockException) {
                return 0;
            }
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(Message message) throws IOException {
        if (this.closed) {
            String string = this.connection.getFailureDetails();
            if (string != null) {
                throw new IOException(string);
            }
            throw new IOException(Resources.getMessage("148"));
        }
        boolean bl = this.waitForWriteLock();
        try {
            this.messageFragmentor.write(message);
            this.buffer = this.messageEncryptor.getCryptoBuffer();
        }
        finally {
            if (bl) {
                this.releaseWriteLock();
            }
        }
    }

    public void fireAlert(Alert alert) throws IOException, HandshakeWouldBlockException {
        this.connection.fireAlertSent(alert);
    }

    public boolean hasPendingBytes() {
        return false;
    }

    public TLSConnectionImpl getConnection() {
        return this.connection;
    }
}

