/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.tls.record.alert;

import com.bea.sslplus.WeblogicHandler;
import com.certicom.tls.event.HandshakeWouldBlockException;
import com.certicom.tls.interfaceimpl.CertificateSupport;
import com.certicom.tls.interfaceimpl.TLSConnectionImpl;
import com.certicom.tls.record.alert.Alert;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.Socket;
import java.security.cert.X509Certificate;
import weblogic.security.utils.SSLSetup;

public final class AlertHandler {
    private int alertFragment = -1;
    private TLSConnectionImpl connection;
    private static final String osName = AlertHandler.initOSNameProp();
    private static final boolean isLinux = "linux".equals(osName);

    private static String initOSNameProp() {
        String string = "UNKNOWN";
        try {
            string = System.getProperty("os.name", "UNKNOWN").toLowerCase();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return string;
    }

    public AlertHandler(TLSConnectionImpl tLSConnectionImpl) {
        this.connection = tLSConnectionImpl;
    }

    public void handleAlertMessages(ByteArrayInputStream byteArrayInputStream) throws IOException, HandshakeWouldBlockException {
        if (this.alertFragment != -1) {
            this.handle(new Alert(this.alertFragment, byteArrayInputStream.read()));
        }
        while (byteArrayInputStream.available() >= 2) {
            this.handle(new Alert(byteArrayInputStream.read(), byteArrayInputStream.read()));
        }
        this.alertFragment = byteArrayInputStream.read();
    }

    public void handle(Alert alert) throws IOException, HandshakeWouldBlockException {
        Object object;
        if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_WARN)) {
            WeblogicHandler.debug(WeblogicHandler.DEBUG_WARN, "Alert received from peer, notifying peer we received it: " + alert, null);
        }
        if (alert.getAlertType() != 0) {
            SSLSetup.logAlertReceivedFromPeer(this.connection.getSSLSocket(), alert.getAlertType());
        }
        this.connection.fireAlertReceived(alert);
        if (alert.getAlertType() == 0) {
            if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_INFO)) {
                WeblogicHandler.debug(WeblogicHandler.DEBUG_INFO, "CLOSE_NOTIFY received from peer, closing connection: ", null);
            }
            this.connection.closeReadHandler();
            object = this.connection.getSSLSocket();
            if (object != null) {
                try {
                    if (isLinux) {
                        try {
                            ((Socket)object).shutdownInput();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        try {
                            ((Socket)object).shutdownOutput();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    ((Socket)object).close();
                }
                catch (Exception exception) {}
            } else {
                this.connection.close();
            }
        }
        if (alert.getSeverity() == 2) {
            if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_WARN)) {
                WeblogicHandler.debug(WeblogicHandler.DEBUG_WARN, "FATAL alert received from peer, dropping connection: " + alert, null);
            }
            this.connection.drop();
        }
        if (alert.getAlertType() == 41 && !this.connection.isClient()) {
            X509Certificate[][] x509CertificateArray;
            if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_INFO)) {
                WeblogicHandler.debug(WeblogicHandler.DEBUG_INFO, "NO_CERTIFICATE received by peer, checking with TrustManager", null);
            }
            if (!((CertificateSupport)(object = this.connection.getCertificateSupport())).isServerTrusted(x509CertificateArray = new X509Certificate[][]{new X509Certificate[0]}, "", this.connection.getProtocolVersion(), this.connection.getCertificateCallbackRef(), this.connection.getSSLSocket())) {
                if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_INFO)) {
                    WeblogicHandler.debug(WeblogicHandler.DEBUG_INFO, "NO_CERTIFICATE received by peer, not trusted, sending HANDSHAKE_FAILURE to peer", null);
                }
                Alert alert2 = new Alert(2, 40);
                this.connection.fireAlertSent(alert2);
            }
        }
    }
}

