/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.tls.record.handshake;

import com.bea.sslplus.WeblogicHandler;
import com.certicom.tls.ciphersuite.CipherSuite;
import com.certicom.tls.ciphersuite.CryptoNames;
import com.certicom.tls.event.HandshakeWouldBlockException;
import com.certicom.tls.interfaceimpl.CertificateSupport;
import com.certicom.tls.interfaceimpl.ProtocolVersion;
import com.certicom.tls.interfaceimpl.ProtocolVersions;
import com.certicom.tls.interfaceimpl.TLSSystem;
import com.certicom.tls.provider.Cipher;
import com.certicom.tls.provider.CryptoLabels;
import com.certicom.tls.provider.KeyAgreement;
import com.certicom.tls.provider.KeyPairGenerator;
import com.certicom.tls.provider.MessageDigest;
import com.certicom.tls.provider.Signature;
import com.certicom.tls.provider.spec.DHParameters;
import com.certicom.tls.provider.spec.DHPublicKey;
import com.certicom.tls.record.handshake.ClientStateReceivedServerKeyExchange;
import com.certicom.tls.record.handshake.ClientStateSentFinished;
import com.certicom.tls.record.handshake.HandshakeHandler;
import com.certicom.tls.record.handshake.HandshakeMessage;
import com.certicom.tls.record.handshake.HandshakeState;
import com.certicom.tls.record.handshake.MessageCertificate;
import com.certicom.tls.record.handshake.MessageCertificateRequest;
import com.certicom.tls.record.handshake.MessageCertificateVerify;
import com.certicom.tls.record.handshake.MessageClientKeyExchangeECDH;
import com.certicom.tls.record.handshake.MessageClientKeyExchangeRSA;
import com.certicom.tls.record.handshake.MessageFinished;
import com.certicom.tls.record.handshake.MessageServerKeyExchangeDH;
import com.certicom.tls.record.handshake.MessageServerKeyExchangeRSA;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;

final class ClientStateReceivedCertificate
extends HandshakeState
implements CryptoNames,
CryptoLabels {
    private PublicKey peerKey;
    private PrivateKey kaPrivateKey;
    private boolean preferCompressed;

    ClientStateReceivedCertificate(HandshakeHandler handshakeHandler, PublicKey publicKey, boolean bl) {
        super(handshakeHandler);
        this.peerKey = publicKey;
        this.preferCompressed = bl;
    }

    void handle(HandshakeMessage handshakeMessage) throws IOException, NoSuchAlgorithmException, SignatureException, HandshakeWouldBlockException {
        CipherSuite cipherSuite = this.handler.getPendingCipherSuite();
        int n = cipherSuite.getKeyAgreementAlgorithm();
        switch (handshakeMessage.getHandshakeType()) {
            case 0: {
                break;
            }
            case 14: {
                Object object;
                Object object2;
                if (this.handler.returnDebugFlag()) {
                    System.out.println("SERVER_HELLO_DONE \nEnd.");
                }
                if (this.handler.getClientCertSignatureTypes() != null) {
                    MessageCertificateRequest.findCertificateChainForHandler(this.handler);
                    object2 = this.handler.getProtocolVersion();
                    if (this.handler.getClientCertChain() == null && ((ProtocolVersion)object2).equals(ProtocolVersions.SSL30)) {
                        this.handler.fireAlert(1, 41);
                    } else {
                        object = new MessageCertificate(this.handler.getClientCertChain());
                        this.handler.write((HandshakeMessage)object);
                        this.handler.flush();
                        this.handler.setClientCertSentState(true);
                    }
                }
                if (this.handler.returnDebugFlag()) {
                    System.out.print("\nType: CLIENT_KEY_EXCHANGE ");
                }
                try {
                    if (n == 5 || n == 12) {
                        if (!this.handler.getECDSA_fixed_ECDHFlag() && !this.handler.getRSA_fixed_ECDHFlag()) {
                            object = KeyPairGenerator.getInstance("ECDSA");
                            ((KeyPairGenerator)object).initialize(163, TLSSystem.getRandomNumberGenerator());
                            KeyPair keyPair = ((KeyPairGenerator)object).genKeyPair();
                            PublicKey publicKey = keyPair.getPublic();
                            KeyAgreement keyAgreement = KeyAgreement.getInstance("ECDH");
                            keyAgreement.init(keyPair.getPrivate(), TLSSystem.getRandomNumberGenerator());
                            keyAgreement.doPhase(this.peerKey, true);
                            byte[] byArray = new byte[20];
                            byArray = keyAgreement.generateSecret();
                            this.handler.setPremasterSecret(byArray);
                            this.handler.generateMasterSecret();
                            this.handler.generateSecurityParameters();
                            object2 = new MessageClientKeyExchangeECDH(publicKey, this.preferCompressed);
                            this.handler.write((HandshakeMessage)object2);
                        } else {
                            object = this.handler.getCertificateSupport();
                            X509Certificate[] x509CertificateArray = null;
                            if (this.handler.getECDSA_fixed_ECDHFlag()) {
                                x509CertificateArray = ((CertificateSupport)object).getAuthChain("ECDSA", 0);
                            } else if (this.handler.getRSA_fixed_ECDHFlag()) {
                                x509CertificateArray = ((CertificateSupport)object).getAuthChain("HYBRID", 0);
                            }
                            this.kaPrivateKey = ((CertificateSupport)object).getPrivateKey(x509CertificateArray[0]);
                            SecureRandom secureRandom = TLSSystem.getRandomNumberGenerator();
                            KeyAgreement keyAgreement = KeyAgreement.getInstance("ECDH");
                            keyAgreement.init(this.kaPrivateKey, secureRandom);
                            keyAgreement.doPhase(this.peerKey, true);
                            byte[] byArray = new byte[20];
                            byArray = keyAgreement.generateSecret();
                            this.handler.setPremasterSecret(byArray);
                            this.handler.generateMasterSecret();
                            this.handler.generateSecurityParameters();
                            object2 = new MessageClientKeyExchangeECDH();
                            this.handler.write((HandshakeMessage)object2);
                        }
                    } else {
                        object2 = this.doRSAKE();
                        object = Cipher.getInstance("RSA/ECB/PKCS1Padding");
                        ((Cipher)object).init(1, (Key)this.peerKey, TLSSystem.getRandomNumberGenerator());
                        byte[] byArray = ((Cipher)object).doFinal((byte[])object2, 0, ((Object)object2).length);
                        MessageClientKeyExchangeRSA messageClientKeyExchangeRSA = new MessageClientKeyExchangeRSA(byArray, this.handler.getProtocolVersion());
                        this.handler.write(messageClientKeyExchangeRSA);
                    }
                    this.handler.flush();
                    if (!this.handler.getECDSA_fixed_ECDHFlag() && !this.handler.getRSA_fixed_ECDHFlag() && this.handler.getClientCertChain() != null) {
                        object2 = new MessageCertificateVerify(this.handler);
                        this.handler.write((HandshakeMessage)object2);
                        this.handler.flush();
                    }
                    this.handler.changeCipherSpec();
                    this.handler.flush();
                    object2 = new MessageFinished(this.handler.getVerifyData(true));
                    this.handler.write((HandshakeMessage)object2);
                    this.handler.flush();
                    this.handler.setState(new ClientStateSentFinished(this.handler));
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    WeblogicHandler.debugEaten(noSuchAlgorithmException);
                    this.handler.fireAlert();
                }
                catch (InvalidKeyException invalidKeyException) {
                    WeblogicHandler.debugEaten(invalidKeyException);
                    this.handler.fireAlert();
                }
                break;
            }
            case 12: {
                if (this.handler.returnDebugFlag()) {
                    System.out.println("SERVER_KEY_EXCHANGE \nEnd.");
                }
                try {
                    if (n == 2 || n == 3 || n == 10 || n == 11 || n == 4 || n == 1 || n == 9) {
                        Object object;
                        MessageServerKeyExchangeDH messageServerKeyExchangeDH = (MessageServerKeyExchangeDH)handshakeMessage;
                        if (n == 10 || n == 11) {
                            if (!this.verifyMessageRSASignature(messageServerKeyExchangeDH.getDHMessage(), messageServerKeyExchangeDH.getSignature())) {
                                this.handler.fireAlert(2, 51);
                            }
                        } else if (n != 1 && n != 9) {
                            object = n == 10 || n == 11 ? Signature.getInstance("RSA") : Signature.getInstance("SHA1withDSA");
                            ((Signature)object).initVerify(this.peerKey);
                            ((Signature)object).update(this.handler.getClientRandom());
                            ((Signature)object).update(this.handler.getServerRandom());
                            ((Signature)object).update(messageServerKeyExchangeDH.getDHMessage());
                            if (!((Signature)object).verify(messageServerKeyExchangeDH.getSignature())) {
                                this.handler.fireAlert(2, 51);
                            }
                        }
                        object = messageServerKeyExchangeDH.getDHParameters();
                        DHPublicKey dHPublicKey = messageServerKeyExchangeDH.getDHPublicKey();
                        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("DiffieHellman");
                        keyPairGenerator.initialize((DHParameters)object, TLSSystem.getRandomNumberGenerator());
                        KeyPair keyPair = keyPairGenerator.genKeyPair();
                        PublicKey publicKey = keyPair.getPublic();
                        KeyAgreement keyAgreement = KeyAgreement.getInstance("DiffieHellman");
                        keyAgreement.init(keyPair.getPrivate(), TLSSystem.getRandomNumberGenerator());
                        keyAgreement.doPhase(dHPublicKey, true);
                        byte[] byArray = keyAgreement.generateSecret();
                        this.handler.setPremasterSecret(byArray);
                        this.handler.generateMasterSecret();
                        this.handler.generateSecurityParameters();
                        this.handler.setState(new ClientStateReceivedServerKeyExchange(this.handler, publicKey, null));
                        break;
                    }
                    if (n != 7 && n != 8) break;
                    MessageServerKeyExchangeRSA messageServerKeyExchangeRSA = (MessageServerKeyExchangeRSA)handshakeMessage;
                    if (!this.verifyMessageRSASignature(messageServerKeyExchangeRSA.getRSAMessage(), messageServerKeyExchangeRSA.getSignature())) {
                        this.handler.fireAlert(2, 51);
                    }
                    RSAPublicKey rSAPublicKey = messageServerKeyExchangeRSA.getPublicKey();
                    byte[] byArray = this.doRSAKE();
                    this.handler.setState(new ClientStateReceivedServerKeyExchange(this.handler, rSAPublicKey, byArray));
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    WeblogicHandler.debugEaten(noSuchAlgorithmException);
                    this.handler.fireAlert();
                }
                catch (InvalidKeyException invalidKeyException) {
                    WeblogicHandler.debugEaten(invalidKeyException);
                }
                break;
            }
            case 13: {
                if (this.handler.returnDebugFlag()) {
                    System.out.println("CERTIFICATE_REQUEST \nEnd.");
                }
                MessageCertificateRequest messageCertificateRequest = (MessageCertificateRequest)handshakeMessage;
                this.handler.setClientCertSignatureTypes(messageCertificateRequest.getSignatureTypes());
                this.handler.setClientCertDistinguishedNames(messageCertificateRequest.getDistinguishedNames());
                break;
            }
            default: {
                this.handler.fireAlert(2, 10);
            }
        }
    }

    private boolean verifyMessageRSASignature(byte[] byArray, byte[] byArray2) throws NoSuchAlgorithmException, InvalidKeyException {
        Cipher cipher = Cipher.getInstance("RSA/ECB/NoPadding");
        cipher.init(2, (Key)this.peerKey, TLSSystem.getRandomNumberGenerator());
        byte[] byArray3 = cipher.doFinal(byArray2, 0, byArray2.length);
        byte[] byArray4 = this.handler.removePKCS1Padding(byArray3);
        if (byArray4.length != 36) {
            return false;
        }
        byte[] byArray5 = this.hashRandomAndParams("MD5", byArray);
        byte[] byArray6 = this.hashRandomAndParams("SHA", byArray);
        return this.handler.isEqual(byArray4, 0, 16, byArray5, 0, byArray5.length) && this.handler.isEqual(byArray4, 16, 20, byArray6, 0, byArray6.length);
    }

    private byte[] hashRandomAndParams(String string, byte[] byArray) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance(string);
        messageDigest.update(this.handler.getClientRandom());
        messageDigest.update(this.handler.getServerRandom());
        messageDigest.update(byArray);
        return messageDigest.digest();
    }

    private byte[] doRSAKE() throws IOException, NoSuchAlgorithmException, InvalidKeyException, HandshakeWouldBlockException {
        byte[] byArray = new byte[48];
        TLSSystem.getRandomNumberGenerator().nextBytes(byArray);
        ProtocolVersion protocolVersion = this.handler.getHelloProtocol();
        if (this.handler.getHandshakeRollBackBug()) {
            protocolVersion = this.handler.getProtocolVersion();
        }
        byArray[0] = (byte)protocolVersion.getMajor();
        byArray[1] = (byte)protocolVersion.getMinor();
        this.handler.setPremasterSecret(byArray);
        this.handler.generateMasterSecret();
        this.handler.generateSecurityParameters();
        return byArray;
    }
}

