/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.tls.record.handshake;

import com.certicom.security.cert.internal.x509.ServerGatedCryptoCert;
import com.certicom.security.cert.internal.x509.X509V3CertImpl;
import com.certicom.tls.ciphersuite.CryptoNames;
import com.certicom.tls.event.HandshakeWouldBlockException;
import com.certicom.tls.interfaceimpl.CertificateSupport;
import com.certicom.tls.record.handshake.ClientStateNoHandshake;
import com.certicom.tls.record.handshake.ClientStateReceivedCertificate;
import com.certicom.tls.record.handshake.HandshakeHandler;
import com.certicom.tls.record.handshake.HandshakeMessage;
import com.certicom.tls.record.handshake.HandshakeState;
import com.certicom.tls.record.handshake.MessageCertificate;
import com.certicom.tls.record.handshake.MessageFinished;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLSocket;

final class ClientStateReceivedServerHello
extends HandshakeState
implements CryptoNames {
    ClientStateReceivedServerHello(HandshakeHandler handshakeHandler) {
        super(handshakeHandler);
    }

    void handle(HandshakeMessage handshakeMessage) throws IOException, NoSuchAlgorithmException, InvalidKeyException, SignatureException, HandshakeWouldBlockException {
        switch (handshakeMessage.getHandshakeType()) {
            case 0: {
                break;
            }
            case 11: {
                Object object;
                int n;
                if (this.handler.returnDebugFlag()) {
                    System.out.println("CERTIFICATE \nEnd.");
                }
                MessageCertificate messageCertificate = (MessageCertificate)handshakeMessage;
                CertificateSupport certificateSupport = this.handler.getCertificateSupport();
                X509Certificate[][] x509CertificateArray = new X509Certificate[][]{messageCertificate.getCertificateChain()};
                SSLSocket sSLSocket = this.handler.getConnectionImpl().getSSLSocket();
                if (!certificateSupport.isServerTrusted(x509CertificateArray, this.handler.getPendingCipherSuite().getDescription(), this.handler.getProtocolVersion(), this.handler.getConnectionImpl().getCertificateCallbackRef(), sSLSocket)) {
                    this.handler.fireAlert(2, 42);
                }
                this.handler.getPendingSession().setPeerCertChain(x509CertificateArray[0]);
                if (!certificateSupport.isServerHostnameValid(sSLSocket)) {
                    this.handler.fireAlert(2, 42);
                }
                if (this.handler.getConnectionImpl().getServerGatedCrypto() && ((n = ((ServerGatedCryptoCert)(object = new ServerGatedCryptoCert(messageCertificate.getCertificateChain()))).getSGCCertificateType()) == 1 || n == 2) && !this.handler.getSGCFlags()[1]) {
                    boolean[] blArray = new boolean[]{true, false};
                    this.handler.setSGCFlags(blArray);
                }
                object = messageCertificate.getCertificateChain()[0];
                PublicKey publicKey = ((Certificate)object).getPublicKey();
                boolean bl = false;
                if (object instanceof X509V3CertImpl) {
                    bl = ((X509V3CertImpl)object).isKeyCompressed();
                }
                this.handler.setState(new ClientStateReceivedCertificate(this.handler, publicKey, bl));
                break;
            }
            case 12: {
                ClientStateReceivedCertificate clientStateReceivedCertificate = new ClientStateReceivedCertificate(this.handler, null, false);
                ((HandshakeState)clientStateReceivedCertificate).handle(handshakeMessage);
                break;
            }
            case 20: {
                if (this.handler.returnDebugFlag()) {
                    System.out.println("FINISHED \nEnd.");
                    System.out.print("Type: FINISHED ");
                }
                this.handler.changeCipherSpec();
                MessageFinished messageFinished = new MessageFinished(this.handler.getVerifyData(true));
                this.handler.write(messageFinished);
                this.handler.flush();
                this.handler.completeHandshake();
                this.handler.setState(new ClientStateNoHandshake(this.handler));
                break;
            }
            default: {
                this.handler.fireAlert(2, 10);
            }
        }
    }
}

