/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.tls.record.handshake;

import com.certicom.tls.ciphersuite.CryptoNames;
import com.certicom.tls.event.HandshakeWouldBlockException;
import com.certicom.tls.interfaceimpl.ProtocolVersion;
import com.certicom.tls.interfaceimpl.ProtocolVersions;
import com.certicom.tls.interfaceimpl.TLSSystem;
import com.certicom.tls.provider.Cipher;
import com.certicom.tls.provider.spec.DHPublicKey;
import com.certicom.tls.record.handshake.ClientStateSentFinished;
import com.certicom.tls.record.handshake.HandshakeHandler;
import com.certicom.tls.record.handshake.HandshakeMessage;
import com.certicom.tls.record.handshake.HandshakeState;
import com.certicom.tls.record.handshake.MessageCertificate;
import com.certicom.tls.record.handshake.MessageCertificateRequest;
import com.certicom.tls.record.handshake.MessageCertificateVerify;
import com.certicom.tls.record.handshake.MessageClientKeyExchangeDH;
import com.certicom.tls.record.handshake.MessageClientKeyExchangeRSA;
import com.certicom.tls.record.handshake.MessageFinished;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;

public final class ClientStateReceivedServerKeyExchange
extends HandshakeState
implements CryptoNames {
    private Object passedKey;
    private Object passedPreMasterSecret;

    public ClientStateReceivedServerKeyExchange(HandshakeHandler handshakeHandler, Object object, Object object2) {
        super(handshakeHandler);
        this.passedKey = object;
        this.passedPreMasterSecret = object2;
    }

    void handle(HandshakeMessage handshakeMessage) throws IOException, NoSuchAlgorithmException, InvalidKeyException, HandshakeWouldBlockException {
        switch (handshakeMessage.getHandshakeType()) {
            case 0: {
                break;
            }
            case 13: {
                int n;
                if (this.handler.returnDebugFlag()) {
                    System.out.println("CERTIFICATE_REQUEST \nEnd.");
                }
                if ((n = this.handler.getPendingCipherSuite().getKeyAgreementAlgorithm()) == 1 || n == 9) {
                    this.handler.fireAlert(2, 10);
                    break;
                }
                MessageCertificateRequest messageCertificateRequest = (MessageCertificateRequest)handshakeMessage;
                this.handler.setClientCertSignatureTypes(messageCertificateRequest.getSignatureTypes());
                this.handler.setClientCertDistinguishedNames(messageCertificateRequest.getDistinguishedNames());
                break;
            }
            case 14: {
                int n;
                Object object;
                Object object2;
                if (this.handler.returnDebugFlag()) {
                    System.out.println("SERVER_HELLO_DONE \nEnd.");
                    System.out.print("\nType: CLIENT_KEY_EXCHANGE ");
                }
                if (this.handler.getClientCertSignatureTypes() != null) {
                    MessageCertificateRequest.findCertificateChainForHandler(this.handler);
                    object2 = this.handler.getProtocolVersion();
                    if (this.handler.getClientCertChain() == null && ((ProtocolVersion)object2).equals(ProtocolVersions.SSL30)) {
                        this.handler.fireAlert(1, 41);
                    } else {
                        object = new MessageCertificate(this.handler.getClientCertChain());
                        this.handler.write((HandshakeMessage)object);
                    }
                }
                if ((n = this.handler.getPendingCipherSuite().getKeyAgreementAlgorithm()) == 7 || n == 8) {
                    object2 = (Key)this.passedKey;
                    object = (byte[])this.passedPreMasterSecret;
                    Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
                    cipher.init(1, (Key)object2, TLSSystem.getRandomNumberGenerator());
                    byte[] byArray = cipher.doFinal((byte[])object, 0, ((byte[])object).length);
                    MessageClientKeyExchangeRSA messageClientKeyExchangeRSA = new MessageClientKeyExchangeRSA(byArray, this.handler.getProtocolVersion());
                    this.handler.write(messageClientKeyExchangeRSA);
                } else if (n == 1 || n == 9 || n == 2 || n == 3 || n == 10 || n == 11 || n == 4) {
                    object2 = new MessageClientKeyExchangeDH(((DHPublicKey)this.passedKey).getY());
                    this.handler.write((HandshakeMessage)object2);
                } else {
                    this.handler.fireAlert();
                }
                if (this.handler.getClientCertChain() != null) {
                    object2 = new MessageCertificateVerify(this.handler);
                    this.handler.write((HandshakeMessage)object2);
                }
                this.handler.changeCipherSpec();
                object2 = new MessageFinished(this.handler.getVerifyData(true));
                if (this.handler.returnDebugFlag()) {
                    System.out.print("Type: FINISHED ");
                }
                this.handler.write((HandshakeMessage)object2);
                this.handler.flush();
                this.handler.setState(new ClientStateSentFinished(this.handler));
                break;
            }
            default: {
                this.handler.fireAlert(2, 10);
            }
        }
    }
}

