/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.tls.record.handshake;

import com.certicom.locale.Resources;
import com.certicom.tls.event.HandshakeWouldBlockException;
import com.certicom.tls.record.handshake.ClientStateNoHandshake;
import com.certicom.tls.record.handshake.HandshakeHandler;
import com.certicom.tls.record.handshake.HandshakeMessage;
import com.certicom.tls.record.handshake.HandshakeState;
import com.certicom.tls.record.handshake.MessageClientCertificate;
import com.certicom.tls.record.handshake.MessageFinishedVersion2;
import com.certicom.tls.record.handshake.MessageRequestCertificate;
import java.io.IOException;
import java.security.cert.X509Certificate;

final class ClientStateReceivedServerVerify
extends HandshakeState {
    public ClientStateReceivedServerVerify(HandshakeHandler handshakeHandler) {
        super(handshakeHandler);
    }

    void handle(HandshakeMessage handshakeMessage) throws IOException, HandshakeWouldBlockException {
        switch (handshakeMessage.getHandshakeType()) {
            case 7: {
                if (this.handler.returnDebugFlag()) {
                    System.out.println("REQUEST CERTIFICATE");
                }
                MessageRequestCertificate messageRequestCertificate = (MessageRequestCertificate)handshakeMessage;
                byte[] byArray = messageRequestCertificate.getCertificate_Challenge();
                int n = messageRequestCertificate.getAuthenticateType();
                if (n != 1 || byArray.length < 16 && byArray.length > 32) {
                    this.handler.fireSSL2ErrorException(Resources.getMessage("34"));
                }
                try {
                    X509Certificate[] x509CertificateArray = this.handler.getCertificateSupport().getAuthChain("RSA", 0);
                    MessageClientCertificate messageClientCertificate = new MessageClientCertificate(n, byArray, this.handler, x509CertificateArray[0]);
                    this.handler.write(messageClientCertificate);
                    this.handler.flush();
                }
                catch (Exception exception) {
                    this.handleSSL2Error(2, 1);
                }
                break;
            }
            case 6: {
                MessageFinishedVersion2 messageFinishedVersion2;
                byte[] byArray;
                if (this.handler.returnDebugFlag()) {
                    System.out.println("SERVER FINISHED");
                }
                if ((byArray = (messageFinishedVersion2 = (MessageFinishedVersion2)handshakeMessage).getID()).length != 0 && byArray.length != 16) {
                    this.handler.fireSSL2ErrorException(Resources.getMessage("34"));
                }
                if (byArray.length == 16) {
                    this.handler.getPendingSessionID().setID(byArray);
                }
                this.handler.completeHandshake();
                this.handler.setState(new ClientStateNoHandshake(this.handler));
                break;
            }
            default: {
                this.handler.fireSSL2ErrorException(Resources.getMessage("137"));
            }
        }
    }
}

