/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.tls.record.handshake;

import com.bea.sslplus.WeblogicHandler;
import com.certicom.locale.Resources;
import com.certicom.tls.ciphersuite.CipherSuite;
import com.certicom.tls.ciphersuite.CipherSuiteSupport;
import com.certicom.tls.ciphersuite.CryptoNames;
import com.certicom.tls.event.HandshakeWouldBlockException;
import com.certicom.tls.interfaceimpl.CertificateSupport;
import com.certicom.tls.interfaceimpl.ProtocolVersion;
import com.certicom.tls.interfaceimpl.SessionID;
import com.certicom.tls.interfaceimpl.TLSSessionImpl;
import com.certicom.tls.record.alert.Alert;
import com.certicom.tls.record.handshake.ClientStateReceivedServerHello;
import com.certicom.tls.record.handshake.ClientStateSentFinished;
import com.certicom.tls.record.handshake.HandshakeHandler;
import com.certicom.tls.record.handshake.HandshakeMessage;
import com.certicom.tls.record.handshake.HandshakeState;
import com.certicom.tls.record.handshake.MapCipher;
import com.certicom.tls.record.handshake.MessageClientMasterKey;
import com.certicom.tls.record.handshake.MessageFinishedVersion2;
import com.certicom.tls.record.handshake.MessageSSL2Error;
import com.certicom.tls.record.handshake.MessageServerHello;
import com.certicom.tls.record.handshake.MessageServerHelloVersion2;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLSocket;

final class ClientStateSentHello
extends HandshakeState {
    Alert alert;

    ClientStateSentHello(HandshakeHandler handshakeHandler) {
        super(handshakeHandler);
    }

    void handle(HandshakeMessage handshakeMessage) throws IOException, NoSuchAlgorithmException, HandshakeWouldBlockException {
        ProtocolVersion protocolVersion = this.handler.getProtocolVersion();
        if (protocolVersion.equals(ProtocolVersion.SSL20) || handshakeMessage instanceof MessageServerHelloVersion2) {
            this.handleVersion2(handshakeMessage);
            return;
        }
        switch (handshakeMessage.getHandshakeType()) {
            case 0: {
                break;
            }
            case 2: {
                if (this.handler.returnDebugFlag()) {
                    System.out.println("SERVER_HELLO \nEnd.");
                }
                MessageServerHello messageServerHello = (MessageServerHello)handshakeMessage;
                this.handler.setServerRandom(messageServerHello.getRandom().getRandomBytes());
                ProtocolVersion protocolVersion2 = this.handler.getProtocolVersion();
                ProtocolVersion protocolVersion3 = messageServerHello.getProtocolVersion();
                if (protocolVersion3.equals(ProtocolVersion.TLS10) && (protocolVersion2.equals(ProtocolVersion.TLS10) || protocolVersion2.equals(ProtocolVersion.SSL30) && protocolVersion2.isRollForward() || protocolVersion2.equals(ProtocolVersion.SSL20) && protocolVersion2.isRollForward())) {
                    protocolVersion3.resetRecord();
                    this.handler.setProtocolVersion(protocolVersion3);
                } else if (protocolVersion3.equals(ProtocolVersion.SSL30) && (protocolVersion2.equals(ProtocolVersion.SSL30) || protocolVersion2.equals(ProtocolVersion.SSL20) && protocolVersion2.isRollForward() || protocolVersion2.equals(ProtocolVersion.TLS10) && protocolVersion2.isRollBack())) {
                    protocolVersion3.resetRecord();
                    this.handler.setProtocolVersion(protocolVersion3);
                } else {
                    this.alert = new Alert(2, 70);
                    this.handler.fireAlert(this.alert);
                    break;
                }
                if (!this.acceptSessionResumption(messageServerHello)) {
                    CipherSuite cipherSuite = null;
                    try {
                        cipherSuite = CipherSuiteSupport.getCipherSuite(messageServerHello.getCipherSuiteTag());
                    }
                    catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                        WeblogicHandler.debugEaten(noSuchAlgorithmException);
                        this.handler.fireAlert();
                        return;
                    }
                    TLSSessionImpl tLSSessionImpl = this.handler.getPendingSession();
                    SessionID sessionID = tLSSessionImpl.getSessionID();
                    SessionID sessionID2 = messageServerHello.getSessionID();
                    if (!sessionID.isEmpty()) {
                        tLSSessionImpl.invalidate();
                        this.handler.setPendingSession(new TLSSessionImpl(tLSSessionImpl.getPeerID(), tLSSessionImpl.getSessionDB(), sessionID2));
                    } else if (!sessionID2.isEmpty()) {
                        this.handler.setPendingSessionID(sessionID2);
                    }
                    this.handler.setPendingCipherSuite(cipherSuite);
                }
                this.handler.setState(new ClientStateReceivedServerHello(this.handler));
                break;
            }
            default: {
                this.alert = new Alert(2, 10);
                this.handler.fireAlert(this.alert);
            }
        }
    }

    private X509Certificate[] convertToArray(X509Certificate x509Certificate) {
        X509Certificate[] x509CertificateArray = new X509Certificate[]{x509Certificate};
        return x509CertificateArray;
    }

    private boolean acceptSessionResumption(MessageServerHello messageServerHello) throws IOException, NoSuchAlgorithmException, HandshakeWouldBlockException {
        CipherSuite cipherSuite = null;
        SessionID sessionID = this.handler.getPendingSessionID();
        SessionID sessionID2 = messageServerHello.getSessionID();
        if (sessionID2.equals(sessionID) && !sessionID2.isEmpty()) {
            TLSSessionImpl tLSSessionImpl = this.handler.getPendingSession();
            if (this.handler.getSGCFlags()[1]) {
                cipherSuite = CipherSuiteSupport.getCipherSuite(messageServerHello.getCipherSuiteTag());
            } else {
                cipherSuite = CipherSuiteSupport.getCipherSuite(messageServerHello.getCipherSuiteTag());
                CipherSuite[] cipherSuiteArray = this.handler.getEnabledCipherSuites();
                boolean bl = false;
                for (int i = 0; i < cipherSuiteArray.length; ++i) {
                    if (!cipherSuiteArray[i].equals(cipherSuite)) continue;
                    bl = true;
                }
                if (!bl) {
                    return false;
                }
            }
            this.handler.setPendingCipherSuite(cipherSuite);
            this.handler.setMasterSecret(tLSSessionImpl.getMasterSecret());
            this.handler.generateSecurityParameters();
            return true;
        }
        return false;
    }

    void handleVersion2(HandshakeMessage handshakeMessage) throws IOException, NoSuchAlgorithmException, HandshakeWouldBlockException {
        switch (handshakeMessage.getHandshakeType()) {
            case 4: {
                CryptoNames cryptoNames;
                if (this.handler.returnDebugFlag()) {
                    System.out.print("SERVER_HELLO \nEnd.");
                }
                MessageServerHelloVersion2 messageServerHelloVersion2 = (MessageServerHelloVersion2)handshakeMessage;
                ProtocolVersion protocolVersion = this.handler.getProtocolVersion();
                TLSSessionImpl tLSSessionImpl = this.handler.getPendingSession();
                SessionID sessionID = tLSSessionImpl.getSessionID();
                if (protocolVersion.equals(ProtocolVersion.SSL20)) {
                    protocolVersion.resetRecord();
                    this.handler.setProtocolVersion(protocolVersion);
                } else if (protocolVersion.isRollBack()) {
                    this.handler.setProtocolVersion(new ProtocolVersion("SSL2"));
                } else {
                    this.handler.fireSSL2ErrorException(Resources.getMessage("133"));
                    break;
                }
                this.handler.setServerRandom(messageServerHelloVersion2.getConnectionID());
                if (messageServerHelloVersion2.getSession_ID_hit() != 0) {
                    if (sessionID.isEmpty()) {
                        this.handler.fireSSL2ErrorException(Resources.getMessage("252"));
                        return;
                    }
                    cryptoNames = CipherSuiteSupport.getCipherSuite(tLSSessionImpl.getCipherSuite());
                    CipherSuite[] cipherSuiteArray = this.handler.getEnabledCipherSuites();
                    boolean bl = false;
                    for (int i = 0; i < cipherSuiteArray.length; ++i) {
                        if (!cipherSuiteArray[i].equals(cryptoNames)) continue;
                        bl = true;
                    }
                    if (!bl) {
                        MessageSSL2Error messageSSL2Error = new MessageSSL2Error(2);
                        this.handler.write(messageSSL2Error);
                        this.handler.flush();
                        this.handler.handleSSL2Error(2, 2);
                    }
                    this.handler.setPendingCipherSuite((CipherSuite)cryptoNames);
                    this.handler.setMasterSecret(tLSSessionImpl.getMasterSecret());
                    this.handler.generateSecurityParameters();
                } else {
                    if (!sessionID.isEmpty()) {
                        tLSSessionImpl.invalidate();
                        this.handler.setPendingSession(new TLSSessionImpl(tLSSessionImpl.getPeerID(), tLSSessionImpl.getSessionDB(), new SessionID()));
                    }
                    cryptoNames = this.matchCipherSuites(messageServerHelloVersion2.getCipherSuites());
                    this.handler.setPendingCipherSuite((CipherSuite)cryptoNames);
                    if (messageServerHelloVersion2.getCertificateType() != 1) {
                        MessageSSL2Error messageSSL2Error = new MessageSSL2Error(6);
                        this.handler.write(messageSSL2Error);
                        this.handler.flush();
                        this.handler.handleSSL2Error(2, 6);
                        return;
                    }
                    CertificateSupport certificateSupport = this.handler.getCertificateSupport();
                    X509Certificate[] x509CertificateArray = this.convertToArray(messageServerHelloVersion2.getCertificateChain());
                    this.handler.SetServerCertificate(x509CertificateArray[0]);
                    SSLSocket sSLSocket = this.handler.getConnectionImpl().getSSLSocket();
                    X509Certificate[][] x509CertificateArray2 = new X509Certificate[][]{x509CertificateArray};
                    boolean bl = certificateSupport.isServerTrusted(x509CertificateArray2, this.handler.getPendingCipherSuite().getDescription(), this.handler.getProtocolVersion(), this.handler.getConnectionImpl().getCertificateCallbackRef(), sSLSocket);
                    if (bl) {
                        this.handler.getPendingSession().setPeerCertChain(x509CertificateArray2[0]);
                        bl = certificateSupport.isServerHostnameValid(sSLSocket);
                    }
                    if (!bl) {
                        MessageSSL2Error messageSSL2Error = new MessageSSL2Error(4);
                        this.handler.write(messageSSL2Error);
                        this.handler.flush();
                        this.handler.handleSSL2Error(2, 4);
                        return;
                    }
                    PublicKey publicKey = messageServerHelloVersion2.getCertificateChain().getPublicKey();
                    MessageClientMasterKey messageClientMasterKey = new MessageClientMasterKey(this.handler, publicKey);
                    this.handler.write(messageClientMasterKey);
                    this.handler.flush();
                    this.handler.generateSecurityParameters();
                }
                cryptoNames = new MessageFinishedVersion2(1, this.handler.getServerRandom());
                this.handler.write((HandshakeMessage)cryptoNames);
                this.handler.flush();
                this.handler.setState(new ClientStateSentFinished(this.handler));
                break;
            }
            default: {
                this.handler.fireSSL2ErrorException(Resources.getMessage("137"));
            }
        }
    }

    public CipherSuite matchCipherSuites(CipherSuite[] cipherSuiteArray) throws NoSuchAlgorithmException {
        CipherSuite[] cipherSuiteArray2 = this.handler.getEnabledCipherSuites();
        CertificateSupport certificateSupport = this.handler.getCertificateSupport();
        for (int i = 0; i < cipherSuiteArray2.length; ++i) {
            for (int j = 0; j < cipherSuiteArray.length; ++j) {
                if (!cipherSuiteArray2[i].equals(cipherSuiteArray[j]) || MapCipher.isSSL2Cipher(cipherSuiteArray[j].getTag()) != 1) continue;
                return cipherSuiteArray2[i];
            }
        }
        throw new NoSuchAlgorithmException();
    }
}

