/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.tls.record.handshake;

import com.bea.sslplus.WeblogicHandler;
import com.certicom.locale.Resources;
import com.certicom.tls.TLSSessionDB;
import com.certicom.tls.ciphersuite.CipherSuite;
import com.certicom.tls.ciphersuite.CipherSuiteSupport;
import com.certicom.tls.ciphersuite.CipherSuites;
import com.certicom.tls.ciphersuite.CryptoNames;
import com.certicom.tls.ciphersuite.SecurityParameters;
import com.certicom.tls.event.HandshakeWouldBlockException;
import com.certicom.tls.interfaceimpl.AlertEvent;
import com.certicom.tls.interfaceimpl.CertificateSupport;
import com.certicom.tls.interfaceimpl.ProtocolVersion;
import com.certicom.tls.interfaceimpl.ProtocolVersions;
import com.certicom.tls.interfaceimpl.SessionID;
import com.certicom.tls.interfaceimpl.TLSConnectionImpl;
import com.certicom.tls.interfaceimpl.TLSSessionImpl;
import com.certicom.tls.provider.CryptoLabels;
import com.certicom.tls.provider.MessageDigest;
import com.certicom.tls.record.CryptoRecordState;
import com.certicom.tls.record.MessageChangeCipherSpec;
import com.certicom.tls.record.WriteHandler;
import com.certicom.tls.record.alert.Alert;
import com.certicom.tls.record.handshake.ClientStateNoHandshake;
import com.certicom.tls.record.handshake.ClientStateSentHello;
import com.certicom.tls.record.handshake.HandshakeInputBuffer;
import com.certicom.tls.record.handshake.HandshakeMessage;
import com.certicom.tls.record.handshake.HandshakeState;
import com.certicom.tls.record.handshake.MapCipher;
import com.certicom.tls.record.handshake.MessageClientHello;
import com.certicom.tls.record.handshake.MessageClientHelloVersion2;
import com.certicom.tls.record.handshake.MessageFinished;
import com.certicom.tls.record.handshake.MessageHelloRequest;
import com.certicom.tls.record.handshake.MessageRandom;
import com.certicom.tls.record.handshake.MessageSSL2Error;
import com.certicom.tls.record.handshake.ServerStateNoHandshake;
import java.io.IOException;
import java.io.Serializable;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Vector;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLProtocolException;

public final class HandshakeHandler
implements ProtocolVersions,
CryptoLabels,
CryptoNames {
    public static final int SGCFlagDoHandshake = 0;
    public static final int SGCFlagInHandshake = 1;
    private boolean[] sgcFlags = new boolean[2];
    private static final String ENABLE_RENEGOTIATION = "weblogic.security.SSL.enable.renegotiation";
    private boolean ECDSA_fixed_ECDHFlag = false;
    private boolean RSA_fixed_ECDHFlag = false;
    private Principal[] clientCertDistinguishedNames;
    private X509Certificate[] clientCertChain;
    private HandshakeState state = null;
    private HandshakeInputBuffer fragment = new HandshakeInputBuffer(new byte[0]);
    private byte[] serverRandom = null;
    private byte[] clientRandom = null;
    private byte[] Certificate_Challenge = null;
    private byte[] preMasterSecret = null;
    private byte[] masterSecret = null;
    private CipherSuite pendingCipherSuite = CipherSuites.TLS_NULL_WITH_NULL_NULL;
    private ProtocolVersion helloProtocol;
    private byte[] clientCertSignatureTypes;
    private TLSConnectionImpl connection;
    private MessageDigest md5;
    private MessageDigest sha;
    private CertificateSupport certificateSupport;
    private SecurityParameters parameters;
    private boolean debugFlag = false;
    private boolean HandshakeRollBackBug = false;
    private boolean isRenegotiationPending = false;
    private boolean isRenegotiationEnabled = false;
    private ProtocolVersion peerHelloProtocol;
    private int challengeLength = 16;
    private X509Certificate ServerHello_Certificate;
    private boolean bClientCertSentState = false;
    private int LastMessageType = 0;

    public HandshakeHandler(TLSConnectionImpl tLSConnectionImpl, CertificateSupport certificateSupport) {
        this.connection = tLSConnectionImpl;
        this.certificateSupport = certificateSupport;
        this.helloProtocol = tLSConnectionImpl.getProtocolVersion();
        String string = System.getProperty(ENABLE_RENEGOTIATION);
        if (string != null) {
            this.isRenegotiationEnabled = string.equals("true");
        }
        this.sgcFlags[1] = false;
        this.sgcFlags[0] = false;
    }

    public void setDebugFlag() {
        this.debugFlag = true;
    }

    public synchronized void setClientCertSentState(boolean bl) {
        this.bClientCertSentState = bl;
    }

    public synchronized boolean isClientCertSentState() {
        return this.bClientCertSentState;
    }

    public boolean returnDebugFlag() {
        return this.debugFlag;
    }

    public void SetServerCertificate(X509Certificate x509Certificate) {
        this.ServerHello_Certificate = x509Certificate;
    }

    public X509Certificate getServerCertificate() {
        return this.ServerHello_Certificate;
    }

    public int getLastMessageType() {
        return this.LastMessageType;
    }

    public void setHandshakeRollBackBug(boolean bl) {
        this.HandshakeRollBackBug = bl;
    }

    public boolean getHandshakeRollBackBug() {
        return this.HandshakeRollBackBug;
    }

    public void resetState() {
        if (this.isClient() && (this.state == null || this.state instanceof ClientStateNoHandshake || this.state instanceof ServerStateNoHandshake)) {
            this.state = new ClientStateNoHandshake(this);
        } else if (!this.isClient() && (this.state == null || this.state instanceof ServerStateNoHandshake || this.state instanceof ClientStateNoHandshake)) {
            this.state = new ServerStateNoHandshake(this);
        } else {
            throw new IllegalArgumentException(Resources.getMessage("12"));
        }
        try {
            this.md5 = MessageDigest.getInstance("MD5");
            this.sha = MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            WeblogicHandler.debugEaten(noSuchAlgorithmException);
        }
        this.isRenegotiationPending = false;
    }

    public void startHandshake() throws IOException, HandshakeWouldBlockException {
        if (this.isRenegotiationPending) {
            return;
        }
        if (this.isClient() && !(this.state instanceof ClientStateNoHandshake)) {
            throw new IllegalStateException();
        }
        if (this.connection.isHandshakeComplete()) {
            if (this.getProtocolVersion().equals(ProtocolVersion.SSL20)) {
                throw new IOException("Renegotiation not supported in SSL2 protocol");
            }
            if (!this.isRenegotiationEnabled) {
                Alert alert = new Alert(1, 100);
                this.fireAlert(alert);
                return;
            }
            this.resetState();
            this.isRenegotiationPending = true;
        }
        if (this.isClient()) {
            Object object;
            Serializable serializable;
            this.state = new ClientStateSentHello(this);
            CipherSuite[] cipherSuiteArray = this.getEnabledCipherSuites();
            TLSSessionImpl tLSSessionImpl = this.getPendingSession();
            if (!tLSSessionImpl.getSessionID().isEmpty()) {
                try {
                    serializable = CipherSuiteSupport.getCipherSuite(tLSSessionImpl.getCipherSuite());
                    if (!this.connection.getEnabledCipherSuitesVector().contains(serializable)) {
                        throw new NoSuchAlgorithmException();
                    }
                    if (this.helloProtocol.isSSL2Hello()) {
                        object = tLSSessionImpl.getProtocolVersion();
                        this.setHelloProtocol((ProtocolVersion)object);
                        this.connection.setProtocolVersion((ProtocolVersion)object);
                    }
                    this.helloProtocol.resetRecord();
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    WeblogicHandler.debugEaten(noSuchAlgorithmException);
                    this.getSessionDB().remove(tLSSessionImpl.getPeerID());
                    this.setPendingSession(new TLSSessionImpl(tLSSessionImpl.getPeerID(), this.getSessionDB(), new SessionID()));
                }
            }
            if (this.helloProtocol.isSSL2Hello()) {
                if (this.getProtocolVersion().equals(ProtocolVersion.SSL20)) {
                    int n = 0;
                    boolean bl = false;
                    for (n = 0; n < cipherSuiteArray.length; ++n) {
                        if (MapCipher.isSSL2Cipher(cipherSuiteArray[n].getTag()) != 1) continue;
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        MessageSSL2Error messageSSL2Error = new MessageSSL2Error(1);
                        this.write(messageSSL2Error);
                        this.flush();
                        this.handleSSL2Error(2, 1);
                        return;
                    }
                }
                MessageClientHelloVersion2 messageClientHelloVersion2 = new MessageClientHelloVersion2(this.getPendingSessionID(), cipherSuiteArray, this.helloProtocol, new MessageRandom(16).toByteArray());
                this.clientRandom = messageClientHelloVersion2.createTLSClientHello().getRandom().getRandomBytes();
                this.setChallengeLength(16);
                this.write(messageClientHelloVersion2);
                this.flush();
            } else {
                serializable = this.getPendingSessionID();
                if (this.sgcFlags[0]) {
                    this.sgcFlags[0] = false;
                    this.sgcFlags[1] = true;
                    cipherSuiteArray = this.getEnabledCipherSuites();
                    serializable = new SessionID();
                }
                object = new MessageClientHello((SessionID)serializable, cipherSuiteArray, this.helloProtocol, new MessageRandom());
                this.clientRandom = ((MessageClientHello)object).getRandom().getRandomBytes();
                this.write((HandshakeMessage)object);
                this.flush();
            }
        } else {
            if (this.state != null && !(this.state instanceof ServerStateNoHandshake)) {
                this.connection.getWriteHandler().write(new MessageHelloRequest());
                this.flush();
            }
            this.state = new ServerStateNoHandshake(this);
        }
    }

    public void handleChangeCipherSpec() throws IOException, HandshakeWouldBlockException {
        try {
            if (this.isClient()) {
                this.setClientCertSentState(false);
            }
            CryptoRecordState cryptoRecordState = new CryptoRecordState(this.parameters.createReadCipher(), this.parameters.createReadMac());
            this.connection.getReadHandler().getMessageInterpreter().setCryptoRecordState(cryptoRecordState);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            WeblogicHandler.debugEaten(noSuchAlgorithmException);
            Alert alert = new Alert(2, 40);
            this.fireAlert(alert);
        }
    }

    public void changeCipherSpec() throws IOException, HandshakeWouldBlockException {
        WriteHandler writeHandler = this.connection.getWriteHandler();
        writeHandler.write(new MessageChangeCipherSpec());
        try {
            String string = this.parameters.getCipherAlgorithm();
            if (string.toUpperCase().startsWith("NULL")) {
                WeblogicHandler.logSSLUsingNullCipher();
                if (!CipherSuiteSupport.isUnEncrytedNullCipherAllowed()) {
                    throw new IllegalArgumentException("NullCipher is used but the configuration flag is not set");
                }
            }
            CryptoRecordState cryptoRecordState = new CryptoRecordState(this.parameters.createWriteCipher(), this.parameters.createWriteMac());
            writeHandler.getMessageEncryptor().setCryptoRecordState(cryptoRecordState);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            WeblogicHandler.debugEaten(noSuchAlgorithmException);
            Alert alert = new Alert(2, 40);
            this.fireAlert(alert);
        }
    }

    public void setSSL2CryptoRecordState() throws IOException {
        try {
            CryptoRecordState cryptoRecordState = this.connection.getReadHandler().getMessageInterpreter().getCryptoRecordState();
            cryptoRecordState.setCipher(this.parameters.createReadCipher());
            cryptoRecordState.setMac(this.parameters.createReadMac());
            CryptoRecordState cryptoRecordState2 = this.connection.getWriteHandler().getMessageEncryptor().getCryptoRecordState();
            cryptoRecordState2.setCipher(this.parameters.createWriteCipher());
            cryptoRecordState2.setMac(this.parameters.createWriteMac());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            WeblogicHandler.debugEaten(noSuchAlgorithmException);
            this.handleSSL2Error(2, 40);
        }
    }

    public SecurityParameters getSecurityParameters() {
        return this.parameters;
    }

    void generateSecurityParameters() throws IOException, HandshakeWouldBlockException {
        try {
            if (this.getProtocolVersion().equals(SSL20)) {
                this.parameters = new SecurityParameters(this.pendingCipherSuite, this.masterSecret, this.clientRandom, this.serverRandom, this.getProtocolVersion(), this.challengeLength, this.isClient());
                this.setSSL2CryptoRecordState();
            } else {
                this.parameters = new SecurityParameters(this.pendingCipherSuite, this.masterSecret, this.clientRandom, this.serverRandom, this.getProtocolVersion(), this.isClient());
            }
            TLSSessionImpl tLSSessionImpl = this.getPendingSession();
            tLSSessionImpl.setCipher(this.pendingCipherSuite);
            tLSSessionImpl.setProtocolVersion(this.getProtocolVersion());
            tLSSessionImpl.setMasterSecret(this.masterSecret);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            WeblogicHandler.debugEaten(noSuchAlgorithmException);
            Alert alert = new Alert(2, 40);
            this.fireAlert(alert);
        }
    }

    public void handleHandshakeMessages(byte[] byArray, int n, ProtocolVersion protocolVersion) throws IOException, HandshakeWouldBlockException {
        if (this.connection.isHandshakeComplete() && !this.isRenegotiationEnabled) {
            Alert alert = new Alert(1, 100);
            this.fireAlert(alert);
            return;
        }
        HandshakeInputBuffer handshakeInputBuffer = new HandshakeInputBuffer(byArray, 0, n);
        if (this.fragment.available() > 0) {
            int n2 = this.fragment.available();
            int n3 = handshakeInputBuffer.available();
            byte[] byArray2 = new byte[n2 + n3];
            this.fragment.read(byArray2, 0, n2);
            handshakeInputBuffer.read(byArray2, n2, n3);
            this.fragment = new HandshakeInputBuffer(byArray2);
        } else {
            this.fragment = new HandshakeInputBuffer(byArray, 0, n);
        }
        while (this.fragment.available() > 0) {
            HandshakeMessage handshakeMessage;
            this.fragment.mark();
            try {
                handshakeMessage = HandshakeMessage.create(this.fragment, this.pendingCipherSuite, protocolVersion);
            }
            catch (IOException iOException) {
                WeblogicHandler.debugEaten(iOException);
                this.fragment.reset();
                return;
            }
            catch (CertificateException certificateException) {
                Alert alert = new Alert(2, 42);
                this.fireAlert(alert);
                this.fragment = new HandshakeInputBuffer(new byte[0]);
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                WeblogicHandler.debugEaten(illegalArgumentException);
                Alert alert = new Alert(2, 40);
                this.fireAlert(alert);
                this.fragment = new HandshakeInputBuffer(new byte[0]);
                return;
            }
            this.handleHandshakeMessage(handshakeMessage);
        }
    }

    public void handleVersion2HandshakeMessages(byte[] byArray) throws IOException, HandshakeWouldBlockException {
        HandshakeMessage handshakeMessage;
        try {
            handshakeMessage = HandshakeMessage.createVersion2(byArray, this.connection.getEnabledCipherSuitesVector());
            if (handshakeMessage instanceof MessageSSL2Error && ((MessageSSL2Error)handshakeMessage).getError() == 2 && this.isClient()) {
                this.write(handshakeMessage);
                this.flush();
                return;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            WeblogicHandler.debugEaten(illegalArgumentException);
            this.handleSSL2Error(2, 70);
            return;
        }
        this.handleHandshakeMessage(handshakeMessage);
    }

    private void handleHandshakeMessage(HandshakeMessage handshakeMessage) throws IOException, HandshakeWouldBlockException {
        if (handshakeMessage.getHandshakeType() == 20) {
            this.verifyHandshake(((MessageFinished)handshakeMessage).getVerifyData());
        }
        this.updateHashes(handshakeMessage);
        if (handshakeMessage instanceof MessageSSL2Error) {
            MessageSSL2Error messageSSL2Error = (MessageSSL2Error)handshakeMessage;
            this.handleSSL2ErrorMessage(messageSSL2Error);
            return;
        }
        try {
            this.state.handle(handshakeMessage);
        }
        catch (SSLException sSLException) {
            throw sSLException;
        }
        catch (Exception exception) {
            if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_INFO)) {
                WeblogicHandler.debug(WeblogicHandler.DEBUG_INFO, "Exception during handshake, stack trace follows", exception);
            }
            WeblogicHandler.debugEaten(exception);
            this.fireAlert();
        }
    }

    boolean getNeedClientAuth() {
        return this.connection.getNeedClientAuth();
    }

    byte[] getMD5Digest() {
        try {
            return ((MessageDigest)this.md5.clone()).digest();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            WeblogicHandler.debugEaten(cloneNotSupportedException);
            return null;
        }
    }

    byte[] getSHA1Digest() {
        try {
            return ((MessageDigest)this.sha.clone()).digest();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            WeblogicHandler.debugEaten(cloneNotSupportedException);
            return null;
        }
    }

    TLSConnectionImpl getConnectionImpl() {
        return this.connection;
    }

    void setPendingSessionID(SessionID sessionID) {
        this.getPendingSession().setSessionID(sessionID);
    }

    SessionID getPendingSessionID() {
        return this.getPendingSession().getSessionID();
    }

    TLSSessionDB getSessionDB() {
        return this.connection.getSessionDB();
    }

    boolean isClient() {
        return this.connection.isClient();
    }

    ProtocolVersion getHelloProtocol() {
        return this.helloProtocol;
    }

    public void setHelloProtocol(ProtocolVersion protocolVersion) {
        this.helloProtocol = protocolVersion;
    }

    ProtocolVersion getPeerHelloProtocol() {
        return this.peerHelloProtocol;
    }

    void setPeerHelloProtocol(ProtocolVersion protocolVersion) {
        this.peerHelloProtocol = protocolVersion;
    }

    void setClientRandom(byte[] byArray) {
        this.clientRandom = byArray;
    }

    public byte[] getClientRandom() {
        return this.clientRandom;
    }

    void setChallengeLength(int n) {
        this.challengeLength = n;
    }

    public int getChallengeLength() {
        return this.challengeLength;
    }

    void setServerRandom(byte[] byArray) {
        this.serverRandom = byArray;
    }

    public byte[] getServerRandom() {
        return this.serverRandom;
    }

    ProtocolVersion getProtocolVersion() {
        return this.connection.getProtocolVersion();
    }

    void setProtocolVersion(ProtocolVersion protocolVersion) {
        this.connection.setProtocolVersion(protocolVersion);
    }

    CipherSuite[] getEnabledCipherSuites() {
        Object object;
        int n;
        Vector vector = this.connection.getEnabledCipherSuitesVector();
        int n2 = n = vector.size();
        int n3 = 0;
        int n4 = 0;
        boolean[] blArray = new boolean[n2];
        boolean bl = false;
        boolean bl2 = bl = this.isClient() && !this.sgcFlags[1] && this.connection.getServerGatedCrypto();
        if (bl) {
            n4 = 0;
            for (n3 = 0; n3 < n; ++n3) {
                object = (CipherSuite)vector.elementAt(n3);
                if (((CipherSuite)object).isExportable()) {
                    ++n4;
                    blArray[n3] = true;
                    continue;
                }
                blArray[n3] = false;
            }
            n2 = n4;
        }
        object = new CipherSuite[n2];
        if (bl) {
            n4 = 0;
            for (n3 = 0; n3 < n; ++n3) {
                if (!blArray[n3]) continue;
                object[n4] = (CipherSuite)vector.elementAt(n3);
                ++n4;
            }
        } else {
            vector.copyInto((Object[])object);
        }
        return object;
    }

    void setPremasterSecret(byte[] byArray) {
        this.preMasterSecret = byArray;
    }

    void setPendingCipherSuite(CipherSuite cipherSuite) {
        this.pendingCipherSuite = cipherSuite;
    }

    CipherSuite getPendingCipherSuite() {
        return this.pendingCipherSuite;
    }

    void setPendingSession(TLSSessionImpl tLSSessionImpl) {
        this.connection.setSessionImpl(tLSSessionImpl);
    }

    TLSSessionImpl getPendingSession() {
        return this.connection.getSessionImpl();
    }

    CertificateSupport getCertificateSupport() {
        return this.certificateSupport;
    }

    void setClientCertSignatureTypes(byte[] byArray) {
        this.clientCertSignatureTypes = byArray;
    }

    void setClientCertDistinguishedNames(Principal[] principalArray) {
        this.clientCertDistinguishedNames = principalArray;
    }

    byte[] getClientCertSignatureTypes() {
        return this.clientCertSignatureTypes;
    }

    Principal[] getClientCertDistinguishedNames() {
        return this.clientCertDistinguishedNames;
    }

    void setClientCertChain(X509Certificate[] x509CertificateArray) {
        this.clientCertChain = x509CertificateArray;
    }

    X509Certificate[] getClientCertChain() {
        return this.clientCertChain;
    }

    boolean[] getSGCFlags() {
        return this.sgcFlags;
    }

    void setSGCFlags(boolean[] blArray) {
        this.sgcFlags = blArray;
    }

    public boolean getECDSA_fixed_ECDHFlag() {
        return this.ECDSA_fixed_ECDHFlag;
    }

    void setECDSA_fixed_ECDHFlag(boolean bl) {
        this.ECDSA_fixed_ECDHFlag = bl;
    }

    public boolean getRSA_fixed_ECDHFlag() {
        return this.RSA_fixed_ECDHFlag;
    }

    void setRSA_fixed_ECDHFlag(boolean bl) {
        this.RSA_fixed_ECDHFlag = bl;
    }

    private void verifyHandshake(byte[] byArray) throws IOException, HandshakeWouldBlockException {
        byte[] byArray2 = this.getVerifyData(!this.isClient());
        if (!MessageDigest.isEqual(byArray, byArray2)) {
            Alert alert = new Alert(2, 51);
            this.fireAlert(alert);
        }
    }

    void completeHandshake() {
        this.connection.setHandshakeComplete(true);
        this.getPendingSession().makeResumable(this.isClient());
        this.resetHandshakeParams();
    }

    void resetHandshakeParams() {
        this.sha.reset();
        this.md5.reset();
    }

    void fireAlert(int n, int n2) throws IOException, HandshakeWouldBlockException {
        Alert alert = new Alert(n, n2);
        this.fireAlert(alert);
    }

    void fireAlert() throws IOException, HandshakeWouldBlockException {
        Alert alert = new Alert(2, 40);
        this.fireAlert(alert);
    }

    void fireAlert(Alert alert) throws IOException, HandshakeWouldBlockException {
        AlertEvent alertEvent = this.connection.fireAlertSent(alert);
    }

    void handleSSL2Error(int n, int n2) throws IOException {
        if (n == 2) {
            this.connection.drop();
            this.fireSSL2ErrorException(n2);
        }
    }

    public void fireSSL2ErrorException(int n) throws IOException {
        Alert alert = new Alert(2, n);
        AlertEvent alertEvent = new AlertEvent(this.connection, alert.getSeverity() == 2, alert.getAlertType());
        this.connection.fireException(alertEvent);
    }

    public void fireSSL2ErrorException(String string) throws IOException {
        this.connection.drop();
        throw new SSLProtocolException(string);
    }

    void setState(HandshakeState handshakeState) {
        this.state = handshakeState;
    }

    void setMasterSecret(byte[] byArray) {
        this.masterSecret = byArray;
    }

    public byte[] getMasterSecret() {
        return this.masterSecret;
    }

    void generateMasterSecret() throws IOException, HandshakeWouldBlockException {
        block5: {
            try {
                if (this.getProtocolVersion().equals(TLS10)) {
                    this.masterSecret = SecurityParameters.TLS_PRF(this.preMasterSecret, MASTER_SECRET, this.clientRandom, this.serverRandom, 48);
                    break block5;
                }
                if (this.getProtocolVersion().equals(SSL30)) {
                    this.masterSecret = SecurityParameters.SSL3_PRF(this.preMasterSecret, this.clientRandom, this.serverRandom, 48);
                    break block5;
                }
                if (this.getProtocolVersion().equals(SSL20)) {
                    this.masterSecret = this.preMasterSecret;
                    break block5;
                }
                throw new NoSuchAlgorithmException();
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                WeblogicHandler.debugEaten(noSuchAlgorithmException);
                Alert alert = new Alert(2, 40);
                this.fireAlert(alert);
            }
        }
    }

    MessageDigest getMD5Clone() throws CloneNotSupportedException {
        return (MessageDigest)this.md5.clone();
    }

    MessageDigest getSHAClone() throws CloneNotSupportedException {
        return (MessageDigest)this.sha.clone();
    }

    byte[] getVerifyData(boolean bl) throws IOException, HandshakeWouldBlockException {
        byte[] byArray;
        block5: {
            byArray = null;
            byte[] byArray2 = null;
            try {
                MessageDigest messageDigest = (MessageDigest)this.md5.clone();
                MessageDigest messageDigest2 = (MessageDigest)this.sha.clone();
                if (this.getProtocolVersion().equals(TLS10)) {
                    byArray2 = bl ? CLIENT_FINISHED : SERVER_FINISHED;
                    byArray = SecurityParameters.TLS_PRF(this.masterSecret, byArray2, messageDigest.digest(), messageDigest2.digest(), 12);
                    break block5;
                }
                if (this.getProtocolVersion().equals(SSL30)) {
                    byArray2 = bl ? SSL3_CLIENT_FINISHED : SSL3_SERVER_FINISHED;
                    messageDigest.update(byArray2);
                    messageDigest.update(this.masterSecret);
                    messageDigest.update(SSL3_IPAD_MD5);
                    MessageDigest messageDigest3 = MessageDigest.getInstance("MD5");
                    messageDigest3.update(this.masterSecret);
                    messageDigest3.update(SSL3_OPAD_MD5);
                    messageDigest3.update(messageDigest.digest());
                    byte[] byArray3 = messageDigest3.digest();
                    messageDigest2.update(byArray2);
                    messageDigest2.update(this.masterSecret);
                    messageDigest2.update(SSL3_IPAD_SHA);
                    MessageDigest messageDigest4 = MessageDigest.getInstance("SHA");
                    messageDigest4.update(this.masterSecret);
                    messageDigest4.update(SSL3_OPAD_SHA);
                    messageDigest4.update(messageDigest2.digest());
                    byte[] byArray4 = messageDigest4.digest();
                    byArray = new byte[byArray3.length + byArray4.length];
                    System.arraycopy(byArray3, 0, byArray, 0, byArray3.length);
                    System.arraycopy(byArray4, 0, byArray, byArray3.length, byArray4.length);
                    break block5;
                }
                throw new NoSuchAlgorithmException();
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                WeblogicHandler.debugEaten(noSuchAlgorithmException);
                Alert alert = new Alert(2, 40);
                this.fireAlert(alert);
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                WeblogicHandler.debugEaten(cloneNotSupportedException);
                Alert alert = new Alert(2, 40);
                this.fireAlert(alert);
            }
        }
        return byArray;
    }

    void write(HandshakeMessage handshakeMessage) throws IOException {
        this.updateHashes(handshakeMessage);
        this.connection.getWriteHandler().write(handshakeMessage);
        this.LastMessageType = handshakeMessage.getHandshakeType();
    }

    void flush() throws IOException, HandshakeWouldBlockException {
        this.connection.getWriteHandler().flushOutput();
    }

    void updateHashes(HandshakeMessage handshakeMessage) {
        byte[] byArray = handshakeMessage.toByteArray();
        if (handshakeMessage.getHandshakeType() != 0) {
            this.md5.update(byArray);
            this.sha.update(byArray);
        }
    }

    public byte[] addPKCS1Padding(int n, byte[] byArray) {
        byte[] byArray2 = new byte[]{};
        if (byArray.length >= n - 3) {
            return byArray2;
        }
        byte[] byArray3 = new byte[n];
        int n2 = 0;
        byArray3[n2++] = 0;
        byArray3[n2++] = 1;
        while (n2 < n - byArray.length - 1) {
            byArray3[n2] = -1;
            ++n2;
        }
        byArray3[n2++] = 0;
        System.arraycopy(byArray, 0, byArray3, n2, byArray.length);
        return byArray3;
    }

    public byte[] addPKCS1Type2Padding(int n, byte[] byArray) {
        byte[] byArray2 = new byte[]{};
        if (byArray.length >= n - 3) {
            return byArray2;
        }
        byte[] byArray3 = new byte[n];
        int n2 = 0;
        byArray3[n2++] = 0;
        byArray3[n2++] = 2;
        while (n2 < n - byArray.length - 1) {
            byArray3[n2] = 3;
            ++n2;
        }
        byArray3[n2++] = 0;
        System.arraycopy(byArray, 0, byArray3, n2, byArray.length);
        return byArray3;
    }

    public byte[] removePKCS1Padding(byte[] byArray) {
        byte[] byArray2 = new byte[]{};
        int n = -1;
        if (byArray.length < 4 || byArray[0] != 0) {
            return byArray;
        }
        switch (byArray[1]) {
            case 1: 
            case 2: {
                for (n = 2; n < byArray.length && byArray[n] != 0; ++n) {
                }
                break;
            }
            default: {
                return byArray;
            }
        }
        if (n == byArray.length) {
            return byArray2;
        }
        int n2 = n + 1;
        byte[] byArray3 = new byte[byArray.length - n2];
        System.arraycopy(byArray, n2, byArray3, 0, byArray3.length);
        return byArray3;
    }

    byte[] getV3CertificateVerifySHAHash(MessageDigest messageDigest) throws NoSuchAlgorithmException {
        messageDigest.update(this.masterSecret);
        messageDigest.update(SSL3_IPAD_SHA);
        MessageDigest messageDigest2 = MessageDigest.getInstance("SHA");
        messageDigest2.update(this.masterSecret);
        messageDigest2.update(SSL3_OPAD_SHA);
        messageDigest2.update(messageDigest.digest());
        return messageDigest2.digest();
    }

    byte[] getV3CertificateVerifyMD5Hash(MessageDigest messageDigest) throws NoSuchAlgorithmException {
        messageDigest.update(this.masterSecret);
        messageDigest.update(SSL3_IPAD_MD5);
        MessageDigest messageDigest2 = MessageDigest.getInstance("MD5");
        messageDigest2.update(this.masterSecret);
        messageDigest2.update(SSL3_OPAD_MD5);
        messageDigest2.update(messageDigest.digest());
        return messageDigest2.digest();
    }

    public boolean isEqual(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) {
        if (n2 != n4) {
            return false;
        }
        for (int i = 0; i < n2; ++i) {
            if (byArray[n + i] == byArray2[n3 + i]) continue;
            return false;
        }
        return true;
    }

    public void handleSSL2ErrorMessage(MessageSSL2Error messageSSL2Error) throws IOException {
        String string;
        int n = messageSSL2Error.getError();
        switch (n) {
            case 1: {
                string = Resources.getMessage("245");
                break;
            }
            case 2: {
                string = Resources.getMessage("73");
                break;
            }
            case 4: {
                string = Resources.getMessage("3");
                break;
            }
            case 6: {
                string = Resources.getMessage("135");
                break;
            }
            default: {
                string = Resources.getMessage("137");
            }
        }
        this.fireSSL2ErrorException(string);
    }
}

