/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.tls.record.handshake;

import com.bea.sslplus.WeblogicHandler;
import com.certicom.locale.Resources;
import com.certicom.tls.ciphersuite.CipherSuite;
import com.certicom.tls.ciphersuite.CryptoNames;
import com.certicom.tls.event.HandshakeWouldBlockException;
import com.certicom.tls.interfaceimpl.ProtocolVersion;
import com.certicom.tls.interfaceimpl.TLSSystem;
import com.certicom.tls.record.Message;
import com.certicom.tls.record.Util;
import com.certicom.tls.record.handshake.HandshakeTypes;
import com.certicom.tls.record.handshake.MessageCertificate;
import com.certicom.tls.record.handshake.MessageCertificateRequest;
import com.certicom.tls.record.handshake.MessageCertificateVerify;
import com.certicom.tls.record.handshake.MessageClientCertificate;
import com.certicom.tls.record.handshake.MessageClientHello;
import com.certicom.tls.record.handshake.MessageClientHelloVersion2;
import com.certicom.tls.record.handshake.MessageClientKeyExchangeDH;
import com.certicom.tls.record.handshake.MessageClientKeyExchangeECDH;
import com.certicom.tls.record.handshake.MessageClientKeyExchangeRSA;
import com.certicom.tls.record.handshake.MessageClientMasterKey;
import com.certicom.tls.record.handshake.MessageFinished;
import com.certicom.tls.record.handshake.MessageFinishedVersion2;
import com.certicom.tls.record.handshake.MessageHelloRequest;
import com.certicom.tls.record.handshake.MessageRequestCertificate;
import com.certicom.tls.record.handshake.MessageSSL2Error;
import com.certicom.tls.record.handshake.MessageServerHello;
import com.certicom.tls.record.handshake.MessageServerHelloDone;
import com.certicom.tls.record.handshake.MessageServerHelloVersion2;
import com.certicom.tls.record.handshake.MessageServerKeyExchangeDH;
import com.certicom.tls.record.handshake.MessageServerKeyExchangeRSA;
import com.certicom.tls.record.handshake.MessageServerVerify;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CertificateException;
import java.util.Vector;

abstract class HandshakeMessage
implements Message,
HandshakeTypes,
CryptoNames {
    private byte[] message = null;
    static int maxSSL2HelloMessageComponentLength = 1024;
    static int maxSSL2MasterKeyComponentLength = 4096;
    static int maxClientKeyExchangeMessageLength = 4096;
    static int maxServerKeyExchangeComponentLength = 1024;
    static int maxCertificateVerifySignatureLength = 4096;
    protected ByteArrayOutputStream buffer = null;

    HandshakeMessage() {
    }

    public int getMessageType() {
        return 22;
    }

    public byte[] toByteArray() {
        if (this.message != null) {
            return this.message;
        }
        if (this.buffer == null) {
            this.initMessage();
        }
        byte[] byArray = null;
        if (this.buffer != null) {
            byArray = this.buffer.toByteArray();
        }
        byArray[0] = (byte)this.getHandshakeType();
        if (this.getMessageType() != 0) {
            byte[] byArray2 = Util.toUInt24(this.buffer.size() - 4);
            System.arraycopy(byArray2, 0, byArray, 1, 3);
        }
        this.message = byArray;
        return byArray;
    }

    public int getMessageLength() {
        if (this.buffer == null) {
            this.initMessage();
        }
        return this.buffer.size();
    }

    protected void initBufferVersion2(int n) {
        try {
            this.buffer = new ByteArrayOutputStream(n + 1);
            byte[] byArray = new byte[]{0};
            this.buffer.write(byArray);
        }
        catch (IOException iOException) {
            WeblogicHandler.debugEaten(iOException);
        }
    }

    protected void initBuffer(int n) {
        try {
            this.buffer = new ByteArrayOutputStream(n + 4);
            byte[] byArray = new byte[]{0, 0, 0, 0};
            this.buffer.write(byArray);
        }
        catch (IOException iOException) {
            WeblogicHandler.debugEaten(iOException);
        }
    }

    abstract int getHandshakeType();

    abstract void initMessage();

    static HandshakeMessage create(InputStream inputStream, CipherSuite cipherSuite, ProtocolVersion protocolVersion) throws IllegalArgumentException, IOException, HandshakeWouldBlockException, CertificateException {
        HandshakeMessage handshakeMessage = null;
        int n = inputStream.read();
        byte[] byArray = Util.readBytesLength24(inputStream, TLSSystem.getMaxHandshakeMessageLength());
        if (byArray == null) {
            throw new IllegalArgumentException(Resources.getMessage("277") + " " + TLSSystem.getMaxHandshakeMessageLength());
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        int n2 = cipherSuite.getKeyAgreementAlgorithm();
        switch (n) {
            case 0: {
                if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_INFO)) {
                    WeblogicHandler.debug(WeblogicHandler.DEBUG_INFO, "HANDSHAKEMESSAGE: HelloRequest", null);
                }
                handshakeMessage = new MessageHelloRequest();
                break;
            }
            case 1: {
                if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_INFO)) {
                    WeblogicHandler.debug(WeblogicHandler.DEBUG_INFO, "HANDSHAKEMESSAGE: ClientHello", null);
                }
                handshakeMessage = new MessageClientHello(byteArrayInputStream, protocolVersion);
                break;
            }
            case 2: {
                if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_INFO)) {
                    WeblogicHandler.debug(WeblogicHandler.DEBUG_INFO, "HANDSHAKEMESSAGE: ServerHello", null);
                }
                handshakeMessage = new MessageServerHello(byteArrayInputStream);
                break;
            }
            case 11: {
                if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_INFO)) {
                    WeblogicHandler.debug(WeblogicHandler.DEBUG_INFO, "HANDSHAKEMESSAGE: Certificate", null);
                }
                handshakeMessage = new MessageCertificate(byteArrayInputStream);
                break;
            }
            case 13: {
                if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_INFO)) {
                    WeblogicHandler.debug(WeblogicHandler.DEBUG_INFO, "HANDSHAKEMESSAGE: CertificateRequest", null);
                }
                handshakeMessage = new MessageCertificateRequest(byteArrayInputStream);
                break;
            }
            case 12: {
                if (n2 == 1 || n2 == 9 || n2 == 2 || n2 == 3 || n2 == 10 || n2 == 11 || n2 == 4) {
                    if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_INFO)) {
                        WeblogicHandler.debug(WeblogicHandler.DEBUG_INFO, "HANDSHAKEMESSAGE: ServerKeyExchange DH", null);
                    }
                    handshakeMessage = new MessageServerKeyExchangeDH(byteArrayInputStream);
                    break;
                }
                if (n2 == 7 || n2 == 8) {
                    if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_INFO)) {
                        WeblogicHandler.debug(WeblogicHandler.DEBUG_INFO, "HANDSHAKEMESSAGE: ServerKeyExchange RSA", null);
                    }
                    handshakeMessage = new MessageServerKeyExchangeRSA(byteArrayInputStream);
                    break;
                }
                if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_ERROR)) {
                    WeblogicHandler.debug(WeblogicHandler.DEBUG_ERROR, "HANDSHAKEMESSAGE: ServerKeyExchange UNSUPPORTED KEY EXCHANGE ALGORITHM", null);
                }
                throw new IllegalArgumentException(Resources.getMessage("67"));
            }
            case 14: {
                if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_INFO)) {
                    WeblogicHandler.debug(WeblogicHandler.DEBUG_INFO, "HANDSHAKEMESSAGE: ServerHelloDone", null);
                }
                handshakeMessage = new MessageServerHelloDone();
                break;
            }
            case 16: {
                if (n2 == 1 || n2 == 9 || n2 == 2 || n2 == 3 || n2 == 10 || n2 == 11 || n2 == 4) {
                    if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_INFO)) {
                        WeblogicHandler.debug(WeblogicHandler.DEBUG_INFO, "HANDSHAKEMESSAGE: ClientKeyExchange DH", null);
                    }
                    handshakeMessage = new MessageClientKeyExchangeDH(byteArrayInputStream);
                    break;
                }
                if (n2 == 5 || n2 == 12) {
                    if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_INFO)) {
                        WeblogicHandler.debug(WeblogicHandler.DEBUG_INFO, "HANDSHAKEMESSAGE: ClientKeyExchange ECDH_ECDSA", null);
                    }
                    handshakeMessage = new MessageClientKeyExchangeECDH(byteArrayInputStream);
                    break;
                }
                if (n2 == 6 || n2 == 7 || n2 == 8) {
                    if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_INFO)) {
                        WeblogicHandler.debug(WeblogicHandler.DEBUG_INFO, "HANDSHAKEMESSAGE: ClientKeyExchange RSA", null);
                    }
                    handshakeMessage = new MessageClientKeyExchangeRSA(byteArrayInputStream, protocolVersion);
                    break;
                }
                if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_ERROR)) {
                    WeblogicHandler.debug(WeblogicHandler.DEBUG_ERROR, "HANDSHAKEMESSAGE: ClientKeyExchange UNSUPPORTED ALGORITHM", null);
                }
                throw new IllegalArgumentException(Resources.getMessage("67"));
            }
            case 15: {
                if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_INFO)) {
                    WeblogicHandler.debug(WeblogicHandler.DEBUG_INFO, "HANDSHAKEMESSAGE: CertificateVerify", null);
                }
                handshakeMessage = new MessageCertificateVerify(byteArrayInputStream);
                break;
            }
            case 20: {
                if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_INFO)) {
                    WeblogicHandler.debug(WeblogicHandler.DEBUG_INFO, "HANDSHAKEMESSAGE: Finished", null);
                }
                handshakeMessage = new MessageFinished(byteArrayInputStream, protocolVersion);
                break;
            }
            default: {
                if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_ERROR)) {
                    WeblogicHandler.debug(WeblogicHandler.DEBUG_ERROR, "HANDSHAKEMESSAGE: UNKNOWN !!!", null);
                }
                throw new IllegalArgumentException();
            }
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(byArray.length + 4);
        byteArrayOutputStream.write(n);
        Util.writeBytesLength24(byArray, byteArrayOutputStream);
        handshakeMessage.message = byteArrayOutputStream.toByteArray();
        return handshakeMessage;
    }

    static HandshakeMessage createVersion2(byte[] byArray, Vector vector) throws IllegalArgumentException, IOException, HandshakeWouldBlockException {
        HandshakeMessage handshakeMessage = null;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        int n = byteArrayInputStream.read();
        switch (n) {
            case 1: {
                if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_INFO)) {
                    WeblogicHandler.debug(WeblogicHandler.DEBUG_INFO, "HANDSHAKEMESSAGE: ClientHelloV2", null);
                }
                handshakeMessage = new MessageClientHelloVersion2(byteArrayInputStream, vector);
                break;
            }
            case 2: {
                if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_INFO)) {
                    WeblogicHandler.debug(WeblogicHandler.DEBUG_INFO, "HANDSHAKEMESSAGE: ClientMasterKeyV2", null);
                }
                handshakeMessage = new MessageClientMasterKey(byteArrayInputStream);
                break;
            }
            case 6: {
                if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_INFO)) {
                    WeblogicHandler.debug(WeblogicHandler.DEBUG_INFO, "HANDSHAKEMESSAGE: ServerFinishedV2", null);
                }
                handshakeMessage = new MessageFinishedVersion2(0, byteArrayInputStream);
                break;
            }
            case 3: {
                if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_INFO)) {
                    WeblogicHandler.debug(WeblogicHandler.DEBUG_INFO, "HANDSHAKEMESSAGE: ClientFinishedV2", null);
                }
                handshakeMessage = new MessageFinishedVersion2(1, byteArrayInputStream);
                break;
            }
            case 4: {
                if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_INFO)) {
                    WeblogicHandler.debug(WeblogicHandler.DEBUG_INFO, "HANDSHAKEMESSAGE: ServerHelloV2", null);
                }
                handshakeMessage = new MessageServerHelloVersion2(byteArrayInputStream, vector);
                break;
            }
            case 5: {
                if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_INFO)) {
                    WeblogicHandler.debug(WeblogicHandler.DEBUG_INFO, "HANDSHAKEMESSAGE: ServerVerifyV2", null);
                }
                handshakeMessage = new MessageServerVerify(byteArrayInputStream);
                break;
            }
            case 0: {
                if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_INFO)) {
                    WeblogicHandler.debug(WeblogicHandler.DEBUG_INFO, "HANDSHAKEMESSAGE: ErrorSSLV2", null);
                }
                handshakeMessage = new MessageSSL2Error(byteArrayInputStream);
                break;
            }
            case 7: {
                if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_INFO)) {
                    WeblogicHandler.debug(WeblogicHandler.DEBUG_INFO, "HANDSHAKEMESSAGE: RequestCertificateV2", null);
                }
                handshakeMessage = new MessageRequestCertificate(byteArrayInputStream);
                break;
            }
            case 8: {
                if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_INFO)) {
                    WeblogicHandler.debug(WeblogicHandler.DEBUG_INFO, "HANDSHAKEMESSAGE: ClientCertificateV2, error", null);
                }
                handshakeMessage = new MessageClientCertificate(byteArrayInputStream);
                break;
            }
            default: {
                if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_INFO)) {
                    WeblogicHandler.debug(WeblogicHandler.DEBUG_INFO, "HANDSHAKEMESSAGE: Unknown V2 message?", null);
                }
                throw new IllegalArgumentException();
            }
        }
        handshakeMessage.message = byArray;
        return handshakeMessage;
    }
}

