/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.tls.record.handshake;

import com.bea.sslplus.WeblogicHandler;
import com.certicom.locale.Resources;
import com.certicom.security.cert.internal.x509.X509V3CertImpl;
import com.certicom.tls.interfaceimpl.TLSSystem;
import com.certicom.tls.record.Util;
import com.certicom.tls.record.handshake.HandshakeMessage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Vector;

final class MessageCertificate
extends HandshakeMessage {
    private X509Certificate[] certificateChain;

    MessageCertificate(X509Certificate[] x509CertificateArray) {
        this.certificateChain = x509CertificateArray;
    }

    MessageCertificate(InputStream inputStream) throws IOException, CertificateException {
        byte[] byArray;
        Vector<X509V3CertImpl> vector = new Vector<X509V3CertImpl>();
        int n = Util.readUInt24(inputStream);
        if (n > TLSSystem.getMaxHandshakeMessageLength()) {
            throw new IOException(Resources.getMessage("275") + " " + TLSSystem.getMaxHandshakeMessageLength());
        }
        for (int i = 0; i < n; i += byArray.length + 3) {
            byArray = Util.readBytesLength24(inputStream, n - (i + 3));
            if (byArray == null) {
                throw new IOException(Resources.getMessage("276") + " " + TLSSystem.getMaxHandshakeMessageLength());
            }
            vector.addElement(new X509V3CertImpl(byArray));
        }
        this.certificateChain = new X509Certificate[vector.size()];
        vector.copyInto(this.certificateChain);
    }

    void initMessage() {
        if (this.certificateChain == null) {
            this.initBuffer(3);
            this.buffer.write(0);
            this.buffer.write(0);
            this.buffer.write(0);
            return;
        }
        int n = this.certificateChain.length * 1024;
        this.initBuffer(n);
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n);
            for (int i = 0; i < this.certificateChain.length; ++i) {
                Util.writeBytesLength24(this.certificateChain[i].getEncoded(), byteArrayOutputStream);
            }
            Util.writeBytesLength24(byteArrayOutputStream.toByteArray(), this.buffer);
        }
        catch (IOException iOException) {
            WeblogicHandler.debugEaten(iOException);
        }
        catch (CertificateException certificateException) {
            WeblogicHandler.debugEaten(certificateException);
        }
    }

    int getHandshakeType() {
        return 11;
    }

    public X509Certificate[] getCertificateChain() {
        return this.certificateChain;
    }
}

