/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.tls.record.handshake;

import com.bea.sslplus.WeblogicHandler;
import com.certicom.security.cert.internal.x509.PrincipalImpl;
import com.certicom.tls.ciphersuite.CipherSuite;
import com.certicom.tls.interfaceimpl.TLSSystem;
import com.certicom.tls.record.Util;
import com.certicom.tls.record.handshake.HandshakeHandler;
import com.certicom.tls.record.handshake.HandshakeMessage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.Vector;

final class MessageCertificateRequest
extends HandshakeMessage {
    private PrincipalImpl[] cas;
    private byte[] types;

    MessageCertificateRequest(PrincipalImpl[] principalImplArray, byte[] byArray) {
        this.cas = principalImplArray;
        this.types = byArray;
    }

    MessageCertificateRequest(InputStream inputStream) throws IOException {
        int n = Util.readUInt8(inputStream);
        this.types = new byte[n];
        for (int i = 0; i < n; ++i) {
            this.types[i] = (byte)Util.readUInt8(inputStream);
        }
        Vector<PrincipalImpl> vector = new Vector<PrincipalImpl>();
        n = Util.readUInt16(inputStream);
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            int n4 = Util.readUInt16(inputStream);
            byte[] byArray = new byte[n4];
            inputStream.read(byArray);
            PrincipalImpl principalImpl = new PrincipalImpl(byArray);
            vector.addElement(principalImpl);
            n3 += n4 + 2;
            ++n2;
        }
        if (vector.size() == 0) {
            this.cas = null;
        } else {
            this.cas = new PrincipalImpl[vector.size()];
            for (n2 = 0; n2 < vector.size(); ++n2) {
                this.cas[n2] = (PrincipalImpl)vector.elementAt(n2);
            }
        }
    }

    void initMessage() {
        this.initBuffer(128 * this.cas.length);
        try {
            Util.writeBytesLength8(this.types, this.buffer);
            byte[] byArray = null;
            if (!TLSSystem.getSendEmptyCertRequest()) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                for (int i = 0; i < this.cas.length; ++i) {
                    Util.writeBytesLength16(this.cas[i].getEncoded(), byteArrayOutputStream);
                }
                byArray = byteArrayOutputStream.toByteArray();
            } else {
                byArray = new byte[]{};
            }
            Util.writeBytesLength16(byArray, this.buffer);
        }
        catch (IOException iOException) {
            WeblogicHandler.debugEaten(iOException);
        }
    }

    int getHandshakeType() {
        return 13;
    }

    byte[] getSignatureTypes() {
        return this.types;
    }

    Principal[] getDistinguishedNames() {
        return this.cas;
    }

    public static void findCertificateChainForHandler(HandshakeHandler handshakeHandler) {
        byte[] byArray = handshakeHandler.getClientCertSignatureTypes();
        Principal[] principalArray = handshakeHandler.getClientCertDistinguishedNames();
        CipherSuite cipherSuite = handshakeHandler.getPendingCipherSuite();
        int n = cipherSuite.getKeyAgreementAlgorithm();
        handshakeHandler.setClientCertChain(null);
        if (byArray == null) {
            if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_WARN)) {
                WeblogicHandler.debug(WeblogicHandler.DEBUG_WARN, "Returning no identity certificates, because certificate request message contains no certificate signature types.", null);
            }
            return;
        }
        if (principalArray == null && !TLSSystem.getAcceptEmptyCertRequest()) {
            if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_WARN)) {
                WeblogicHandler.debug(WeblogicHandler.DEBUG_WARN, "Returning no identity certificates, because certificate request message contains no CA names.", null);
            }
            return;
        }
        block7: for (int i = 0; i < byArray.length; ++i) {
            String string;
            switch (byArray[i]) {
                case 1: {
                    string = "RSA";
                    break;
                }
                case 2: {
                    string = "SHA1withDSA";
                    break;
                }
                case 6: {
                    if (n == 5 || n == 12) {
                        string = "HYBRID";
                        handshakeHandler.setRSA_fixed_ECDHFlag(true);
                        break;
                    }
                }
                case 7: {
                    if (n == 5 || n == 12) {
                        string = "EC";
                        handshakeHandler.setECDSA_fixed_ECDHFlag(true);
                        break;
                    }
                }
                case 5: {
                    string = "EC";
                    break;
                }
                default: {
                    string = "";
                }
            }
            if (string.equals("")) continue;
            int n2 = 0;
            while (true) {
                X509Certificate[] x509CertificateArray;
                if ((x509CertificateArray = handshakeHandler.getCertificateSupport().getAuthChain(string, n2)) == null) {
                    if (byArray[i] == 7) {
                        handshakeHandler.setECDSA_fixed_ECDHFlag(false);
                        continue block7;
                    }
                    if (byArray[i] != 6) continue block7;
                    handshakeHandler.setRSA_fixed_ECDHFlag(false);
                    continue block7;
                }
                if (byArray[i] == 7 || byArray[i] == 5) {
                    if (!handshakeHandler.getCertificateSupport().validateECDSA_fixed_ECDH(handshakeHandler.getECDSA_fixed_ECDHFlag(), x509CertificateArray, handshakeHandler.getProtocolVersion())) {
                        handshakeHandler.setECDSA_fixed_ECDHFlag(false);
                        continue block7;
                    }
                } else if (byArray[i] == 6 && !handshakeHandler.getCertificateSupport().validateECDSA_fixed_ECDH(handshakeHandler.getRSA_fixed_ECDHFlag(), x509CertificateArray, handshakeHandler.getProtocolVersion())) {
                    handshakeHandler.setRSA_fixed_ECDHFlag(false);
                    continue block7;
                }
                if (principalArray == null) {
                    if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_INFO)) {
                        WeblogicHandler.debug(WeblogicHandler.DEBUG_INFO, "Returning chain of " + (x509CertificateArray == null ? 0 : x509CertificateArray.length) + " certificates. Certificate request message contained no CA names.", null);
                    }
                    handshakeHandler.setClientCertChain(x509CertificateArray);
                    return;
                }
                for (int j = x509CertificateArray.length - 1; j >= 0; --j) {
                    if (!MessageCertificateRequest.contains(principalArray, x509CertificateArray[j].getIssuerDN()) && (j != 0 || !MessageCertificateRequest.contains(principalArray, x509CertificateArray[j].getSubjectDN()))) continue;
                    if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_INFO)) {
                        WeblogicHandler.debug(WeblogicHandler.DEBUG_INFO, "Returning chain of " + (x509CertificateArray == null ? 0 : x509CertificateArray.length) + " certificates.", null);
                    }
                    handshakeHandler.setClientCertChain(x509CertificateArray);
                    return;
                }
                ++n2;
            }
        }
        if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_WARN)) {
            WeblogicHandler.debug(WeblogicHandler.DEBUG_WARN, "No suitable identity certificate chain has been found.", null);
        }
    }

    private static boolean contains(Principal[] principalArray, Principal principal) {
        for (int i = 0; i < principalArray.length; ++i) {
            if (!((Object)principal).equals(principalArray[i])) continue;
            return true;
        }
        return false;
    }
}

