/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.tls.record.handshake;

import com.bea.sslplus.NCipherAPI;
import com.bea.sslplus.WeblogicHandler;
import com.certicom.tls.ciphersuite.CryptoNames;
import com.certicom.tls.interfaceimpl.ProtocolVersion;
import com.certicom.tls.interfaceimpl.TLSSystem;
import com.certicom.tls.provider.Cipher;
import com.certicom.tls.provider.Signature;
import com.certicom.tls.record.Util;
import com.certicom.tls.record.handshake.HandshakeHandler;
import com.certicom.tls.record.handshake.HandshakeMessage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SignatureException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;

final class MessageCertificateVerify
extends HandshakeMessage
implements CryptoNames {
    private HandshakeHandler handler;
    private ByteArrayInputStream signature;

    MessageCertificateVerify(HandshakeHandler handshakeHandler) {
        this.handler = handshakeHandler;
    }

    MessageCertificateVerify(ByteArrayInputStream byteArrayInputStream) throws IOException {
        this.signature = byteArrayInputStream;
    }

    ByteArrayInputStream getSignature() {
        return this.signature;
    }

    void initMessage() {
        X509Certificate[] x509CertificateArray = this.handler.getClientCertChain();
        String string = x509CertificateArray[0].getPublicKey().getAlgorithm();
        PrivateKey privateKey = this.handler.getCertificateSupport().getPrivateKey(x509CertificateArray[0]);
        ProtocolVersion protocolVersion = this.handler.getProtocolVersion();
        if (string.indexOf("EC") >= 0) {
            try {
                Signature signature = Signature.getInstance("RawECDSA");
                signature.initSign(privateKey, TLSSystem.getRandomNumberGenerator());
                if (protocolVersion.getMajor() == 3 && protocolVersion.getMinor() == 1) {
                    signature.update(this.handler.getSHA1Digest());
                } else if (protocolVersion.getMajor() == 3 && protocolVersion.getMinor() == 0) {
                    signature.update(this.handler.getSHA1Digest());
                }
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                Util.writeBytesLength16(signature.sign(), byteArrayOutputStream);
                byte[] byArray = byteArrayOutputStream.toByteArray();
                this.initBuffer(byArray.length);
                this.buffer.write(byArray);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_INFO)) {
                    WeblogicHandler.debug(WeblogicHandler.DEBUG_INFO, "exception is getting eaten", noSuchAlgorithmException);
                }
                WeblogicHandler.debugEaten(noSuchAlgorithmException);
            }
            catch (InvalidKeyException invalidKeyException) {
                if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_INFO)) {
                    WeblogicHandler.debug(WeblogicHandler.DEBUG_INFO, "exception is getting eaten", invalidKeyException);
                }
                WeblogicHandler.debugEaten(invalidKeyException);
            }
            catch (SignatureException signatureException) {
                if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_INFO)) {
                    WeblogicHandler.debug(WeblogicHandler.DEBUG_INFO, "exception is getting eaten", signatureException);
                }
                WeblogicHandler.debugEaten(signatureException);
            }
            catch (IOException iOException) {
                if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_INFO)) {
                    WeblogicHandler.debug(WeblogicHandler.DEBUG_INFO, "exception is getting eaten", iOException);
                }
                WeblogicHandler.debugEaten(iOException);
            }
        } else if (string.equals("RSA")) {
            try {
                byte[] byArray;
                String string2;
                byte[] byArray2 = null;
                byte[] byArray3 = null;
                if (protocolVersion.getMajor() == 3 && protocolVersion.getMinor() == 1) {
                    byArray2 = this.handler.getMD5Digest();
                    byArray3 = this.handler.getSHA1Digest();
                } else if (protocolVersion.getMajor() == 3 && protocolVersion.getMinor() == 0) {
                    byArray2 = this.handler.getV3CertificateVerifyMD5Hash(this.handler.getMD5Clone());
                    byArray3 = this.handler.getV3CertificateVerifySHAHash(this.handler.getSHAClone());
                }
                if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_INFO)) {
                    WeblogicHandler.debug(WeblogicHandler.DEBUG_INFO, "Private key class is " + privateKey.getClass().getName(), null);
                }
                if ((string2 = privateKey.getClass().getName()).equalsIgnoreCase("com.ncipher.provider.km.KMRSAPrivateCrtKey") || string2.equalsIgnoreCase("com.ncipher.provider.km.KMRSAPrivateKey")) {
                    if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_INFO)) {
                        WeblogicHandler.debug(WeblogicHandler.DEBUG_INFO, "Using NCipher specific CertificateVerify signature code", null);
                    }
                    byArray = NCipherAPI.rsaNCipherSignHandshakeMessageHashes(privateKey, byArray2, byArray3, x509CertificateArray[0].getPublicKey());
                } else {
                    if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_INFO)) {
                        WeblogicHandler.debug(WeblogicHandler.DEBUG_INFO, "Using standard Certicom CertificateVerify code", null);
                    }
                    byArray = this.rsaSignHandshakeMessageHashes(privateKey, byArray2, byArray3);
                }
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                Util.writeBytesLength16(byArray, byteArrayOutputStream);
                byte[] byArray4 = byteArrayOutputStream.toByteArray();
                this.initBuffer(byArray4.length);
                this.buffer.write(byArray4);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_INFO)) {
                    WeblogicHandler.debug(WeblogicHandler.DEBUG_INFO, "exception is getting eaten", noSuchAlgorithmException);
                }
                WeblogicHandler.debugEaten(noSuchAlgorithmException);
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_INFO)) {
                    WeblogicHandler.debug(WeblogicHandler.DEBUG_INFO, "exception is getting eaten", cloneNotSupportedException);
                }
                WeblogicHandler.debugEaten(cloneNotSupportedException);
            }
            catch (InvalidKeyException invalidKeyException) {
                if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_INFO)) {
                    WeblogicHandler.debug(WeblogicHandler.DEBUG_INFO, "exception is getting eaten", invalidKeyException);
                }
                WeblogicHandler.debugEaten(invalidKeyException);
            }
            catch (SignatureException signatureException) {
                if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_INFO)) {
                    WeblogicHandler.debug(WeblogicHandler.DEBUG_INFO, "exception is getting eaten", signatureException);
                }
                WeblogicHandler.debugEaten(signatureException);
            }
            catch (IOException iOException) {
                if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_INFO)) {
                    WeblogicHandler.debug(WeblogicHandler.DEBUG_INFO, "exception is getting eaten", iOException);
                }
                WeblogicHandler.debugEaten(iOException);
            }
        } else if (string.equals("DSA")) {
            try {
                byte[] byArray = null;
                if (protocolVersion.getMajor() == 3 && protocolVersion.getMinor() == 1) {
                    byArray = this.handler.getSHA1Digest();
                } else if (protocolVersion.getMajor() == 3 && protocolVersion.getMinor() == 0) {
                    byArray = this.handler.getV3CertificateVerifySHAHash(this.handler.getSHAClone());
                }
                Signature signature = Signature.getInstance("RawDSA");
                signature.initSign(privateKey, TLSSystem.getRandomNumberGenerator());
                signature.update(byArray);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                Util.writeBytesLength16(signature.sign(), byteArrayOutputStream);
                byte[] byArray5 = byteArrayOutputStream.toByteArray();
                this.initBuffer(byArray5.length);
                this.buffer.write(byArray5);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_INFO)) {
                    WeblogicHandler.debug(WeblogicHandler.DEBUG_INFO, "exception is getting eaten", noSuchAlgorithmException);
                }
                WeblogicHandler.debugEaten(noSuchAlgorithmException);
            }
            catch (InvalidKeyException invalidKeyException) {
                if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_INFO)) {
                    WeblogicHandler.debug(WeblogicHandler.DEBUG_INFO, "exception is getting eaten", invalidKeyException);
                }
                WeblogicHandler.debugEaten(invalidKeyException);
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_INFO)) {
                    WeblogicHandler.debug(WeblogicHandler.DEBUG_INFO, "exception is getting eaten", cloneNotSupportedException);
                }
                WeblogicHandler.debugEaten(cloneNotSupportedException);
            }
            catch (SignatureException signatureException) {
                if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_INFO)) {
                    WeblogicHandler.debug(WeblogicHandler.DEBUG_INFO, "exception is getting eaten", signatureException);
                }
                WeblogicHandler.debugEaten(signatureException);
            }
            catch (IOException iOException) {
                if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_INFO)) {
                    WeblogicHandler.debug(WeblogicHandler.DEBUG_INFO, "exception is getting eaten", iOException);
                }
                WeblogicHandler.debugEaten(iOException);
            }
        }
    }

    private byte[] rsaSignHandshakeMessageHashes(PrivateKey privateKey, byte[] byArray, byte[] byArray2) throws NoSuchAlgorithmException, InvalidKeyException {
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        int n = (((RSAPrivateKey)privateKey).getModulus().bitLength() + 7) / 8;
        byte[] byArray4 = this.handler.addPKCS1Padding(n, byArray3);
        Cipher cipher = Cipher.getInstance("RSA/ECB/NoPadding");
        cipher.init(1, (Key)privateKey, TLSSystem.getRandomNumberGenerator());
        return cipher.doFinal(byArray4, 0, byArray4.length);
    }

    int getHandshakeType() {
        return 15;
    }
}

