/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.tls.record.handshake;

import com.certicom.locale.Resources;
import com.certicom.security.cert.internal.x509.X509V3CertImpl;
import com.certicom.tls.interfaceimpl.CertificateSupport;
import com.certicom.tls.interfaceimpl.TLSSystem;
import com.certicom.tls.provider.Cipher;
import com.certicom.tls.provider.MessageDigest;
import com.certicom.tls.record.Util;
import com.certicom.tls.record.handshake.HandshakeHandler;
import com.certicom.tls.record.handshake.HandshakeMessage;
import java.io.IOException;
import java.io.InputStream;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;

final class MessageClientCertificate
extends HandshakeMessage {
    private int CertificateType;
    private byte[] Certificate_Challenge;
    private byte[] Response_data;
    private byte[][] KeyMaterials;
    private X509Certificate Client_Certificate;
    private X509Certificate Server_Certificate;
    private HandshakeHandler handler;
    private final byte[] MD5Encode = new byte[]{48, 32, 48, 12, 6, 8, 42, -122, 72, -122, -9, 13, 2, 5, 5, 0, 4, 16};

    MessageClientCertificate(int n, byte[] byArray, HandshakeHandler handshakeHandler, X509Certificate x509Certificate) {
        this.CertificateType = n;
        this.Certificate_Challenge = byArray;
        this.Client_Certificate = x509Certificate;
        this.handler = handshakeHandler;
        this.KeyMaterials = this.getKeyMaterial(handshakeHandler);
        this.Server_Certificate = handshakeHandler.getServerCertificate();
    }

    MessageClientCertificate(InputStream inputStream) throws IOException {
        this.CertificateType = Util.readUInt8(inputStream);
        int n = Util.readUInt16(inputStream);
        int n2 = Util.readUInt16(inputStream);
        try {
            byte[] byArray = new byte[n];
            Util.readFully(byArray, inputStream);
            this.Response_data = new byte[n2];
            Util.readFully(this.Response_data, inputStream);
            this.Client_Certificate = new X509V3CertImpl(byArray);
        }
        catch (Exception exception) {
            throw new IOException(Resources.getMessage("267"));
        }
    }

    public int getHandshakeType() {
        return 8;
    }

    public PublicKey getClientPublicKey() {
        return this.Client_Certificate.getPublicKey();
    }

    public int VerifyResponseData(byte[] byArray, HandshakeHandler handshakeHandler) {
        if (this.CertificateType == 1) {
            try {
                this.KeyMaterials = this.getKeyMaterial(handshakeHandler);
                this.Certificate_Challenge = byArray;
                CertificateSupport certificateSupport = handshakeHandler.getCertificateSupport();
                this.Server_Certificate = certificateSupport.getAuthChain("RSA", 0)[0];
                Cipher cipher = Cipher.getInstance("RSA/ECB/NoPadding");
                cipher.init(2, (Key)this.getClientPublicKey(), TLSSystem.getRandomNumberGenerator());
                byte[] byArray2 = cipher.doFinal(this.Response_data, 0, this.Response_data.length);
                byte[] byArray3 = handshakeHandler.removePKCS1Padding(byArray2);
                byte[] byArray4 = this.generateResponseData();
                if (!handshakeHandler.isEqual(byArray3, 0, byArray3.length, byArray4, 0, byArray4.length)) {
                    return 264;
                }
                X509Certificate[][] x509CertificateArray = new X509Certificate[][]{{this.Client_Certificate}};
                if (!certificateSupport.isClientTrusted(x509CertificateArray, handshakeHandler.getPendingCipherSuite().getDescription(), handshakeHandler.getProtocolVersion(), handshakeHandler.getConnectionImpl().getCertificateCallbackRef(), handshakeHandler.getConnectionImpl().getSSLSocket())) {
                    return 265;
                }
                return 0;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            return 266;
        }
        return 0;
    }

    private byte[] AppendMD5(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length + this.MD5Encode.length];
        System.arraycopy(this.MD5Encode, 0, byArray2, 0, this.MD5Encode.length);
        System.arraycopy(byArray, 0, byArray2, this.MD5Encode.length, byArray.length);
        return byArray2;
    }

    public int getMessageType() {
        return 0;
    }

    private byte[][] getKeyMaterial(HandshakeHandler handshakeHandler) {
        return handshakeHandler.getSecurityParameters().getKeyMaterial();
    }

    private byte[] generateResponseData() {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            for (int i = 0; i < this.KeyMaterials.length; ++i) {
                messageDigest.update(this.KeyMaterials[i]);
            }
            messageDigest.update(this.Certificate_Challenge);
            messageDigest.update(this.Server_Certificate.getEncoded());
            byte[] byArray = messageDigest.digest();
            byArray = this.AppendMD5(byArray);
            return byArray;
        }
        catch (Exception exception) {
            return null;
        }
    }

    void initMessage() {
        try {
            byte[] byArray = this.Client_Certificate.getEncoded();
            int n = byArray.length;
            PrivateKey privateKey = this.handler.getCertificateSupport().getPrivateKey(this.Client_Certificate);
            int n2 = (((RSAPrivateKey)privateKey).getModulus().bitLength() + 7) / 8;
            this.Response_data = this.handler.addPKCS1Padding(n2, this.generateResponseData());
            Cipher cipher = Cipher.getInstance("RSA/ECB/NoPadding");
            cipher.init(1, (Key)privateKey, TLSSystem.getRandomNumberGenerator());
            byte[] byArray2 = cipher.doFinal(this.Response_data, 0, this.Response_data.length);
            this.initBufferVersion2(byArray2.length + n + 5);
            Util.writeUInt8(this.CertificateType, this.buffer);
            Util.writeUInt16(n, this.buffer);
            Util.writeUInt16(byArray2.length, this.buffer);
            this.buffer.write(byArray);
            this.buffer.write(byArray2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

