/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.tls.record.handshake;

import com.bea.sslplus.WeblogicHandler;
import com.certicom.tls.ciphersuite.CipherSuite;
import com.certicom.tls.ciphersuite.CipherSuiteSupport;
import com.certicom.tls.interfaceimpl.ProtocolVersion;
import com.certicom.tls.interfaceimpl.SessionID;
import com.certicom.tls.record.Util;
import com.certicom.tls.record.handshake.HandshakeMessage;
import com.certicom.tls.record.handshake.MessageRandom;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.util.Vector;

final class MessageClientHello
extends HandshakeMessage {
    private SessionID sessionID;
    private CipherSuite[] cipherSuites;
    private MessageRandom random;
    private ProtocolVersion protocolVersion;

    MessageClientHello(SessionID sessionID, CipherSuite[] cipherSuiteArray, ProtocolVersion protocolVersion, MessageRandom messageRandom) {
        this.sessionID = sessionID;
        this.cipherSuites = cipherSuiteArray;
        this.protocolVersion = protocolVersion;
        this.random = messageRandom;
    }

    MessageClientHello(InputStream inputStream, ProtocolVersion protocolVersion) throws IOException, IllegalArgumentException {
        this.protocolVersion = new ProtocolVersion(inputStream, protocolVersion);
        this.random = new MessageRandom(inputStream);
        this.sessionID = new SessionID(inputStream);
        int n = Util.readUInt16(inputStream) / 2;
        Vector<CipherSuite> vector = new Vector<CipherSuite>(n);
        for (int i = 0; i < n; ++i) {
            try {
                CipherSuite cipherSuite = CipherSuiteSupport.getCipherSuite(inputStream, ProtocolVersion.TLS10);
                vector.addElement(cipherSuite);
                continue;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                WeblogicHandler.debugEaten(noSuchAlgorithmException);
            }
        }
        this.cipherSuites = new CipherSuite[vector.size()];
        vector.copyInto(this.cipherSuites);
        inputStream.read();
        inputStream.read();
    }

    void initMessage() {
        this.initBuffer(128);
        try {
            this.buffer.write(this.protocolVersion.toByteArray());
            this.buffer.write(this.random.toByteArray());
            this.buffer.write(this.sessionID.toByteArray());
            this.buffer.write(Util.toUInt16(2 * this.cipherSuites.length));
            for (int i = 0; i < this.cipherSuites.length; ++i) {
                int n = this.cipherSuites[i].getTag();
                this.buffer.write(n >> 8);
                this.buffer.write(n);
            }
            this.buffer.write(1);
            this.buffer.write(0);
        }
        catch (IOException iOException) {
            WeblogicHandler.debugEaten(iOException);
        }
    }

    SessionID getSessionID() {
        return this.sessionID;
    }

    MessageRandom getRandom() {
        return this.random;
    }

    ProtocolVersion getProtocolVersion() {
        return this.protocolVersion;
    }

    CipherSuite[] getCipherSuites() {
        return this.cipherSuites;
    }

    int getHandshakeType() {
        return 1;
    }
}

