/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.tls.record.handshake;

import com.bea.sslplus.WeblogicHandler;
import com.certicom.locale.Resources;
import com.certicom.tls.ciphersuite.CipherSuite;
import com.certicom.tls.ciphersuite.CipherSuiteSupport;
import com.certicom.tls.interfaceimpl.ProtocolVersion;
import com.certicom.tls.interfaceimpl.ProtocolVersions;
import com.certicom.tls.interfaceimpl.SessionID;
import com.certicom.tls.record.Util;
import com.certicom.tls.record.handshake.HandshakeMessage;
import com.certicom.tls.record.handshake.MapCipher;
import com.certicom.tls.record.handshake.MessageClientHello;
import com.certicom.tls.record.handshake.MessageRandom;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.util.Vector;

final class MessageClientHelloVersion2
extends HandshakeMessage {
    private byte[] sessionID;
    private CipherSuite[] cipherSuites;
    private byte[] challenge;
    private ProtocolVersion protocolVersion;

    MessageClientHelloVersion2(SessionID sessionID, CipherSuite[] cipherSuiteArray, ProtocolVersion protocolVersion, byte[] byArray) {
        this.sessionID = sessionID.getID();
        this.cipherSuites = cipherSuiteArray;
        this.protocolVersion = protocolVersion;
        this.challenge = byArray;
    }

    MessageClientHelloVersion2(InputStream inputStream, Vector vector) throws IOException, IllegalArgumentException {
        this.protocolVersion = new ProtocolVersion(inputStream);
        int n = Util.readUInt16(inputStream);
        int n2 = Util.readUInt16(inputStream);
        int n3 = Util.readUInt16(inputStream);
        if (n > maxSSL2HelloMessageComponentLength || n < 0 || n % 3 != 0 || n2 != 0 && n2 != 16 || n3 < 16 || n3 > 32) {
            throw new IOException(Resources.getMessage("278"));
        }
        int n4 = n / 3;
        Vector<CipherSuite> vector2 = new Vector<CipherSuite>(n4);
        for (int i = 0; i < n4; ++i) {
            try {
                CipherSuite cipherSuite;
                if (this.protocolVersion.equals(ProtocolVersions.SSL20)) {
                    int n5 = inputStream.read() << 16 | inputStream.read() << 8 | inputStream.read();
                    int n6 = MapCipher.mapCipherToTLS(n5);
                    cipherSuite = CipherSuiteSupport.getCipherSuite(n6);
                } else {
                    cipherSuite = CipherSuiteSupport.getCipherSuite(inputStream, ProtocolVersions.SSL20);
                }
                if (!vector.contains(cipherSuite)) continue;
                vector2.addElement(cipherSuite);
                continue;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                WeblogicHandler.debugEaten(noSuchAlgorithmException);
            }
        }
        this.cipherSuites = new CipherSuite[vector2.size()];
        vector2.copyInto(this.cipherSuites);
        this.sessionID = new byte[n2];
        Util.readFully(this.sessionID, inputStream);
        this.challenge = new byte[n3];
        Util.readFully(this.challenge, inputStream);
    }

    MessageClientHello createTLSClientHello() throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(32);
        if (this.challenge.length <= 32) {
            for (n = 0; n < 32 - this.challenge.length; ++n) {
                byteArrayOutputStream.write(0);
            }
            byteArrayOutputStream.write(this.challenge);
        } else {
            for (n = this.challenge.length - 32; n < this.challenge.length; ++n) {
                byteArrayOutputStream.write(this.challenge[n]);
            }
        }
        MessageRandom messageRandom = new MessageRandom(byteArrayOutputStream.toByteArray());
        byteArrayOutputStream.reset();
        SessionID sessionID = new SessionID(this.sessionID);
        MessageClientHello messageClientHello = new MessageClientHello(sessionID, this.cipherSuites, this.protocolVersion, messageRandom);
        return messageClientHello;
    }

    void initMessage() {
        this.initBufferVersion2(128);
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            block6: for (int i = 0; i < this.cipherSuites.length; ++i) {
                int n = this.cipherSuites[i].getTag();
                if (!this.protocolVersion.equals(ProtocolVersions.SSL20)) {
                    byteArrayOutputStream.write(n >> 16);
                    byteArrayOutputStream.write(n >> 8);
                    byteArrayOutputStream.write(n);
                }
                switch (n) {
                    case 4: {
                        byteArrayOutputStream.write(1);
                        byteArrayOutputStream.write(0);
                        byteArrayOutputStream.write(128);
                        continue block6;
                    }
                    case 3: {
                        byteArrayOutputStream.write(2);
                        byteArrayOutputStream.write(0);
                        byteArrayOutputStream.write(128);
                    }
                }
            }
            this.buffer.write(this.protocolVersion.toByteArray());
            Util.writeUInt16(byteArrayOutputStream.size(), this.buffer);
            Util.writeUInt16(this.sessionID.length, this.buffer);
            Util.writeUInt16(this.challenge.length, this.buffer);
            this.buffer.write(byteArrayOutputStream.toByteArray());
            this.buffer.write(this.sessionID);
            this.buffer.write(this.challenge);
        }
        catch (IOException iOException) {
            WeblogicHandler.debugEaten(iOException);
        }
    }

    byte[] getSessionID() {
        return this.sessionID;
    }

    public int getMessageType() {
        return 0;
    }

    ProtocolVersion getProtocolVersion() {
        return this.protocolVersion;
    }

    byte[] getChallenge() {
        return this.challenge;
    }

    CipherSuite[] getCipherSuites() {
        return this.cipherSuites;
    }

    int getHandshakeType() {
        return 1;
    }
}

