/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.tls.record.handshake;

import com.bea.sslplus.WeblogicHandler;
import com.certicom.locale.Resources;
import com.certicom.tls.record.Util;
import com.certicom.tls.record.handshake.HandshakeMessage;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;

final class MessageClientKeyExchangeDH
extends HandshakeMessage {
    BigInteger y;

    MessageClientKeyExchangeDH(BigInteger bigInteger) {
        this.y = bigInteger;
    }

    MessageClientKeyExchangeDH(InputStream inputStream) throws IOException {
        byte[] byArray = Util.readBytesLength16(inputStream, maxClientKeyExchangeMessageLength);
        if (byArray == null) {
            throw new IOException(Resources.getMessage("279"));
        }
        this.y = new BigInteger(1, byArray);
    }

    void initMessage() {
        this.initBuffer(1024);
        try {
            Util.writeBytesLength16(Util.toUnsignedInteger(this.y), this.buffer);
        }
        catch (IOException iOException) {
            WeblogicHandler.debugEaten(iOException);
        }
    }

    BigInteger getY() {
        return this.y;
    }

    int getHandshakeType() {
        return 16;
    }
}

