/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.tls.record.handshake;

import com.bea.sslplus.WeblogicHandler;
import com.certicom.security.asn1.ASN1ParsingException;
import com.certicom.security.asn1.DERInputStream;
import com.certicom.security.pkix.SubjectPublicKeyInfo;
import com.certicom.tls.provider.KeyFactory;
import com.certicom.tls.provider.spec.ECCpresso_ECPublicKey;
import com.certicom.tls.record.Util;
import com.certicom.tls.record.handshake.HandshakeMessage;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;

final class MessageClientKeyExchangeECDH
extends HandshakeMessage {
    private PublicKey pub_key = null;
    private boolean preferCompressed = false;

    MessageClientKeyExchangeECDH(PublicKey publicKey, boolean bl) {
        this.pub_key = publicKey;
        this.preferCompressed = bl;
    }

    MessageClientKeyExchangeECDH() {
        this.pub_key = null;
    }

    MessageClientKeyExchangeECDH(InputStream inputStream) throws IOException {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("EC");
            int n = Util.readUInt8(inputStream);
            this.pub_key = n == 0 ? ((n = Util.readUInt8(inputStream)) > 0 ? keyFactory.createPublicKey(Util.readBytes(inputStream, n), "RAW") : null) : (n > 0 ? keyFactory.createPublicKey(Util.readBytes(inputStream, n), "RAW") : null);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            WeblogicHandler.debugEaten(noSuchAlgorithmException);
            throw new IOException(noSuchAlgorithmException.getMessage());
        }
    }

    public PublicKey getY() {
        return this.pub_key;
    }

    void initMessage() {
        if (this.pub_key != null) {
            byte[] byArray;
            if (this.pub_key instanceof ECCpresso_ECPublicKey) {
                String string = System.getProperty("UsePointCompression");
                String string2 = System.getProperty("GuessPointCompression");
                int n = string2.equalsIgnoreCase("yes") ? (this.preferCompressed ? 2 : 4) : (string.equalsIgnoreCase("yes") ? 2 : 4);
                byArray = ((ECCpresso_ECPublicKey)this.pub_key).getEncoded(n);
            } else {
                byArray = this.pub_key.getEncoded();
            }
            try {
                byte[] byArray2;
                int n = byArray.length;
                if (this.pub_key.getFormat().equals("X.509")) {
                    byArray2 = this.getRawKey(byArray);
                    n = byArray2.length;
                } else {
                    byArray2 = byArray;
                }
                this.initBuffer(n);
                Util.writeBytesLength8(byArray2, this.buffer);
            }
            catch (IOException iOException) {
            }
            catch (ASN1ParsingException aSN1ParsingException) {
                aSN1ParsingException.getMessage();
            }
        } else {
            this.initBuffer(0);
        }
    }

    private byte[] getRawKey(byte[] byArray) throws ASN1ParsingException {
        try {
            DERInputStream dERInputStream = new DERInputStream(byArray);
            SubjectPublicKeyInfo subjectPublicKeyInfo = new SubjectPublicKeyInfo();
            subjectPublicKeyInfo.decode(dERInputStream);
            byte[] byArray2 = subjectPublicKeyInfo.getKey();
            return byArray2;
        }
        catch (ASN1ParsingException aSN1ParsingException) {
            throw new ASN1ParsingException();
        }
    }

    int getHandshakeType() {
        return 16;
    }
}

